<?php
/**
 * login.php - Page de connexion Radio SMG Studio
 * Version corrigée qui utilise config/auth_check.php
 */

require_once __DIR__ . '/config/auth_check.php';

// Si déjà connecté, rediriger
if (Auth::check()) {
    header('Location: /document/voir.php');
    exit;
}

$error = '';
$success = '';

// Traitement du formulaire de connexion
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';
    
    if ($email && $password) {
        $result = Auth::attempt($email, $password);
        
        if ($result['success']) {
            // Redirection après login réussi
            $redirect = $_SESSION['redirect_after_login'] ?? '/document/voir.php';
            unset($_SESSION['redirect_after_login']);
            
            header("Location: $redirect");
            exit;
        } else {
            $error = $result['error'];
        }
    } else {
        $error = "Veuillez remplir tous les champs";
    }
}

// Messages d'erreur spécifiques
if (isset($_GET['timeout'])) {
    $error = "Session expirée. Veuillez vous reconnecter.";
}
if (isset($_GET['inactive'])) {
    $error = "Votre compte a été désactivé.";
}
if (isset($_GET['expired'])) {
    $error = "Votre session a expiré. Veuillez vous reconnecter.";
}

?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Connexion -  SMG Studio</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 50%, #f093fb 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        .welcome-banner {
            position: absolute;
            top: 20px;
            left: 50%;
            transform: translateX(-50%);
            background: rgba(255, 255, 255, 0.9);
            padding: 15px 30px;
            border-radius: 25px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            text-align: center;
            font-weight: 600;
            color: #333;
            backdrop-filter: blur(10px);
        }
        .login-container {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(20px);
            padding: 40px;
            border-radius: 20px;
            box-shadow: 0 25px 50px rgba(0, 0, 0, 0.2);
            width: 100%;
            max-width: 400px;
            border: 1px solid rgba(255, 255, 255, 0.3);
        }
        .logo {
            text-align: center;
            margin-bottom: 20px;
            font-size: 3rem;
            animation: bounce 2s infinite;
        }
        @keyframes bounce {
            0%, 20%, 50%, 80%, 100% { transform: translateY(0); }
            40% { transform: translateY(-10px); }
            60% { transform: translateY(-5px); }
        }
        h1 {
            text-align: center;
            margin-bottom: 30px;
            color: #333;
            font-size: 1.8rem;
            font-weight: 700;
        }
        .form-group {
            margin-bottom: 20px;
        }
        label {
            display: block;
            margin-bottom: 8px;
            color: #555;
            font-weight: 600;
        }
        input[type="email"], input[type="password"] {
            width: 100%;
            padding: 15px;
            border: 2px solid #e1e5e9;
            border-radius: 10px;
            font-size: 16px;
            transition: all 0.3s ease;
            background: rgba(255, 255, 255, 0.8);
        }
        input[type="email"]:focus, input[type="password"]:focus {
            outline: none;
            border-color: #667eea;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
            transform: translateY(-1px);
        }
        .btn-login {
            width: 100%;
            padding: 15px;
            background: linear-gradient(45deg, #667eea, #764ba2);
            color: white;
            border: none;
            border-radius: 10px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        .btn-login:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 25px rgba(102, 126, 234, 0.3);
        }
        .btn-login:active {
            transform: translateY(0);
        }
        .error {
            color: #e74c3c;
            text-align: center;
            margin-bottom: 20px;
            padding: 15px;
            background: rgba(231, 76, 60, 0.1);
            border-radius: 10px;
            border: 1px solid rgba(231, 76, 60, 0.2);
            font-weight: 500;
        }
        .success {
            color: #27ae60;
            text-align: center;
            margin-bottom: 20px;
            padding: 15px;
            background: rgba(39, 174, 96, 0.1);
            border-radius: 10px;
            border: 1px solid rgba(39, 174, 96, 0.2);
            font-weight: 500;
        }
        .footer {
            text-align: center;
            margin-top: 20px;
            color: rgba(255, 255, 255, 0.8);
            font-size: 0.9em;
        }
        .loading {
            display: none;
            text-align: center;
            color: #667eea;
            margin-top: 10px;
        }
        .spinner {
            display: inline-block;
            width: 20px;
            height: 20px;
            border: 3px solid #f3f3f3;
            border-top: 3px solid #667eea;
            border-radius: 50%;
            animation: spin 1s linear infinite;
            margin-right: 10px;
        }
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        
        @media (max-width: 480px) {
            .welcome-banner {
                position: relative;
                top: 0;
                transform: none;
                margin-bottom: 20px;
            }
            .login-container {
                padding: 30px 20px;
            }
        }
    </style>
</head>
<body>
    <div class="welcome-banner">
        🧠 Bienvenue dans les slides IA privées de SMG Studio ! 🎪
    </div>
    
    <div class="login-container">
        <div class="logo">📚🎪</div>
        <h1> SMG Studio</h1>
        
        <?php if ($error): ?>
            <div class="error">❌ <?= htmlspecialchars($error) ?></div>
        <?php endif; ?>
        
        <?php if ($success): ?>
            <div class="success">✅ <?= htmlspecialchars($success) ?></div>
        <?php endif; ?>
        
        <form method="POST" id="loginForm">
            <?= csrfField() ?>
            
            <div class="form-group">
                <label for="email">📧 Email :</label>
                <input type="email" id="email" name="email" required 
                       value="<?= htmlspecialchars($_POST['email'] ?? '') ?>"
                       placeholder="votre@email.com">
            </div>
            
            <div class="form-group">
                <label for="password">🔒 Mot de passe :</label>
                <input type="password" id="password" name="password" required
                       placeholder="••••••••">
            </div>
            
            <button type="submit" class="btn-login" id="submitBtn">
                🚀 Se connecter
            </button>
            
            <div class="loading" id="loading">
                <div class="spinner"></div>
                Connexion en cours...
            </div>
        </form>
        
        <div class="footer">
            Développé avec ❤️ par  SMG Studio v2.0<br>
            <small>AI Social Media Generator - Audiovizu Edition</small>
        </div>
    </div>

    <script>
        // Animation du formulaire
        document.getElementById('loginForm').addEventListener('submit', function() {
            const submitBtn = document.getElementById('submitBtn');
            const loading = document.getElementById('loading');
            
            submitBtn.style.display = 'none';
            loading.style.display = 'block';
        });
        
        // Auto-focus sur le premier champ vide
        window.addEventListener('load', function() {
            const emailField = document.getElementById('email');
            const passwordField = document.getElementById('password');
            
            if (!emailField.value) {
                emailField.focus();
            } else {
                passwordField.focus();
            }
        });
        
        // Effets visuels sur les inputs
        document.querySelectorAll('input').forEach(input => {
            input.addEventListener('focus', function() {
                this.parentElement.style.transform = 'scale(1.02)';
            });
            
            input.addEventListener('blur', function() {
                this.parentElement.style.transform = 'scale(1)';
            });
        });
    </script>
</body>
</html>