<?php
/**
 * Script de test pour la configuration email
 * Testez votre configuration SMTP avant la mise en production
 */

require_once '../utils/EnhancedEmailManager.php';

// Activer l'affichage des erreurs pour les tests
ini_set('display_errors', 1);
error_reporting(E_ALL);

echo "<h1>🧪 Test de Configuration Email - Social Media Generator</h1>";
echo "<style>
    body { font-family: Arial, sans-serif; max-width: 800px; margin: 20px auto; padding: 20px; }
    .success { color: #28a745; background: #d4edda; padding: 10px; border-radius: 5px; margin: 10px 0; }
    .error { color: #dc3545; background: #f8d7da; padding: 10px; border-radius: 5px; margin: 10px 0; }
    .warning { color: #856404; background: #fff3cd; padding: 10px; border-radius: 5px; margin: 10px 0; }
    .info { color: #0c5460; background: #d1ecf1; padding: 10px; border-radius: 5px; margin: 10px 0; }
    pre { background: #f8f9fa; padding: 15px; border-radius: 5px; overflow-x: auto; }
    .test-section { border: 1px solid #dee2e6; border-radius: 8px; padding: 20px; margin: 20px 0; }
    .step { margin: 15px 0; padding: 10px; border-left: 4px solid #667eea; background: #f8f9fa; }
    button { cursor: pointer; }
    input[type='email'], input[type='text'] { border: 1px solid #ddd; border-radius: 4px; }
</style>";

echo "<div class='info'>
    <strong>📋 Instructions :</strong><br>
    1. Configurez votre fichier .env avec vos paramètres SMTP<br>
    2. Modifiez l'email de test ci-dessous<br>
    3. Exécutez ce script pour vérifier votre configuration
</div>";

// EMAIL DE TEST - MODIFIER ICI
$testEmail = 'votre-email-test@gmail.com';
$testName = 'Utilisateur Test';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['run_tests'])) {
    runEmailTests();
} else {
    showTestForm($testEmail);
}

function showTestForm($defaultEmail) {
    echo "<div class='test-section'>";
    echo "<h2>🔧 Configuration du Test</h2>";
    echo "<form method='POST'>";
    echo "<p><label for='test_email'>Email de test :</label><br>";
    echo "<input type='email' id='test_email' name='test_email' value='$defaultEmail' style='width: 300px; padding: 8px; margin: 5px 0;' required></p>";
    echo "<p><label for='test_name'>Nom de test :</label><br>";
    echo "<input type='text' id='test_name' name='test_name' value='Utilisateur Test' style='width: 300px; padding: 8px; margin: 5px 0;' required></p>";
    echo "<button type='submit' name='run_tests' style='background: #667eea; color: white; padding: 10px 20px; border: none; border-radius: 5px; cursor: pointer;'>🚀 Lancer les Tests</button>";
    echo "</form>";
    echo "</div>";
}

function runEmailTests() {
    echo "<div class='test-section'>";
    echo "<h2>🧪 Résultats des Tests</h2>";
    
    $testEmail = $_POST['test_email'] ?? 'test@example.com';
    $testName = $_POST['test_name'] ?? 'Utilisateur Test';
    
    echo "<div class='step'><strong>📧 Email de test :</strong> $testEmail</div>";
    
    try {
        // Test 1: Chargement des dépendances
        echo "<h3>📦 Test 1: Chargement des dépendances</h3>";
        
        if (!file_exists('../vendor/autoload.php')) {
            echo "<div class='error'>❌ PHPMailer non installé. Exécutez: <code>composer require phpmailer/phpmailer</code></div>";
            return;
        }
        echo "<div class='success'>✅ Composer autoload trouvé</div>";
        
        if (!file_exists('../config/email_config.php')) {
            echo "<div class='error'>❌ Fichier de configuration email manquant: ../config/email_config.php</div>";
            return;
        }
        echo "<div class='success'>✅ Configuration email trouvée</div>";
        
        if (!file_exists('../utils/EnhancedEmailManager.php')) {
            echo "<div class='error'>❌ EnhancedEmailManager manquant: ../utils/EnhancedEmailManager.php</div>";
            return;
        }
        echo "<div class='success'>✅ EnhancedEmailManager trouvé</div>";
        
        // Test 2: Initialisation
        echo "<h3>⚙️ Test 2: Initialisation du gestionnaire email</h3>";
        
        try {
            $emailManager = new EnhancedEmailManager();
            echo "<div class='success'>✅ EmailManager initialisé avec succès</div>";
        } catch (Exception $e) {
            echo "<div class='error'>❌ Erreur d'initialisation: " . $e->getMessage() . "</div>";
            return;
        }
        
        // Test 3: Configuration SMTP
        echo "<h3>🌐 Test 3: Test de connexion SMTP</h3>";
        
        $configTest = $emailManager->testConfiguration();
        if ($configTest['success']) {
            echo "<div class='success'>✅ Connexion SMTP réussie</div>";
        } else {
            echo "<div class='error'>❌ Erreur SMTP: " . $configTest['message'] . "</div>";
            echo "<div class='warning'>💡 Vérifiez vos paramètres SMTP dans le fichier .env</div>";
        }
        
        // Test 4: Variables d'environnement
        echo "<h3>🔐 Test 4: Variables d'environnement</h3>";
        
        $requiredEnvVars = [
            'SMTP_HOST' => $_ENV['SMTP_HOST'] ?? 'Non défini',
            'SMTP_USERNAME' => $_ENV['SMTP_USERNAME'] ?? 'Non défini',
            'SMTP_PASSWORD' => $_ENV['SMTP_PASSWORD'] ?? 'Non défini',
            'SMTP_PORT' => $_ENV['SMTP_PORT'] ?? 'Non défini',
            'MAIL_FROM_ADDRESS' => $_ENV['MAIL_FROM_ADDRESS'] ?? 'Non défini'
        ];
        
        $envOk = true;
        foreach ($requiredEnvVars as $var => $value) {
            if ($value === 'Non défini' || empty($value)) {
                echo "<div class='error'>❌ Variable manquante: $var</div>";
                $envOk = false;
            } else {
                $displayValue = $var === 'SMTP_PASSWORD' ? '***masqué***' : $value;
                echo "<div class='success'>✅ $var: $displayValue</div>";
            }
        }
        
        if (!$envOk) {
            echo "<div class='warning'>💡 Configurez les variables manquantes dans votre fichier .env</div>";
        }
        
        // Test 5: Templates
        echo "<h3>📄 Test 5: Vérification des templates</h3>";
        
        $templatePath = '../templates/emails/activation_email.html';
        if (file_exists($templatePath)) {
            echo "<div class='success'>✅ Template d'activation trouvé</div>";
            
            $templateSize = filesize($templatePath);
            echo "<div class='info'>📏 Taille du template: " . round($templateSize/1024, 2) . " KB</div>";
            
        } else {
            echo "<div class='error'>❌ Template d'activation manquant: $templatePath</div>";
            echo "<div class='warning'>💡 Créez le dossier et le fichier template</div>";
        }
        
        // Test 6: Répertoire de logs
        echo "<h3>📊 Test 6: Système de logs</h3>";
        
        $logDir = '../logs';
        if (!is_dir($logDir)) {
            if (mkdir($logDir, 0755, true)) {
                echo "<div class='success'>✅ Répertoire de logs créé</div>";
            } else {
                echo "<div class='error'>❌ Impossible de créer le répertoire de logs</div>";
            }
        } else {
            echo "<div class='success'>✅ Répertoire de logs existe</div>";
        }
        
        if (is_writable($logDir)) {
            echo "<div class='success'>✅ Répertoire de logs accessible en écriture</div>";
        } else {
            echo "<div class='error'>❌ Répertoire de logs non accessible en écriture</div>";
        }
        
        // Test 7: Envoi d'email de test
        echo "<h3>📨 Test 7: Envoi d'email de test</h3>";
        
        if ($configTest['success'] && $envOk && file_exists($templatePath)) {
            echo "<form method='POST' style='margin: 10px 0;'>";
            echo "<input type='hidden' name='test_email' value='$testEmail'>";
            echo "<input type='hidden' name='test_name' value='$testName'>";
            echo "<button type='submit' name='send_test_email' style='background: #28a745; color: white; padding: 8px 16px; border: none; border-radius: 4px; cursor: pointer;'>📧 Envoyer un email de test d'activation</button>";
            echo "</form>";
            
            if (isset($_POST['send_test_email'])) {
                echo "<div class='info'>📤 Envoi de l'email de test en cours vers $testEmail...</div>";
                
                // Générer un token de test
                $testToken = bin2hex(random_bytes(32));
                
                try {
                    $result = $emailManager->sendActivationEmail($testEmail, $testName, $testToken);
                    
                    if ($result) {
                        echo "<div class='success'>✅ Email de test envoyé avec succès !</div>";
                        echo "<div class='info'>📬 Vérifiez votre boîte mail (et les spams) à l'adresse: $testEmail</div>";
                        echo "<div class='step'>🔗 Le lien d'activation contient le token: " . substr($testToken, 0, 16) . "...</div>";
                    } else {
                        echo "<div class='error'>❌ Échec de l'envoi de l'email de test</div>";
                        echo "<div class='warning'>💡 Vérifiez les logs dans ../logs/email_" . date('Y-m') . ".log</div>";
                    }
                } catch (Exception $e) {
                    echo "<div class='error'>❌ Exception lors de l'envoi: " . $e->getMessage() . "</div>";
                }
            }
        } else {
            echo "<div class='warning'>⚠️ Tests préliminaires échoués - Envoi d'email désactivé</div>";
            if (!$configTest['success']) echo "<div class='info'>• Problème de connexion SMTP</div>";
            if (!$envOk) echo "<div class='info'>• Variables d'environnement manquantes</div>";
            if (!file_exists($templatePath)) echo "<div class='info'>• Template d'email manquant</div>";
        }
        
        // Résumé final
        echo "<h3>📋 Résumé Final</h3>";
        
        if ($configTest['success'] && $envOk && file_exists($templatePath)) {
            echo "<div class='success'>";
            echo "<strong>🎉 Configuration email prête pour la production !</strong><br>";
            echo "✅ Toutes les dépendances sont installées<br>";
            echo "✅ Configuration SMTP fonctionnelle<br>";
            echo "✅ Templates disponibles<br>";
            echo "✅ Variables d'environnement configurées<br>";
            echo "✅ Système de logs opérationnel<br>";
            echo "</div>";
        } else {
            echo "<div class='error'>";
            echo "<strong>⚠️ Configuration incomplète</strong><br>";
            echo "Corrigez les erreurs signalées ci-dessus avant la mise en production.<br>";
            echo "</div>";
        }
        
    } catch (Exception $e) {
        echo "<div class='error'>❌ Erreur fatale lors des tests: " . $e->getMessage() . "</div>";
        echo "<div class='warning'>💡 Vérifiez que tous les fichiers sont présents et les permissions correctes</div>";
    }
    
    echo "</div>";
}

// Affichage des informations système
echo "<div class='test-section'>";
echo "<h2>🖥️ Informations Système</h2>";
echo "<div class='info'>";
echo "<strong>PHP Version:</strong> " . phpversion() . "<br>";
echo "<strong>Système:</strong> " . php_uname('s') . " " . php_uname('r') . "<br>";
echo "<strong>Extensions PHP:</strong><br>";
echo "• OpenSSL: " . (extension_loaded('openssl') ? '✅ Activé' : '❌ Désactivé') . "<br>";
echo "• cURL: " . (extension_loaded('curl') ? '✅ Activé' : '❌ Désactivé') . "<br>";
echo "• Sockets: " . (extension_loaded('sockets') ? '✅ Activé' : '❌ Désactivé') . "<br>";
echo "• JSON: " . (extension_loaded('json') ? '✅ Activé' : '❌ Désactivé') . "<br>";
echo "<strong>Date/Heure serveur:</strong> " . date('Y-m-d H:i:s T') . "<br>";
echo "<strong>Timezone:</strong> " . date_default_timezone_get() . "<br>";
echo "</div>";
echo "</div>";

echo "<div class='test-section'>";
echo "<h2>📚 Guide de Configuration</h2>";
echo "<div class='info'>";
echo "<strong>🔧 Pour Gmail :</strong><br>";
echo "1. Activez l'authentification à 2 facteurs sur votre compte<br>";
echo "2. Allez dans Paramètres Google > Sécurité > Authentification à 2 facteurs<br>";
echo "3. Cliquez sur 'Mots de passe des applications'<br>";
echo "4. Générez un mot de passe pour 'Social Media Generator'<br>";
echo "5. Utilisez ce mot de passe dans SMTP_PASSWORD<br><br>";

echo "<strong>📝 Exemple de configuration .env :</strong><br>";
echo "<pre style='font-size: 0.9em;'>";
echo "SMTP_HOST=smtp.gmail.com\n";
echo "SMTP_USERNAME=votre-email@gmail.com\n";
echo "SMTP_PASSWORD=abcd efgh ijkl mnop\n";
echo "SMTP_PORT=587\n";
echo "MAIL_FROM_ADDRESS=noreply@votre-domaine.com\n";
echo "MAIL_FROM_NAME=\"Social Media Generator\"\n";
echo "APP_URL=http://localhost/votre-projet\n";
echo "</pre>";

echo "<strong>🔧 Ports SMTP courants :</strong><br>";
echo "• Port 587 (TLS/STARTTLS) - Recommandé<br>";
echo "• Port 465 (SSL) - Alternative<br>";
echo "• Port 25 (Non chiffré) - Non recommandé<br><br>";

echo "<strong>📁 Structure des fichiers requise :</strong><br>";
echo "<pre style='font-size: 0.9em;'>";
echo "votre-projet/\n";
echo "├── vendor/ (composer install)\n";
echo "├── config/email_config.php\n";
echo "├── utils/EnhancedEmailManager.php\n";
echo "├── templates/emails/activation_email.html\n";
echo "├── logs/ (créé automatiquement)\n";
echo "├── tests/test_email_setup.php\n";
echo "└── .env\n";
echo "</pre>";
echo "</div>";
echo "</div>";
?>