 <?php
/**
 * ================================================================
 * 🔄 BASCULER SUR SMG FREE PAR DÉFAUT
 * ================================================================
 * 
 * 🎯 En cas de problème OpenAI, basculer sur SMG Free
 * ✅ Désactiver profils OpenAI problématiques
 * ✅ Activer SMG Free comme défaut
 * 
 * 💡 SOLUTION TEMPORAIRE EN ATTENDANT FIX OPENAI
 * ================================================================
 */

// Configuration base de données
$host = 'localhost';
$dbname = 'laloedata';
$username = 'laloedata';
$password = 'PiL256Mx78!';
$charset = 'utf8mb4';

$dsn = "mysql:host=$host;dbname=$dbname;charset=$charset";
$options = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
];

try {
    $pdo = new PDO($dsn, $username, $password, $options);
    echo "✅ Connexion base de données OK\n";
} catch (PDOException $e) {
    die("❌ Erreur de connexion : " . $e->getMessage() . "\n");
}

echo "\n🔄 BASCULEMENT VERS SMG FREE\n";
echo "============================\n\n";

// 1. Réinitialiser tous les profils par défaut
echo "1️⃣ Réinitialisation profils par défaut...\n";
$stmt = $pdo->prepare("UPDATE user_ai_profiles SET is_default = 0");
$stmt->execute();
echo "   ✅ Tous les profils réinitialisés\n";

// 2. Désactiver profils OpenAI problématiques
echo "\n2️⃣ Désactivation profils OpenAI...\n";
$stmt = $pdo->prepare("UPDATE user_ai_profiles SET is_active = 0 WHERE ai_provider = 'openai'");
$stmt->execute();
$disabled = $stmt->rowCount();
echo "   ✅ $disabled profils OpenAI désactivés\n";

// 3. Activer et définir SMG Free comme défaut pour tous les utilisateurs
echo "\n3️⃣ Activation SMG Free par défaut...\n";

$stmt = $pdo->query("SELECT id FROM users WHERE status = 'active'");
$active_users = $stmt->fetchAll();

foreach ($active_users as $user) {
    $user_id = $user['id'];
    
    // Vérifier si profil SMG Free existe
    $stmt = $pdo->prepare("SELECT id FROM user_ai_profiles WHERE user_id = ? AND ai_provider = 'smg_free'");
    $stmt->execute([$user_id]);
    $smg_profile = $stmt->fetch();
    
    if ($smg_profile) {
        // Activer et définir comme défaut
        $stmt = $pdo->prepare("
            UPDATE user_ai_profiles 
            SET is_active = 1, is_default = 1 
            WHERE id = ?
        ");
        $stmt->execute([$smg_profile['id']]);
        echo "   ✅ User $user_id: SMG Free activé comme défaut\n";
    } else {
        // Créer profil SMG Free
        $stmt = $pdo->prepare("
            INSERT INTO user_ai_profiles 
            (user_id, ai_provider, display_name, model_preference, max_tokens_per_request, temperature, is_active, is_default)
            VALUES (?, 'smg_free', 'SMG Studio Gratuit', 'smg-free', 1000, 0.7, 1, 1)
        ");
        $stmt->execute([$user_id]);
        echo "   ✅ User $user_id: Profil SMG Free créé et activé\n";
    }
}

echo "\n🎉 BASCULEMENT TERMINÉ !\n";
echo "✅ Tous les utilisateurs utilisent maintenant SMG Free par défaut\n";
echo "✅ Vous pouvez utiliser le générateur IA sans problème\n";
echo "💡 Configurez vos clés OpenAI plus tard dans ai_profiles.php\n";

?>