<?php
/**
 * ================================================================
 * 👤 SETUP USERS SMG - CRÉATION/VÉRIFICATION UTILISATEURS
 * ================================================================
 * 
 * 🎯 SCRIPT UTILITAIRE :
 * - Créer des utilisateurs avec mots de passe hachés
 * - Vérifier les hash existants
 * - Réinitialiser mot de passe
 * 
 * 💡 À EXÉCUTER UNE FOIS POUR SETUP INITIAL
 * ================================================================
 */

// Configuration base de données
$host = 'localhost';
$dbname = 'laloedata';
$username = 'laloedata';
$password = 'PiL256Mx78!';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    echo "✅ Connexion BDD réussie<br><br>";
} catch (PDOException $e) {
    die("❌ Erreur connexion BDD: " . $e->getMessage());
}

echo "<h2>🔐 Setup Utilisateurs SMG</h2>";

// ================================================================
// 📋 VÉRIFICATION UTILISATEURS EXISTANTS
// ================================================================

echo "<h3>📋 Utilisateurs existants :</h3>";
$stmt = $pdo->query("SELECT id, name, email, role, status, created_at FROM users ORDER BY id");
$users = $stmt->fetchAll(PDO::FETCH_ASSOC);

if (empty($users)) {
    echo "<p style=\"color: orange;\">⚠️ Aucun utilisateur trouvé dans la base</p>";
} else {
    echo '<table border="1" cellpadding="10" style="border-collapse: collapse;">';
    echo '<tr><th>ID</th><th>Nom</th><th>Email</th><th>Rôle</th><th>Statut</th><th>Créé le</th></tr>';
    foreach ($users as $user) {
        echo '<tr>';
        echo '<td>' . $user['id'] . '</td>';
        echo '<td>' . htmlspecialchars($user['name']) . '</td>';
        echo '<td>' . htmlspecialchars($user['email']) . '</td>';
        echo '<td>' . $user['role'] . '</td>';
        echo '<td>' . $user['status'] . '</td>';
        echo '<td>' . $user['created_at'] . '</td>';
        echo '</tr>';
    }
    echo '</table>';
}

echo "<br><hr><br>";

// ================================================================
// 🔧 ACTIONS POSSIBLES
// ================================================================

if (isset($_POST['action'])) {
    
    if ($_POST['action'] === 'create_user') {
        // Création nouvel utilisateur
        $name = trim($_POST['name']);
        $email = trim($_POST['email']);
        $password = $_POST['password'];
        $role = $_POST['role'];
        
        if (!empty($name) && !empty($email) && !empty($password)) {
            // Vérifier si email existe déjà
            $checkStmt = $pdo->prepare("SELECT id FROM users WHERE email = ?");
            $checkStmt->execute([$email]);
            
            if ($checkStmt->fetch()) {
                echo "<p style=\"color: red;\">❌ Email déjà utilisé : $email</p>";
            } else {
                // Hasher le mot de passe
                $hashedPassword = password_hash($password, PASSWORD_DEFAULT);
                
                // Insérer utilisateur
                $insertStmt = $pdo->prepare("
                    INSERT INTO users (name, email, password, role, status, email_verified, created_at) 
                    VALUES (?, ?, ?, ?, 'active', 1, NOW())
                ");
                
                if ($insertStmt->execute([$name, $email, $hashedPassword, $role])) {
                    echo "<p style=\"color: green;\">✅ Utilisateur créé : $name ($email)</p>";
                    echo "<p><strong>Mot de passe :</strong> $password</p>";
                    echo "<p><strong>Hash :</strong> " . substr($hashedPassword, 0, 50) . "...</p>";
                } else {
                    echo "<p style=\"color: red;\">❌ Erreur création utilisateur</p>";
                }
            }
        } else {
            echo "<p style=\"color: red;\">❌ Tous les champs sont requis</p>";
        }
    }
    
    if ($_POST['action'] === 'reset_password') {
        // Réinitialisation mot de passe
        $userId = $_POST['user_id'];
        $newPassword = $_POST['new_password'];
        
        if (!empty($userId) && !empty($newPassword)) {
            $hashedPassword = password_hash($newPassword, PASSWORD_DEFAULT);
            
            $updateStmt = $pdo->prepare("UPDATE users SET password = ? WHERE id = ?");
            if ($updateStmt->execute([$hashedPassword, $userId])) {
                echo "<p style=\"color: green;\">✅ Mot de passe réinitialisé pour l'utilisateur ID $userId</p>";
                echo "<p><strong>Nouveau mot de passe :</strong> $newPassword</p>";
            } else {
                echo "<p style=\"color: red;\">❌ Erreur réinitialisation mot de passe</p>";
            }
        }
    }
    
    if ($_POST['action'] === 'test_login') {
        // Test de connexion
        $testEmail = $_POST['test_email'];
        $testPassword = $_POST['test_password'];
        
        $stmt = $pdo->prepare("SELECT id, name, email, password FROM users WHERE email = ?");
        $stmt->execute([$testEmail]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($user) {
            if (password_verify($testPassword, $user['password'])) {
                echo "<p style=\"color: green;\">✅ Test connexion réussi pour : " . $user['name'] . "</p>";
            } else {
                echo "<p style=\"color: red;\">❌ Mot de passe incorrect</p>";
                echo "<p><strong>Hash en base :</strong> " . substr($user['password'], 0, 50) . "...</p>";
                echo "<p><strong>Test password_verify :</strong> " . (password_verify($testPassword, $user['password']) ? 'TRUE' : 'FALSE') . "</p>";
            }
        } else {
            echo "<p style=\"color: red;\">❌ Utilisateur non trouvé : $testEmail</p>";
        }
    }
    
    echo "<br><hr><br>";
}

?>

<!DOCTYPE html>
<html>
<head>
    <title>🔐 Setup Users SMG</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        .form-section { background: #f5f5f5; padding: 20px; margin: 20px 0; border-radius: 8px; }
        input, select, button { padding: 10px; margin: 5px; }
        button { background: #007cba; color: white; border: none; border-radius: 4px; cursor: pointer; }
        button:hover { background: #005a87; }
    </style>
</head>
<body>

<!-- ================================================================
     🆕 CRÉER NOUVEL UTILISATEUR
     ================================================================ -->
<div class="form-section">
    <h3>🆕 Créer un nouvel utilisateur</h3>
    <form method="POST">
        <input type="hidden" name="action" value="create_user">
        
        <label>Nom :</label><br>
        <input type="text" name="name" placeholder="Papy 77" required><br>
        
        <label>Email :</label><br>
        <input type="email" name="email" placeholder="papy77@laloee-cours.fr" required><br>
        
        <label>Mot de passe :</label><br>
        <input type="text" name="password" placeholder="motdepasse123" required><br>
        
        <label>Rôle :</label><br>
        <select name="role" required>
            <option value="admin">Admin</option>
            <option value="manager">Manager</option>
            <option value="user">User</option>
        </select><br><br>
        
        <button type="submit">✅ Créer Utilisateur</button>
    </form>
</div>

<!-- ================================================================
     🔄 RÉINITIALISER MOT DE PASSE
     ================================================================ -->
<div class="form-section">
    <h3>🔄 Réinitialiser mot de passe</h3>
    <form method="POST">
        <input type="hidden" name="action" value="reset_password">
        
        <label>ID Utilisateur :</label><br>
        <select name="user_id" required>
            <option value="">Sélectionner un utilisateur</option>
            <?php foreach ($users as $user): ?>
                <option value="<?php echo $user['id']; ?>">
                    <?php echo $user['id'] . ' - ' . htmlspecialchars($user['name']) . ' (' . $user['email'] . ')'; ?>
                </option>
            <?php endforeach; ?>
        </select><br>
        
        <label>Nouveau mot de passe :</label><br>
        <input type="text" name="new_password" placeholder="nouveaumotdepasse" required><br><br>
        
        <button type="submit">🔄 Réinitialiser</button>
    </form>
</div>

<!-- ================================================================
     🧪 TESTER CONNEXION
     ================================================================ -->
<div class="form-section">
    <h3>🧪 Tester une connexion</h3>
    <form method="POST">
        <input type="hidden" name="action" value="test_login">
        
        <label>Email :</label><br>
        <input type="email" name="test_email" placeholder="email@test.com" required><br>
        
        <label>Mot de passe :</label><br>
        <input type="text" name="test_password" placeholder="motdepasse" required><br><br>
        
        <button type="submit">🧪 Tester Connexion</button>
    </form>
</div>

<!-- ================================================================
     📋 UTILISATEURS PAPY 77 SUGGÉRÉS
     ================================================================ -->
<div class="form-section">
    <h3>📋 Créations rapides suggérées</h3>
    
    <p><strong>🔥 Créer Papy 77 Admin :</strong></p>
    <form method="POST">
        <input type="hidden" name="action" value="create_user">
        <input type="hidden" name="name" value="Papy 77">
        <input type="hidden" name="email" value="lefebvre.pierre@audiovizu.fr">
        <input type="hidden" name="password" value="papy77admin">
        <input type="hidden" name="role" value="admin">
        <button type="submit">🚀 Créer Papy77 Admin (papy77admin)</button>
    </form>
    
    <p><strong>👤 Créer Utilisateur Test :</strong></p>
    <form method="POST">
        <input type="hidden" name="action" value="create_user">
        <input type="hidden" name="name" value="Utilisateur Test">
        <input type="hidden" name="email" value="test@laloee-cours.fr">
        <input type="hidden" name="password" value="test123">
        <input type="hidden" name="role" value="user">
        <button type="submit">👤 Créer User Test (test123)</button>
    </form>
</div>

<hr>

<p><strong>💡 Instructions :</strong></p>
<ol>
    <li>Créez un utilisateur avec le formulaire ci-dessus</li>
    <li>Notez bien le mot de passe (il sera haché en base)</li>
    <li>Testez la connexion avec le formulaire de test</li>
    <li>Une fois OK, utilisez login.html avec ces identifiants</li>
    <li>Supprimez ce fichier setup_users.php après usage !</li>
</ol>

<p><strong>🔐 Sécurité :</strong></p>
<ul>
    <li>Les mots de passe sont hachés avec <code>password_hash()</code></li>
    <li>La vérification utilise <code>password_verify()</code></li>
    <li>Aucun mot de passe en clair stocké en base</li>
</ul>

</body>
</html>