<?php
/**
 * ================================================================
 * 🔧 DEBUG UPLOAD BDD - CLIPMAKER MEDIA
 * ================================================================ 
 * Script pour identifier pourquoi les uploads ne s'enregistrent 
 * pas en base de données
 * ================================================================ */

require_once '../auth_functions.php';
requireLogin();

$user = getCurrentUser();
$pdo = getDbConnection();

echo "<h2>🔧 DEBUG UPLOAD & BDD - Clipmaker Media</h2>\n";

// 1. Vérification utilisateur
echo "<h3>👤 Utilisateur:</h3>\n";
echo "ID: " . $user['id'] . "<br>\n";
echo "Nom: " . $user['name'] . "<br>\n";
echo "Email: " . $user['email'] . "<br>\n";

// 2. Vérification table clipmaker_media
echo "<h3>📊 Table clipmaker_media:</h3>\n";

try {
    // Vérifier si la table existe
    $stmt = $pdo->query("SHOW TABLES LIKE 'clipmaker_media'");
    $table_exists = $stmt->rowCount() > 0;
    
    if ($table_exists) {
        echo "✅ Table clipmaker_media existe<br>\n";
        
        // Structure de la table
        $stmt = $pdo->query("DESCRIBE clipmaker_media");
        $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);
        echo "<h4>📋 Structure table:</h4>\n";
        echo "<table border='1' style='border-collapse: collapse;'>";
        echo "<tr><th>Colonne</th><th>Type</th><th>Null</th><th>Clé</th><th>Défaut</th></tr>";
        foreach ($columns as $col) {
            echo "<tr>";
            echo "<td>" . $col['Field'] . "</td>";
            echo "<td>" . $col['Type'] . "</td>";
            echo "<td>" . $col['Null'] . "</td>";
            echo "<td>" . $col['Key'] . "</td>";
            echo "<td>" . $col['Default'] . "</td>";
            echo "</tr>";
        }
        echo "</table><br>";
        
        // Contenu total de la table
        $stmt = $pdo->query("SELECT COUNT(*) as total FROM clipmaker_media");
        $total = $stmt->fetch()['total'];
        echo "📊 Total médias en table: <strong>$total</strong><br>\n";
        
        // Médias par utilisateur
        $stmt = $pdo->prepare("SELECT user_id, COUNT(*) as count FROM clipmaker_media GROUP BY user_id");
        $stmt->execute();
        $users_medias = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        echo "<h4>📋 Médias par utilisateur:</h4>\n";
        foreach ($users_medias as $user_media) {
            echo "User ID " . $user_media['user_id'] . ": " . $user_media['count'] . " médias<br>\n";
        }
        
        // Médias de l'utilisateur actuel
        $stmt = $pdo->prepare("SELECT * FROM clipmaker_media WHERE user_id = ? ORDER BY created_at DESC LIMIT 5");
        $stmt->execute([$user['id']]);
        $user_medias = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        echo "<h4>📋 Derniers médias utilisateur " . $user['id'] . ":</h4>\n";
        if (count($user_medias) > 0) {
            echo "<table border='1' style='border-collapse: collapse; width: 100%;'>";
            echo "<tr><th>ID</th><th>Nom</th><th>Type</th><th>Chemin</th><th>Taille</th><th>Date</th></tr>";
            foreach ($user_medias as $media) {
                echo "<tr>";
                echo "<td>" . $media['id'] . "</td>";
                echo "<td>" . htmlspecialchars($media['original_filename']) . "</td>";
                echo "<td>" . $media['file_type'] . "</td>";
                echo "<td>" . htmlspecialchars($media['file_path']) . "</td>";
                echo "<td>" . number_format($media['file_size']/1024/1024, 2) . " MB</td>";
                echo "<td>" . $media['created_at'] . "</td>";
                echo "</tr>";
            }
            echo "</table>";
        } else {
            echo "❌ Aucun média pour cet utilisateur<br>\n";
        }
        
    } else {
        echo "❌ Table clipmaker_media n'existe pas !<br>\n";
        echo "💡 Il faut créer la table d'abord.<br>\n";
    }
    
} catch (PDOException $e) {
    echo "❌ Erreur BDD: " . $e->getMessage() . "<br>\n";
}

// 3. Test fonction tableExists
echo "<h3>🧪 Test fonction tableExists:</h3>\n";

if (function_exists('tableExists')) {
    echo "✅ Fonction tableExists() existe<br>\n";
    
    $table_test = tableExists($pdo, 'clipmaker_media');
    echo "Test tableExists('clipmaker_media'): " . ($table_test ? '✅ TRUE' : '❌ FALSE') . "<br>\n";
} else {
    echo "❌ Fonction tableExists() n'existe pas !<br>\n";
}

// 4. Simulation upload
echo "<h3>🧪 Test simulation upload:</h3>\n";

try {
    // Test insertion directe
    if ($table_exists) {
        $test_data = [
            'user_id' => $user['id'],
            'original_filename' => 'test_debug.jpg',
            'stored_filename' => 'test_debug_' . time() . '.jpg',
            'file_path' => '/laloee-cours.fr/social-media-generator/uploads/clipmaker/media/test_debug.jpg',
            'file_type' => 'image',
            'mime_type' => 'image/jpeg',
            'file_size' => 1024,
            'metadata' => '{"test": true}'
        ];
        
        $stmt = $pdo->prepare("
            INSERT INTO clipmaker_media 
            (user_id, original_filename, stored_filename, file_path, file_type, mime_type, 
             file_size, metadata, created_at) 
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, NOW())
        ");
        
        $result = $stmt->execute([
            $test_data['user_id'],
            $test_data['original_filename'],
            $test_data['stored_filename'],
            $test_data['file_path'],
            $test_data['file_type'],
            $test_data['mime_type'],
            $test_data['file_size'],
            $test_data['metadata']
        ]);
        
        if ($result) {
            $test_id = $pdo->lastInsertId();
            echo "✅ Test insertion réussie ! ID: $test_id<br>\n";
            
            // Suppression du test
            $stmt = $pdo->prepare("DELETE FROM clipmaker_media WHERE id = ?");
            $stmt->execute([$test_id]);
            echo "🗑️ Enregistrement test supprimé<br>\n";
        } else {
            echo "❌ Échec test insertion<br>\n";
        }
    }
    
} catch (PDOException $e) {
    echo "❌ Erreur test insertion: " . $e->getMessage() . "<br>\n";
}

// 5. Vérification fichiers physiques uploadés
echo "<h3>📁 Fichiers physiques uploadés:</h3>\n";

$upload_dir = '/var/www/laloee-cours.fr/social-media-generator/uploads/clipmaker/media/';

if (is_dir($upload_dir)) {
    $files = glob($upload_dir . '*');
    echo "📊 Fichiers trouvés: " . count($files) . "<br>\n";
    
    if (count($files) > 0) {
        echo "<h4>📋 Derniers fichiers:</h4>\n";
        $recent_files = array_slice($files, -10); // 10 derniers
        foreach ($recent_files as $file) {
            $filename = basename($file);
            $size = filesize($file);
            $date = date('Y-m-d H:i:s', filemtime($file));
            echo "📄 $filename - " . number_format($size/1024/1024, 2) . " MB - $date<br>\n";
        }
    }
} else {
    echo "❌ Dossier upload introuvable<br>\n";
}

// 6. Solutions recommandées
echo "<h3>💡 SOLUTIONS RECOMMANDÉES:</h3>\n";
echo "<div style='background: #f0f8ff; padding: 15px; border-left: 4px solid #0066cc;'>";

if (!$table_exists) {
    echo "<strong>🎯 Problème: Table clipmaker_media manquante</strong><br>";
    echo "✅ Solution: Exécuter le script SQL de création de table<br>";
} elseif (count($user_medias) == 0 && count($files) > 0) {
    echo "<strong>🎯 Problème: Fichiers uploadés mais pas en BDD</strong><br>";
    echo "✅ Solutions possibles:<br>";
    echo "1. Vérifier que la condition tableExists() dans le code d'upload<br>";
    echo "2. Vérifier les erreurs dans le code d'insertion<br>";
    echo "3. Ajouter du debug dans la partie upload<br>";
} else {
    echo "<strong>🎯 Problème à identifier avec plus de détails</strong><br>";
}

echo "</div>";

echo "<hr>";
echo "<p><em>🔧 Debug Upload BDD terminé - by Papy 77!</em></p>";
?>