<?php
/**
 * ================================================================
 * 💥 RESET TOTAL CLIPMAKER - REPARTIR DE ZÉRO
 * ================================================================ 
 * 
 * ⚠️ ATTENTION : SUPPRESSION DÉFINITIVE !
 * - Vide toutes les tables Clipmaker
 * - Supprime tous les fichiers uploadés
 * - Repart sur des bases saines
 * 
 * 🔥 BY PAPY 77 - SOLUTION RADICALE !
 * ================================================================ */

require_once '../auth_functions.php';
requireLogin();

$user = getCurrentUser();
$pdo = getDbConnection();

echo "<h1 style='color: #dc3545;'>💥 RESET TOTAL CLIPMAKER</h1>\n";
echo "<div style='background: #f8d7da; border: 1px solid #dc3545; padding: 20px; border-radius: 8px; margin-bottom: 20px;'>";
echo "<strong>⚠️ ATTENTION DANGER !</strong><br>";
echo "Cette action va SUPPRIMER DÉFINITIVEMENT :<br>";
echo "• Tous les projets Clipmaker<br>";
echo "• Tous les médias et fichiers uploadés<br>";
echo "• Tous les exports<br>";
echo "• Tous les templates<br>";
echo "• Toutes les données Clipmaker<br>";
echo "</div>";

// Statistiques avant suppression
echo "<h3>📊 État actuel avant suppression:</h3>\n";

$tables_clipmaker = [
    'clipmaker_projects' => 'Projets',
    'clipmaker_media' => 'Médias',
    'clipmaker_exports' => 'Exports',
    'clipmaker_templates' => 'Templates',
    'clipmaker_ai_logs' => 'Logs IA',
    'clipmaker_clip_transitions' => 'Transitions'
];

foreach ($tables_clipmaker as $table => $label) {
    try {
        $stmt = $pdo->query("SELECT COUNT(*) as count FROM $table");
        $count = $stmt->fetch()['count'];
        echo "📋 $label: <strong>$count</strong> enregistrements<br>\n";
    } catch (PDOException $e) {
        echo "📋 $label: Table introuvable<br>\n";
    }
}

// Dossiers à nettoyer
echo "<h3>📁 Dossiers à nettoyer:</h3>\n";

$folders_to_clean = [
    '/var/www/laloee-cours.fr/social-media-generator/uploads/clipmaker/media/',
    '/var/www/laloee-cours.fr/social-media-generator/uploads/clipmaker/thumbnails/',
    '/var/www/laloee-cours.fr/social-media-generator/uploads/clipmaker/exports/'
];

foreach ($folders_to_clean as $folder) {
    if (is_dir($folder)) {
        $files = glob($folder . '*');
        echo "📂 $folder: <strong>" . count($files) . "</strong> fichiers<br>\n";
    } else {
        echo "📂 $folder: Dossier inexistant<br>\n";
    }
}

// BOUTONS D'ACTION
echo "<hr>";
echo "<h3>🎯 ACTIONS DISPONIBLES:</h3>\n";

if (isset($_GET['action'])) {
    $action = $_GET['action'];
    
    switch ($action) {
        case 'reset_bdd':
            resetDatabase($pdo);
            break;
            
        case 'clean_files':
            cleanFiles();
            break;
            
        case 'reset_total':
            resetDatabase($pdo);
            cleanFiles();
            recreateStructure();
            echo "<div style='background: #d4edda; border: 1px solid #28a745; padding: 20px; border-radius: 8px; margin: 20px 0;'>";
            echo "<strong>✅ RESET TOTAL TERMINÉ !</strong><br>";
            echo "Clipmaker est maintenant dans un état propre.<br>";
            echo "<a href='../clipmaker.php' style='background: #28a745; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px; margin-top: 10px; display: inline-block;'>🏠 Retour Dashboard</a>";
            echo "</div>";
            break;
            
        default:
            echo "Action inconnue<br>\n";
    }
} else {
    // Affichage des boutons
    echo "<div style='display: flex; gap: 15px; flex-wrap: wrap;'>";
    
    echo "<a href='?action=reset_bdd' onclick=\"return confirm('⚠️ Supprimer toutes les données BDD Clipmaker ?')\" 
            style='background: #ffc107; color: #000; padding: 15px 25px; text-decoration: none; border-radius: 8px; font-weight: bold;'>
            🗑️ Vider tables BDD
          </a>";
    
    echo "<a href='?action=clean_files' onclick=\"return confirm('⚠️ Supprimer tous les fichiers uploadés ?')\" 
            style='background: #fd7e14; color: white; padding: 15px 25px; text-decoration: none; border-radius: 8px; font-weight: bold;'>
            🧹 Nettoyer fichiers
          </a>";
    
    echo "<a href='?action=reset_total' onclick=\"return confirm('💥 RESET TOTAL CLIPMAKER ?\\n\\nCette action est IRRÉVERSIBLE !\\n\\nTaper OK pour confirmer')\" 
            style='background: #dc3545; color: white; padding: 15px 25px; text-decoration: none; border-radius: 8px; font-weight: bold;'>
            💥 RESET TOTAL
          </a>";
    
    echo "</div>";
}

echo "<hr>";
echo "<div style='background: #e2e3e5; padding: 15px; border-radius: 8px;'>";
echo "<strong>💡 RECOMMANDATION:</strong><br>";
echo "Après le reset, les nouveaux uploads utiliseront automatiquement les chemins corrects.<br>";
echo "Plus besoin de s'embêter avec les anciens chemins foireux !";
echo "</div>";

// FONCTIONS DE RESET
function resetDatabase($pdo) {
    echo "<h4>🗑️ Suppression données BDD:</h4>\n";
    
    $tables_to_clean = [
        'clipmaker_clip_transitions',
        'clipmaker_ai_logs', 
        'clipmaker_exports',
        'clipmaker_media',
        'clipmaker_templates',
        'clipmaker_projects'
    ];
    
    foreach ($tables_to_clean as $table) {
        try {
            $stmt = $pdo->prepare("DELETE FROM $table");
            $affected = $stmt->execute();
            echo "✅ Table $table vidée<br>\n";
            
            // Reset AUTO_INCREMENT
            $pdo->exec("ALTER TABLE $table AUTO_INCREMENT = 1");
            
        } catch (PDOException $e) {
            echo "⚠️ Erreur $table: " . $e->getMessage() . "<br>\n";
        }
    }
    
    echo "<strong>✅ Base de données nettoyée !</strong><br><br>\n";
}

function cleanFiles() {
    echo "<h4>🧹 Suppression fichiers:</h4>\n";
    
    $folders_to_clean = [
        '/var/www/laloee-cours.fr/social-media-generator/uploads/clipmaker/media/',
        '/var/www/laloee-cours.fr/social-media-generator/uploads/clipmaker/thumbnails/',
        '/var/www/laloee-cours.fr/social-media-generator/uploads/clipmaker/exports/'
    ];
    
    foreach ($folders_to_clean as $folder) {
        if (is_dir($folder)) {
            $files = glob($folder . '*');
            $deleted = 0;
            
            foreach ($files as $file) {
                if (is_file($file)) {
                    unlink($file);
                    $deleted++;
                }
            }
            
            echo "🗑️ $folder: $deleted fichiers supprimés<br>\n";
        } else {
            echo "📂 $folder: Dossier inexistant<br>\n";
        }
    }
    
    echo "<strong>✅ Fichiers nettoyés !</strong><br><br>\n";
}

function recreateStructure() {
    echo "<h4>🏗️ Recréation structure:</h4>\n";
    
    $folders_to_create = [
        '/var/www/laloee-cours.fr/social-media-generator/uploads/clipmaker/',
        '/var/www/laloee-cours.fr/social-media-generator/uploads/clipmaker/media/',
        '/var/www/laloee-cours.fr/social-media-generator/uploads/clipmaker/thumbnails/',
        '/var/www/laloee-cours.fr/social-media-generator/uploads/clipmaker/exports/'
    ];
    
    foreach ($folders_to_create as $folder) {
        if (!is_dir($folder)) {
            mkdir($folder, 0755, true);
            echo "📁 Créé: $folder<br>\n";
        } else {
            echo "📁 Existe: $folder<br>\n";
        }
        
        // Permissions
        chmod($folder, 0755);
    }
    
    echo "<strong>✅ Structure recréée !</strong><br><br>\n";
}

echo "<hr>";
echo "<div style='text-align: center; margin-top: 30px;'>";
echo "<a href='../clipmaker.php' style='background: #6c757d; color: white; padding: 12px 24px; text-decoration: none; border-radius: 8px;'>← Retour sans reset</a>";
echo "</div>";

echo "<p style='text-align: center; margin-top: 20px;'><em>💥 Reset Clipmaker - Ubuntu 24 Power by Papy 77!</em></p>";
?>