<?php
/**
 * ================================================================
 * 🔧 CORRECTION CHEMINS CLIPMAKER MEDIA - BY PAPY 77
 * ================================================================
 * Correction des chemins pour Ubuntu 24 avec structure laloee-cours.fr
 * ================================================================
 */

// ❌ ANCIENS CHEMINS (INCORRECTS)
/*
$upload_path = '/social-media-generator/uploads/clipmaker/media/';
$thumbnails_path = '/social-media-generator/uploads/clipmaker/thumbnails/';
*/

// ✅ NOUVEAUX CHEMINS (CORRECTS pour laloee-cours.fr)
$upload_path = '/laloee-cours.fr/social-media-generator/uploads/clipmaker/media/';
$thumbnails_path = '/laloee-cours.fr/social-media-generator/uploads/clipmaker/thumbnails/';

// 🎯 CHEMINS ABSOLUS SERVEUR (pour les opérations fichiers)
$server_upload_path = '/var/www/laloee-cours.fr/social-media-generator/uploads/clipmaker/media/';
$server_thumbnails_path = '/var/www/laloee-cours.fr/social-media-generator/uploads/clipmaker/thumbnails/';

/**
 * ================================================================
 * 📝 MODIFICATIONS À FAIRE DANS TES FICHIERS
 * ================================================================
 */
/**
 * ================================================================
 * 🔧 FONCTION GÉNÉRATION THUMBNAIL CORRIGÉE
 * ================================================================ 
 */
function generateImageThumbnail_FIXED($source_path, $filename) {
    // ✅ CHEMINS CORRECTS
    $thumbnails_web_path = '/laloee-cours.fr/social-media-generator/uploads/clipmaker/thumbnails/';
    $thumbnails_server_path = '/var/www/html/laloee-cours.fr/social-media-generator/uploads/clipmaker/thumbnails/';
    
    $thumbnail_name = pathinfo($filename, PATHINFO_FILENAME) . '_thumb.jpg';
    $thumbnail_full_path = $thumbnails_server_path . $thumbnail_name;
    
    // Création dossier thumbnails si inexistant
    if (!is_dir($thumbnails_server_path)) {
        mkdir($thumbnails_server_path, 0755, true);
    }
    
    // Génération thumbnail
    $source = imagecreatefromstring(file_get_contents($source_path));
    if ($source) {
        $width = imagesx($source);
        $height = imagesy($source);
        
        $thumb_width = 300;
        $thumb_height = ($height / $width) * $thumb_width;
        
        $thumbnail = imagecreatetruecolor($thumb_width, $thumb_height);
        imagecopyresampled($thumbnail, $source, 0, 0, 0, 0, $thumb_width, $thumb_height, $width, $height);
        
        if (imagejpeg($thumbnail, $thumbnail_full_path, 85)) {
            imagedestroy($source);
            imagedestroy($thumbnail);
            return $thumbnails_web_path . $thumbnail_name; // ✅ Retourne le chemin WEB
        }
        
        imagedestroy($source);
        imagedestroy($thumbnail);
    }
    
    return null;
}

/**
 * ================================================================
 * 🚀 SCRIPT DE CORRECTION AUTOMATIQUE
 * ================================================================ 
 */

echo "<h2>🔧 CORRECTION AUTOMATIQUE CHEMINS CLIPMAKER</h2>\n";

// 1. Créer les dossiers avec les bons chemins
$directories = [
    '/var/www/laloee-cours.fr/social-media-generator/uploads/',
    '/var/www/laloee-cours.fr/social-media-generator/uploads/clipmaker/',
    '/var/www/laloee-cours.fr/social-media-generator/uploads/clipmaker/media/',
    '/var/www/laloee-cours.fr/social-media-generator/uploads/clipmaker/thumbnails/'
];

foreach ($directories as $dir) {
    if (!is_dir($dir)) {
        if (mkdir($dir, 0755, true)) {
            echo "✅ Créé: $dir<br>\n";
        } else {
            echo "❌ Erreur création: $dir<br>\n";
        }
    } else {
        echo "✅ Existe déjà: $dir<br>\n";
    }
}

// 2. Corriger les permissions
foreach ($directories as $dir) {
    if (is_dir($dir)) {
        chmod($dir, 0755);
        echo "🔐 Permissions corrigées: $dir<br>\n";
    }
}

// 3. Mettre à jour les chemins en BDD si nécessaire
try {
    require_once '../auth_functions.php';
    $pdo = getDbConnection();
    
    echo "<h3>🔄 Correction chemins en BDD:</h3>\n";
    
    // Vérifier les chemins actuels
    $stmt = $pdo->query("SELECT id, file_path, thumbnail_path FROM clipmaker_media WHERE file_path LIKE '/social-media-generator%'");
    $medias_to_update = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    if (count($medias_to_update) > 0) {
        echo "📊 Trouvé " . count($medias_to_update) . " médias avec anciens chemins<br>\n";
        
        foreach ($medias_to_update as $media) {
            $old_path = $media['file_path'];
            $new_path = str_replace('/social-media-generator/', '/laloee-cours.fr/social-media-generator/', $old_path);
            
            $old_thumb = $media['thumbnail_path'];
            $new_thumb = $old_thumb ? str_replace('/social-media-generator/', '/laloee-cours.fr/social-media-generator/', $old_thumb) : null;
            
            $update_stmt = $pdo->prepare("
                UPDATE clipmaker_media 
                SET file_path = ?, thumbnail_path = ? 
                WHERE id = ?
            ");
            $update_stmt->execute([$new_path, $new_thumb, $media['id']]);
            
            echo "🔄 Mis à jour ID " . $media['id'] . ": $old_path → $new_path<br>\n";
        }
        
        echo "✅ Tous les chemins ont été corrigés en BDD !<br>\n";
    } else {
        echo "✅ Aucun chemin à corriger en BDD<br>\n";
    }
    
} catch (Exception $e) {
    echo "❌ Erreur correction BDD: " . $e->getMessage() . "<br>\n";
}

echo "<hr>";
echo "<h3>📋 RÉSUMÉ CORRECTIONS:</h3>";
echo "<ul>";
echo "<li>✅ Dossiers créés avec structure laloee-cours.fr</li>";
echo "<li>✅ Permissions corrigées (755)</li>";
echo "<li>✅ Chemins mis à jour en BDD</li>";
echo "<li>🔧 Modifie maintenant clipmaker-media.php avec les nouveaux chemins</li>";
echo "</ul>";

echo "<h3>🎯 PROCHAINES ÉTAPES:</h3>";
echo "<div style='background: #f0f8ff; padding: 15px; border-left: 4px solid #0066cc;'>";
echo "<strong>1. Modifie clipmaker-media.php lignes 19-20:</strong><br>";
echo "<code>
\$upload_path = '/laloee-cours.fr/social-media-generator/uploads/clipmaker/media/';<br>
\$thumbnails_path = '/laloee-cours.fr/social-media-generator/uploads/clipmaker/thumbnails/';
</code><br><br>";

echo "<strong>2. Remplace également dans les fonctions generateImageThumbnail et generateVideoThumbnail</strong><br><br>";

echo "<strong>3. Teste ensuite la bibliothèque média !</strong><br>";
echo "</div>";

?>

<!-- ================================================================
     🧪 SCRIPT TEST UPLOAD AVEC NOUVEAUX CHEMINS  
     ================================================================ -->
<h3>🧪 Test Upload avec Nouveaux Chemins</h3>
<form method="post" enctype="multipart/form-data" style="background: #f9f9f9; padding: 20px; border-radius: 8px;">
    <input type="file" name="test_file" accept="image/*,video/*,audio/*" required>
    <button type="submit" name="test_upload" style="background: #007bff; color: white; padding: 10px 20px; border: none; border-radius: 5px; cursor: pointer;">
        🧪 Tester Upload
    </button>
</form>

<?php
if (isset($_POST['test_upload']) && isset($_FILES['test_file'])) {
    echo "<h4>🧪 Résultat Test Upload:</h4>";
    
    $file = $_FILES['test_file'];
    if ($file['error'] === UPLOAD_ERR_OK) {
        $extension = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
        $new_filename = 'test_' . uniqid() . '.' . $extension;
        $destination = '/var/www/laloee-cours.fr/social-media-generator/uploads/clipmaker/media/' . $new_filename;
        
        if (move_uploaded_file($file['tmp_name'], $destination)) {
            echo "✅ Upload réussi: $new_filename<br>";
            echo "📂 Chemin: $destination<br>";
            echo "🌐 URL: /laloee-cours.fr/social-media-generator/uploads/clipmaker/media/$new_filename<br>";
            
            // Test d'accès à l'image
            $web_url = "/laloee-cours.fr/social-media-generator/uploads/clipmaker/media/$new_filename";
            echo "<img src='$web_url' style='max-width: 200px; border: 2px solid #28a745; border-radius: 8px; margin-top: 10px;' alt='Test'>";
        } else {
            echo "❌ Erreur déplacement fichier<br>";
        }
    } else {
        echo "❌ Erreur upload: " . $file['error'] . "<br>";
    }
}
?>

<p><em>🚀 Ubuntu 24 Power - Correction terminée by Papy 77!</em></p>