<?php
/**
 * ================================================================
 * 🔧 CORRECTIONS CHEMINS ABSOLUS - CLIPMAKER MEDIA
 * ================================================================ 
 * Problèmes identifiés:
 * 1. URLs dupliquées: /laloee-cours.fr/laloee-cours.fr/...
 * 2. Téléchargement: /../uploads/... (relatif)
 * 
 * Solution: TOUT EN CHEMINS ABSOLUS FIXES !
 * ================================================================ */

// ✅ REMPLACEMENTS À FAIRE DANS clipmaker-media.php

// 1. LIGNE ~20 - Remplacer les chemins par :
$upload_web_path = '/social-media-generator/uploads/clipmaker/media/';
$thumbnails_web_path = '/social-media-generator/uploads/clipmaker/thumbnails/';
$upload_server_path = '/var/www/laloee-cours.fr/social-media-generator/uploads/clipmaker/media/';
$thumbnails_server_path = '/var/www/laloee-cours.fr/social-media-generator/uploads/clipmaker/thumbnails/';

// 2. FONCTION DE CORRECTION DES CHEMINS EXISTANTS EN BDD
function fixExistingPaths($pdo) {
    echo "<h3>🔧 Correction chemins existants en BDD:</h3>\n";
    
    try {
        // Récupérer tous les médias avec mauvais chemins
        $stmt = $pdo->query("
            SELECT id, file_path, thumbnail_path 
            FROM clipmaker_media 
            WHERE file_path LIKE '/laloee-cours.fr/%' 
               OR file_path LIKE '/../%'
        ");
        $medias_to_fix = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        echo "📊 Médias à corriger: " . count($medias_to_fix) . "<br>\n";
        
        foreach ($medias_to_fix as $media) {
            $old_file_path = $media['file_path'];
            $old_thumb_path = $media['thumbnail_path'];
            
            // ✅ CORRECTION file_path
            $new_file_path = $old_file_path;
            
            // Supprimer /laloee-cours.fr/ du début si présent
            if (strpos($new_file_path, '/laloee-cours.fr/') === 0) {
                $new_file_path = substr($new_file_path, strlen('/laloee-cours.fr'));
            }
            
            // Corriger les chemins relatifs /../
            if (strpos($new_file_path, '/../') === 0) {
                $new_file_path = str_replace('/../uploads/', '/social-media-generator/uploads/', $new_file_path);
            }
            
            // ✅ CORRECTION thumbnail_path
            $new_thumb_path = $old_thumb_path;
            if ($new_thumb_path) {
                if (strpos($new_thumb_path, '/laloee-cours.fr/') === 0) {
                    $new_thumb_path = substr($new_thumb_path, strlen('/laloee-cours.fr'));
                }
                if (strpos($new_thumb_path, '/../') === 0) {
                    $new_thumb_path = str_replace('/../uploads/', '/social-media-generator/uploads/', $new_thumb_path);
                }
            }
            
            // Mise à jour en BDD
            $update_stmt = $pdo->prepare("
                UPDATE clipmaker_media 
                SET file_path = ?, thumbnail_path = ? 
                WHERE id = ?
            ");
            $update_stmt->execute([$new_file_path, $new_thumb_path, $media['id']]);
            
            echo "🔄 ID {$media['id']}: $old_file_path → $new_file_path<br>\n";
        }
        
        echo "✅ Correction terminée !<br>\n";
        
    } catch (PDOException $e) {
        echo "❌ Erreur correction: " . $e->getMessage() . "<br>\n";
    }
}

// 3. SCRIPT DE TEST ET CORRECTION
echo "<h2>🔧 CORRECTION CHEMINS ABSOLUS - Papy 77</h2>\n";

require_once '../auth_functions.php';
$pdo = getDbConnection();

// Vérification chemins actuels
echo "<h3>📊 État actuel des chemins:</h3>\n";

try {
    $stmt = $pdo->query("
        SELECT 
            id, 
            original_filename,
            file_path, 
            thumbnail_path 
        FROM clipmaker_media 
        ORDER BY created_at DESC 
        LIMIT 10
    ");
    $medias = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "<table border='1' style='border-collapse: collapse; width: 100%;'>";
    echo "<tr><th>ID</th><th>Nom</th><th>Chemin fichier</th><th>Chemin thumbnail</th><th>Status</th></tr>";
    
    foreach ($medias as $media) {
        $file_status = '✅';
        $file_path = $media['file_path'];
        
        // Vérifier les problèmes
        if (strpos($file_path, '/laloee-cours.fr/laloee-cours.fr/') !== false) {
            $file_status = '❌ DOUBLÉ';
        } elseif (strpos($file_path, '/../') !== false) {
            $file_status = '❌ RELATIF';
        } elseif (strpos($file_path, '/laloee-cours.fr/') === 0) {
            $file_status = '⚠️ PRÉFIXE';
        }
        
        echo "<tr>";
        echo "<td>" . $media['id'] . "</td>";
        echo "<td>" . htmlspecialchars($media['original_filename']) . "</td>";
        echo "<td>" . htmlspecialchars($media['file_path']) . "</td>";
        echo "<td>" . htmlspecialchars($media['thumbnail_path'] ?? 'NULL') . "</td>";
        echo "<td>$file_status</td>";
        echo "</tr>";
    }
    echo "</table><br>";
    
} catch (PDOException $e) {
    echo "❌ Erreur lecture BDD: " . $e->getMessage() . "<br>\n";
}

// Bouton de correction
if (isset($_GET['fix_paths'])) {
    fixExistingPaths($pdo);
    echo "<br><a href='?' style='background: #28a745; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;'>✅ Recharger pour voir les corrections</a>";
} else {
    echo "<a href='?fix_paths=1' style='background: #dc3545; color: white; padding: 15px 30px; text-decoration: none; border-radius: 8px; font-weight: bold;'>🔧 CORRIGER TOUS LES CHEMINS</a>";
}

echo "<h3>💡 MODIFICATIONS À FAIRE DANS clipmaker-media.php:</h3>\n";
echo "<div style='background: #f0f8ff; padding: 20px; border-left: 4px solid #0066cc;'>";

echo "<strong>1. Ligne ~20 - Remplacer par:</strong><br>";
echo "<code style='background: #e6ffe6; padding: 10px; display: block; margin: 10px 0;'>
// ✅ CHEMINS ABSOLUS FIXES<br>
\$upload_web_path = '/social-media-generator/uploads/clipmaker/media/';<br>
\$thumbnails_web_path = '/social-media-generator/uploads/clipmaker/thumbnails/';<br>
\$upload_server_path = '/var/www/laloee-cours.fr/social-media-generator/uploads/clipmaker/media/';<br>
\$thumbnails_server_path = '/var/www/laloee-cours.fr/social-media-generator/uploads/clipmaker/thumbnails/';
</code>";

echo "<strong>2. Ligne ~180 (Action download) - Remplacer par:</strong><br>";
echo "<code style='background: #e6ffe6; padding: 10px; display: block; margin: 10px 0;'>
// ✅ CHEMIN SERVEUR ABSOLU FIXE<br>
\$web_path = \$media['file_path'];<br>
\$server_path = '/var/www/laloee-cours.fr' . \$web_path;
</code>";

echo "<strong>3. Ligne ~220 (Action delete) - Remplacer par:</strong><br>";
echo "<code style='background: #e6ffe6; padding: 10px; display: block; margin: 10px 0;'>
// ✅ SUPPRESSION AVEC CHEMIN ABSOLU<br>
\$web_path = \$media['file_path'];<br>
\$server_path = '/var/www/laloee-cours.fr' . \$web_path;<br><br>
if (file_exists(\$server_path)) {<br>
&nbsp;&nbsp;&nbsp;&nbsp;unlink(\$server_path);<br>
}
</code>";

echo "</div>";

echo "<h3>🎯 RÉSULTAT ATTENDU:</h3>\n";
echo "<div style='background: #f0fff0; padding: 15px; border-left: 4px solid #28a745;'>";
echo "<strong>URLs corrigées:</strong><br>";
echo "❌ AVANT: https://laloee-cours.fr/laloee-cours.fr/social-media-generator/uploads/...<br>";
echo "✅ APRÈS: https://laloee-cours.fr/social-media-generator/uploads/...<br><br>";
echo "<strong>Téléchargement corrigé:</strong><br>";
echo "❌ AVANT: /../uploads/clipmaker/media/file.mp4<br>";
echo "✅ APRÈS: /var/www/laloee-cours.fr/social-media-generator/uploads/clipmaker/media/file.mp4";
echo "</div>";

echo "<hr>";
echo "<p><em>🔧 Fix chemins absolus - Ubuntu 24 Power by Papy 77!</em></p>";
?>