<?php
/*
 * SMG Studio v2.0 - Gestionnaire de Déconnexion
 * Path: /var/www/laloee-cours.fr/social-media-generator/logout.php
 */

session_start();
require_once 'config/db.php';

// Logger la déconnexion si utilisateur connecté
if (isset($_SESSION['user_id'])) {
    try {
        $stmt = $pdo->prepare("
            UPDATE log_connexions 
            SET logout_time = NOW() 
            WHERE user_id = ? 
            AND logout_time IS NULL 
            ORDER BY created_at DESC 
            LIMIT 1
        ");
        $stmt->execute([$_SESSION['user_id']]);
    } catch (Exception $e) {
        // Ignorer les erreurs de log
    }
}

// Détruire la session
session_destroy();

// Redirection vers login avec message
header('Location: login.php?logout=1');
exit;