<?php
/*
 * SMG Studio v2.0 - Login avec Redirection Dashboard CORRIGÉ
 * Path: /var/www/laloee-cours.fr/social-media-generator/login.php
 */

session_start();
require_once 'config/db.php';
require_once 'includes/phpmailer.php';

$message = '';
$error = '';

// Si déjà connecté, rediriger vers DASHBOARD 🎯
if (isset($_SESSION['user_id'])) {
    header('Location: dashboard.php'); // ✅ DASHBOARD EN PREMIER !
    exit;
}

// Traitement des actions
$action = $_POST['action'] ?? '';

if ($action === 'forgot_password') {
    $email = trim($_POST['email']);
    
    if (empty($email)) {
        $error = "📧 Email requis";
    } else {
        $result = handlePasswordReset($email);
        if (strpos($result, '✅') === 0) {
            $message = $result;
        } else {
            $error = $result;
        }
    }
}

// Fonction de réinitialisation
function handlePasswordReset($email) {
    global $pdo;
    
    try {
        // Vérifier si l'utilisateur existe
        $stmt = $pdo->prepare("SELECT id, name FROM users WHERE email = ? AND status = 'active'");
        $stmt->execute([$email]);
        $user = $stmt->fetch();
        
        if (!$user) {
            return "❌ Aucun compte actif trouvé avec cet email";
        }
        
        // Générer token de réinitialisation
        $reset_token = bin2hex(random_bytes(32));
        $expires = date('Y-m-d H:i:s', strtotime('+1 hour'));
        
        // Sauvegarder le token
        $stmt = $pdo->prepare("
            UPDATE users 
            SET reset_token = ?, reset_token_expires = ? 
            WHERE id = ?
        ");
        $stmt->execute([$reset_token, $expires, $user['id']]);
        
        // Préparer l'email
        $reset_link = "https://laloee-cours.fr/social-media-generator/reset_password.php?token=" . $reset_token;
        
        $subject = "🔐 Réinitialisation de votre mot de passe SMG Studio";
        $body = "
        <html>
        <head>
            <meta charset='UTF-8'>
            <style>
                body { font-family: Arial, sans-serif; color: #333; }
                .container { max-width: 600px; margin: 0 auto; padding: 20px; }
                .header { text-align: center; background: #667eea; color: white; padding: 20px; border-radius: 8px 8px 0 0; }
                .content { background: #f8f9fa; padding: 30px; border-radius: 0 0 8px 8px; }
                .button { 
                    display: inline-block; 
                    background: #667eea; 
                    color: white; 
                    padding: 15px 30px; 
                    text-decoration: none; 
                    border-radius: 8px;
                    margin: 20px 0;
                }
                .footer { text-align: center; color: #666; font-size: 12px; margin-top: 20px; }
            </style>
        </head>
        <body>
            <div class='container'>
                <div class='header'>
                    <h2>🔐 Réinitialisation de Mot de Passe</h2>
                </div>
                <div class='content'>
                    <p>Bonjour <strong>" . htmlspecialchars($user['name']) . "</strong>,</p>
                    <p>Vous avez demandé la réinitialisation de votre mot de passe pour SMG Studio.</p>
                    <p>Cliquez sur le bouton ci-dessous pour créer un nouveau mot de passe :</p>
                    <div style='text-align: center;'>
                        <a href='{$reset_link}' class='button'>
                            🔄 Réinitialiser mon mot de passe
                        </a>
                    </div>
                    <p><strong>⚠️ Ce lien expire dans 1 heure.</strong></p>
                    <p>Si vous n'avez pas demandé cette réinitialisation, ignorez cet email.</p>
                    <p>Pour votre sécurité, ne partagez jamais ce lien.</p>
                </div>
                <div class='footer'>
                    <p>SMG Studio v2.0 - Social Media Generator by Audiovizu</p>
                    <p>Audiovizu Edition</p>
                </div>
            </div>
        </body>
        </html>
        ";
        
        // Envoyer avec la fonction sendMail()
        $mailResult = sendMail($email, $subject, $body);
        
        if ($mailResult === true) {
            return "✅ Un lien de réinitialisation a été envoyé à votre email";
        } else {
            return "❌ Erreur lors de l'envoi de l'email : " . $mailResult;
        }
        
    } catch (Exception $e) {
        error_log("Erreur reset password: " . $e->getMessage());
        return "❌ Erreur système lors de la réinitialisation";
    }
}

// Gestion des paramètres URL
$urlParams = $_GET;
if (isset($urlParams['logout'])) {
    $message = "✅ Déconnexion réussie";
}
if (isset($urlParams['expired'])) {
    $error = "⏰ Session expirée, veuillez vous reconnecter";
}
if (isset($urlParams['reset_success'])) {
    $message = "✅ Mot de passe modifié avec succès ! Vous pouvez maintenant vous connecter.";
}
if (isset($urlParams['reset_error'])) {
    $error = "❌ Erreur lors de la réinitialisation";
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>🔐 SMG - Connexion</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }

        .login-container {
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 40px rgba(0,0,0,0.1);
            padding: 40px;
            width: 100%;
            max-width: 400px;
            text-align: center;
        }

        .logo {
            font-size: 48px;
            margin-bottom: 10px;
        }

        .title {
            color: #333;
            font-size: 28px;
            font-weight: 600;
            margin-bottom: 8px;
        }

        .subtitle {
            color: #666;
            font-size: 16px;
            margin-bottom: 30px;
        }

        .form-group {
            margin-bottom: 20px;
            text-align: left;
        }

        .form-label {
            display: block;
            color: #555;
            font-weight: 600;
            margin-bottom: 8px;
            font-size: 14px;
        }

        .form-input {
            width: 100%;
            padding: 15px 20px;
            border: 2px solid #e9ecef;
            border-radius: 12px;
            font-size: 16px;
            transition: all 0.3s ease;
            background: #f8f9fa;
        }

        .form-input:focus {
            outline: none;
            border-color: #667eea;
            background: white;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        }

        .btn {
            width: 100%;
            padding: 15px 20px;
            border: none;
            border-radius: 12px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            margin-top: 10px;
            text-decoration: none;
            display: inline-block;
            text-align: center;
        }

        .btn-login {
            background: linear-gradient(135deg, #667eea, #764ba2);
            color: white;
        }

        .btn-forgot {
            background: #6c757d;
            color: white;
            font-size: 14px;
            padding: 10px 20px;
            margin-top: 15px;
        }

        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 25px rgba(102, 126, 234, 0.3);
        }

        .btn:active {
            transform: translateY(0);
        }

        .error-message {
            background: #fee;
            color: #c33;
            padding: 12px;
            border-radius: 8px;
            margin: 15px 0;
            font-size: 14px;
            border: 1px solid #fcc;
        }

        .success-message {
            background: #efe;
            color: #363;
            padding: 12px;
            border-radius: 8px;
            margin: 15px 0;
            font-size: 14px;
            border: 1px solid #cfc;
        }

        .footer {
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #eee;
            color: #888;
            font-size: 12px;
        }

        .loading {
            opacity: 0.7;
            pointer-events: none;
        }

        .loading .btn {
            background: #ccc;
        }

        .form-toggle {
            margin-top: 20px;
            padding-top: 20px;
            border-top: 1px solid #eee;
        }

        .toggle-link {
            color: #667eea;
            text-decoration: none;
            font-size: 14px;
            font-weight: 500;
        }

        .toggle-link:hover {
            text-decoration: underline;
        }

        .hidden {
            display: none;
        }

        .forgot-form {
            text-align: left;
        }

        .forgot-info {
            background: #e7f3ff;
            color: #004085;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
            font-size: 14px;
            border: 1px solid #b6d7ff;
        }

        /* Navigation info */
        .nav-info {
            background: #fff3cd;
            color: #856404;
            padding: 12px;
            border-radius: 8px;
            margin-bottom: 20px;
            font-size: 13px;
            border: 1px solid #ffeaa7;
        }

        /* Responsive */
        @media (max-width: 480px) {
            .login-container {
                padding: 30px 20px;
            }
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="logo">🎬</div>
        <h1 class="title">SMG Studio</h1>
        <p class="subtitle">Social Media Generator</p>

        <!-- Info navigation -->
        <div class="nav-info">
            🎯 <strong>Après connexion :</strong> Vous serez redirigé vers le Dashboard principal
        </div>

        <!-- Messages -->
        <div id="messages">
            <?php if ($message): ?>
                <div class="success-message"><?= htmlspecialchars($message) ?></div>
            <?php endif; ?>
            <?php if ($error): ?>
                <div class="error-message"><?= htmlspecialchars($error) ?></div>
            <?php endif; ?>
        </div>

        <!-- Formulaire de connexion -->
        <div id="loginForm">
            <form id="authForm" action="auth.php" method="POST">
                <div class="form-group">
                    <label class="form-label" for="email">📧 Email</label>
                    <input 
                        type="email" 
                        id="email" 
                        name="email" 
                        class="form-input" 
                        placeholder="votre@email.com"
                        required
                        autocomplete="email"
                    >
                </div>

                <div class="form-group">
                    <label class="form-label" for="password">🔐 Mot de passe</label>
                    <input 
                        type="password" 
                        id="password" 
                        name="password" 
                        class="form-input" 
                        placeholder="Votre mot de passe"
                        required
                        autocomplete="current-password"
                    >
                </div>

                <button type="submit" class="btn btn-login">
                    🚀 Se connecter
                </button>
            </form>

            <div class="form-toggle">
                <a href="#" class="toggle-link" onclick="showForgotForm(); return false;">
                    🔄 Mot de passe oublié ?
                </a>
            </div>
        </div>

        <!-- Formulaire mot de passe oublié -->
        <div id="forgotForm" class="hidden">
            <div class="forgot-info">
                💡 <strong>Réinitialisation de mot de passe</strong><br>
                Entrez votre email pour recevoir un lien de réinitialisation.
            </div>

            <form class="forgot-form" action="" method="POST">
                <input type="hidden" name="action" value="forgot_password">
                
                <div class="form-group">
                    <label class="form-label" for="reset-email">📧 Votre Email</label>
                    <input 
                        type="email" 
                        id="reset-email" 
                        name="email" 
                        class="form-input" 
                        placeholder="votre@email.com"
                        required
                    >
                </div>

                <button type="submit" class="btn btn-forgot">
                    📧 Envoyer le lien de réinitialisation
                </button>
            </form>

            <div class="form-toggle">
                <a href="#" class="toggle-link" onclick="showLoginForm(); return false;">
                    ← Retour à la connexion
                </a>
            </div>
        </div>

        <div class="footer">
            <p>✨ SMG v2.0 - Modules autonomes</p>
            <p>🔒 Session sécurisée - Audiovizu Edition</p>
        </div>
    </div>

    <script>
        // Gestion du formulaire de connexion
        document.getElementById('authForm').addEventListener('submit', function(e) {
            e.preventDefault();
            
            const form = this;
            const formData = new FormData(form);
            const container = document.querySelector('.login-container');
            
            // Loading state
            container.classList.add('loading');
            showMessage('🔄 Connexion en cours...', 'info');
            
            // Envoi des données
            fetch('auth.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    showMessage('✅ Connexion réussie ! Redirection vers le Dashboard...', 'success');
                    setTimeout(() => {
                        window.location.href = 'dashboard.php'; // 🎯 DASHBOARD !
                    }, 1000);
                } else {
                    showMessage('❌ ' + (data.message || 'Erreur de connexion'), 'error');
                }
            })
            .catch(error => {
                console.error('Erreur:', error);
                showMessage('❌ Erreur de connexion au serveur', 'error');
            })
            .finally(() => {
                container.classList.remove('loading');
            });
        });

        // Affichage des messages
        function showMessage(message, type = 'info') {
            const messagesDiv = document.getElementById('messages');
            const messageClass = type === 'error' ? 'error-message' : 
                                type === 'success' ? 'success-message' : 
                                'info-message';
            
            messagesDiv.innerHTML = `<div class="${messageClass}">${message}</div>`;
            
            // Auto-clear après 5 secondes (sauf erreurs)
            if (type !== 'error') {
                setTimeout(() => {
                    messagesDiv.innerHTML = '';
                }, 5000);
            }
        }

        // Basculer vers formulaire mot de passe oublié
        function showForgotForm() {
            document.getElementById('loginForm').classList.add('hidden');
            document.getElementById('forgotForm').classList.remove('hidden');
            document.getElementById('reset-email').focus();
            
            // Effacer les messages
            document.getElementById('messages').innerHTML = '';
        }

        // Basculer vers formulaire de connexion
        function showLoginForm() {
            document.getElementById('forgotForm').classList.add('hidden');
            document.getElementById('loginForm').classList.remove('hidden');
            document.getElementById('email').focus();
            
            // Effacer les messages
            document.getElementById('messages').innerHTML = '';
        }

        // Focus automatique sur le premier champ
        document.getElementById('email').focus();

        console.log('🔐 SMG Login Ready - Dashboard First! 🎯');
    </script>
</body>
</html>