<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Social Media Generator</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/tailwindcss/2.2.19/tailwind.min.css" rel="stylesheet">
    <style>
        .fade-in { opacity: 0; animation: fadeIn 0.5s ease-in forwards; }
        @keyframes fadeIn { to { opacity: 1; } }
        .slide-in { transform: translateX(-20px); opacity: 0; animation: slideIn 0.5s ease-out forwards; }
        @keyframes slideIn { to { transform: translateX(0); opacity: 1; } }
        .network-icon { 
            width: 24px; height: 24px; 
            display: inline-flex; align-items: center; justify-content: center;
            border-radius: 6px; margin-right: 8px; font-size: 14px;
        }
        .facebook { background: #1877f2; color: white; }
        .instagram { background: linear-gradient(45deg, #f09433 0%,#e6683c 25%,#dc2743 50%,#cc2366 75%,#bc1888 100%); color: white; }
        .tiktok { background: #000000; color: white; }
        .linkedin { background: #0A66C2; color: white; }
        .snapchat { background: #FFFC00; color: #000; }
        .status-connected { color: #10b981; }
        .status-disconnected { color: #ef4444; }
    </style>
</head>
<body class="bg-gray-50">
    <div id="app" class="fade-in">
        <!-- LOGIN SCREEN -->
        <div id="loginScreen" class="min-h-screen bg-gradient-to-br from-blue-50 to-indigo-100 flex items-center justify-center p-4">
            <div class="max-w-md w-full bg-white rounded-xl shadow-lg p-8 slide-in">
                <div class="text-center mb-8">
                    <div class="w-16 h-16 bg-blue-600 rounded-full flex items-center justify-center mx-auto mb-4">
                        <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"></path>
                        </svg>
                    </div>
                    <h1 class="text-3xl font-bold text-gray-900 mb-2">Social Media Generator</h1>
                    <p class="text-gray-600">Connectez-vous pour gérer vos réseaux sociaux</p>
                </div>

                <div class="space-y-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Email</label>
                        <input
                            type="email"
                            id="email"
                            class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500"
                            placeholder="votre@email.com"
                        >
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Mot de passe</label>
                        <input
                            type="password"
                            id="password"
                            class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500"
                            placeholder="••••••••"
                        >
                    </div>
                    <button
                        onclick="login()"
                        class="w-full bg-blue-600 text-white py-3 px-4 rounded-lg hover:bg-blue-700 transition-colors font-medium"
                    >
                        Se connecter
                    </button>
                </div>

                <div class="mt-6 text-center">
                    <p class="text-sm text-gray-500">Login par défaut: admin@laloee-cours.fr / admin123</p>
                </div>
            </div>
        </div>

        <!-- DASHBOARD -->
        <div id="dashboard" class="hidden">
            <div class="flex h-screen bg-gray-50">
                <!-- SIDEBAR -->
                <div class="w-64 bg-white shadow-lg">
                    <div class="p-6 border-b">
                        <h1 class="text-xl font-bold text-gray-900">SMG Pro</h1>
                        <div class="mt-4 flex items-center">
                            <div class="w-8 h-8 bg-blue-600 rounded-full flex items-center justify-center text-white font-bold">
                                U
                            </div>
                            <div class="ml-3">
                                <p id="userName" class="text-sm font-medium text-gray-900">Utilisateur</p>
                                <p id="userEmail" class="text-xs text-gray-500">email@test.com</p>
                            </div>
                        </div>
                    </div>

                    <nav class="mt-6">
                        <a href="#" onclick="showTab('home')" class="nav-link flex items-center px-6 py-3 text-blue-600 bg-blue-50 border-r-2 border-blue-600">
                            <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"></path>
                            </svg>
                            Dashboard
                        </a>
                        <a href="#" onclick="showTab('posts')" class="nav-link flex items-center px-6 py-3 text-gray-700 hover:bg-gray-50">
                            <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path>
                            </svg>
                            Posts
                        </a>
                        <a href="#" onclick="showTab('clients')" class="nav-link flex items-center px-6 py-3 text-gray-700 hover:bg-gray-50">
                            <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path>
                            </svg>
                            Clients
                        </a>
                        <!-- NOUVEAU : Onglet Réseaux Sociaux -->
                        <a href="#" onclick="showTab('social')" class="nav-link flex items-center px-6 py-3 text-gray-700 hover:bg-gray-50">
                            <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13.828 10.172a4 4 0 00-5.656 0l-4 4a4 4 0 105.656 5.656l1.102-1.101m-.758-4.899a4 4 0 005.656 0l4-4a4 4 0 00-5.656-5.656l-1.1 1.1"></path>
                            </svg>
                            Réseaux Sociaux
                        </a>
                        <a href="#" onclick="showTab('analytics')" class="nav-link flex items-center px-6 py-3 text-gray-700 hover:bg-gray-50">
                            <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
                            </svg>
                            Analytics
                        </a>
                    </nav>

                    <div class="absolute bottom-0 w-64 p-6 border-t">
                        <button onclick="logout()" class="w-full flex items-center px-4 py-2 text-red-600 hover:bg-red-50 rounded-lg">
                            <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"></path>
                            </svg>
                            Déconnexion
                        </button>
                    </div>
                </div>

                <!-- MAIN CONTENT -->
                <div class="flex-1 overflow-auto">
                    <!-- HOME TAB -->
                    <div id="homeTab" class="tab-content p-8">
                        <div class="mb-8">
                            <h1 class="text-3xl font-bold text-gray-900 mb-2">Tableau de bord</h1>
                            <p class="text-gray-600">Vue d'ensemble de vos performances</p>
                        </div>

                        <!-- STATS -->
                        <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-8">
                            <div class="bg-white p-6 rounded-lg shadow hover:shadow-md transition-shadow">
                                <div class="flex items-center">
                                    <div class="w-12 h-12 bg-blue-100 rounded-lg flex items-center justify-center">
                                        <svg class="w-6 h-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path>
                                        </svg>
                                    </div>
                                    <div class="ml-4">
                                        <p class="text-sm font-medium text-gray-600">Total Posts</p>
                                        <p class="text-2xl font-bold text-gray-900" id="totalPosts">27</p>
                                    </div>
                                </div>
                            </div>

                            <div class="bg-white p-6 rounded-lg shadow hover:shadow-md transition-shadow">
                                <div class="flex items-center">
                                    <div class="w-12 h-12 bg-green-100 rounded-lg flex items-center justify-center">
                                        <svg class="w-6 h-6 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13.828 10.172a4 4 0 00-5.656 0l-4 4a4 4 0 105.656 5.656l1.102-1.101m-.758-4.899a4 4 0 005.656 0l4-4a4 4 0 00-5.656-5.656l-1.1 1.1"></path>
                                        </svg>
                                    </div>
                                    <div class="ml-4">
                                        <p class="text-sm font-medium text-gray-600">Comptes Connectés</p>
                                        <p class="text-2xl font-bold text-gray-900" id="connectedAccounts">0</p>
                                    </div>
                                </div>
                            </div>

                            <div class="bg-white p-6 rounded-lg shadow hover:shadow-md transition-shadow">
                                <div class="flex items-center">
                                    <div class="w-12 h-12 bg-purple-100 rounded-lg flex items-center justify-center">
                                        <svg class="w-6 h-6 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z"></path>
                                        </svg>
                                    </div>
                                    <div class="ml-4">
                                        <p class="text-sm font-medium text-gray-600">Engagements</p>
                                        <p class="text-2xl font-bold text-gray-900">451</p>
                                    </div>
                                </div>
                            </div>

                            <div class="bg-white p-6 rounded-lg shadow hover:shadow-md transition-shadow">
                                <div class="flex items-center">
                                    <div class="w-12 h-12 bg-orange-100 rounded-lg flex items-center justify-center">
                                        <svg class="w-6 h-6 text-orange-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6"></path>
                                        </svg>
                                    </div>
                                    <div class="ml-4">
                                        <p class="text-sm font-medium text-gray-600">Croissance</p>
                                        <p class="text-2xl font-bold text-gray-900">+15.3%</p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- RÉSEAUX SOCIAUX STATUS -->
                        <div class="bg-white rounded-lg shadow mb-8">
                            <div class="p-6 border-b flex justify-between items-center">
                                <h2 class="text-xl font-semibold text-gray-900">État des Réseaux Sociaux</h2>
                                <button onclick="showTab('social')" class="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700 text-sm">
                                    Gérer les Comptes
                                </button>
                            </div>
                            <div class="p-6">
                                <div id="socialNetworksStatus" class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                                    <!-- Status sera chargé par JavaScript -->
                                </div>
                            </div>
                        </div>

			// 🎯 SMG Auto-Refresh - Solution "Ça marche tout seul"
// À remplacer dans ton index.html ligne 576

// AVANT (l'ancien code lent)
/*
setInterval(() => {
    if (currentUser) {
        loadDashboardData();
    }
}, 30000); // 30 secondes = trop lent
*/

// APRÈS (le nouveau code qui déchire) 🚀
setInterval(() => {
    if (currentUser) {
        loadDashboardData();
        console.log('🔄 SMG Refresh auto -', new Date().toLocaleTimeString(), '- Comptes connectés mis à jour');
    }
}, 5000); // 5 secondes = quasi temps réel !

// BONUS : Refresh immédiat quand on change d'onglet
function showTab(tabName) {
    // Hide all tabs
    document.querySelectorAll('.tab-content').forEach(tab => {
        tab.classList.add('hidden');
    });

    // Show selected tab
    document.getElementById(tabName + 'Tab').classList.remove('hidden');

    // Update navigation
    document.querySelectorAll('.nav-link').forEach(link => {
        link.classList.remove('text-blue-600', 'bg-blue-50', 'border-r-2', 'border-blue-600');
        link.classList.add('text-gray-700');
    });

    event.target.classList.add('text-blue-600', 'bg-blue-50', 'border-r-2', 'border-blue-600');
    event.target.classList.remove('text-gray-700');
    
    // 🎯 NOUVEAU : Refresh immédiat des données quand on change d'onglet
    if (currentUser && tabName === 'home') {
        loadDashboardData();
        console.log('🏠 Refresh immédiat Dashboard - onglet Home activé');
    }
}

// SUPER BONUS : Refresh quand on revient sur la page (tab focus)
document.addEventListener('visibilitychange', function() {
    if (!document.hidden && currentUser) {
        loadDashboardData();
        console.log('👁️ Refresh auto - Page redevenue visible');
    }
});

	// MÉGA BONUS : Bouton refresh manuel dans le dashboard
	// À ajouter dans la section "État des Réseaux Sociaux" ligne 280 environ
	/*
	<div class="p-6 border-b flex justify-between items-center">
  	  <h2 class="text-xl font-semibold text-gray-900">État des Réseaux Sociaux</h2>
 	   <div class="flex space-x-2">
     	 	  <button onclick="forceRefresh()" class="bg-green-600 text-white px-4 py-2 rounded-lg hover:bg-green-700 text-sm flex items-center">
    	        🔄 Actualiser
      	  </button>
      	  <button onclick="showTab('social')" class="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700 text-sm">
       	     Gérer les Comptes
      	  </button>
  	  </div>
	</div>
*/

// Fonction refresh manuel
function forceRefresh() {
    loadDashboardData();
    console.log('🔄 Refresh FORCÉ par papy 77 !');
    
    // Petit effet visuel sympa
    const button = event.target;
    const originalText = button.innerHTML;
    button.innerHTML = '⏳ Actualisation...';
    button.disabled = true;
    
    setTimeout(() => {
        button.innerHTML = originalText;
        button.disabled = false;
        console.log('✅ Refresh terminé !');
    }, 1000);
}
                        <!-- RECENT POSTS -->
                        <div class="bg-white rounded-lg shadow">
                            <div class="p-6 border-b">
                                <h2 class="text-xl font-semibold text-gray-900">Posts récents</h2>
                            </div>
                            <div class="p-6">
                                <div id="recentPosts" class="space-y-4">
                                    <!-- Posts will be loaded here -->
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- POSTS TAB -->
                    <div id="postsTab" class="tab-content hidden p-8">
                        <div class="flex justify-between items-center mb-8">
                            <div>
                                <h1 class="text-3xl font-bold text-gray-900 mb-2">Gestion des Posts</h1>
                                <p class="text-gray-600">Créez et gérez vos publications</p>
                            </div>
                            <button onclick="showCreateForm()" class="bg-blue-600 text-white px-6 py-3 rounded-lg hover:bg-blue-700 flex items-center">
                                <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                                </svg>
                                Nouveau Post
                            </button>
                        </div>

                        <!-- CREATE FORM -->
                        <div id="createForm" class="hidden bg-white rounded-lg shadow p-6 mb-8">
                            <h3 class="text-lg font-semibold mb-4">Créer un nouveau post</h3>
                            <div class="space-y-4">
                                <input type="text" id="postTitle" placeholder="Titre du post" class="w-full px-4 py-2 border rounded-lg">
                                <textarea id="postContent" placeholder="Contenu du post..." rows="4" class="w-full px-4 py-2 border rounded-lg"></textarea>
                                <select id="postPlatform" class="w-full px-4 py-2 border rounded-lg">
                                    <option>Instagram</option>
                                    <option>Facebook</option>
                                    <option>Twitter</option>
                                    <option>LinkedIn</option>
                                    <option>TikTok</option>
                                    <option>Snapchat</option>
                                </select>
                                <div class="flex space-x-3">
                                    <button onclick="savePost()" class="bg-blue-600 text-white px-6 py-2 rounded-lg">Sauvegarder</button>
                                    <button onclick="hideCreateForm()" class="bg-gray-300 text-gray-700 px-6 py-2 rounded-lg">Annuler</button>
                                </div>
                            </div>
                        </div>

                        <!-- POSTS LIST -->
                        <div class="bg-white rounded-lg shadow">
                            <div class="p-6 border-b">
                                <h3 class="text-lg font-semibold text-gray-900">Tous les posts</h3>
                            </div>
                            <div class="p-6">
                                <div id="postsList" class="space-y-4">
                                    <!-- Posts will be loaded here -->
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- CLIENTS TAB -->
                    <div id="clientsTab" class="tab-content hidden p-8">
                        <h1 class="text-3xl font-bold text-gray-900 mb-8">Gestion des Clients</h1>
                        <div class="bg-white rounded-lg shadow p-8 text-center">
                            <svg class="w-16 h-16 mx-auto mb-4 text-gray-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path>
                            </svg>
                            <h3 class="text-lg font-medium text-gray-900 mb-2">Gestion des clients</h3>
                            <p class="text-gray-500">Interface de gestion des clients à venir</p>
                        </div>
                    </div>

                    <!-- SOCIAL NETWORKS TAB -->
                    <div id="socialTab" class="tab-content hidden">
                        <iframe 
                            src="/social-media-generator/social-accounts-manager.html" 
                            width="100%" 
                            height="100%" 
                            frameborder="0"
                            style="min-height: 100vh;"
                        ></iframe>
                    </div>

                    <!-- ANALYTICS TAB -->
                    <div id="analyticsTab" class="tab-content hidden p-8">
                        <h1 class="text-3xl font-bold text-gray-900 mb-8">Analytics</h1>
                        <div class="bg-white rounded-lg shadow p-8 text-center">
                            <svg class="w-16 h-16 mx-auto mb-4 text-gray-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
                            </svg>
                            <h3 class="text-lg font-medium text-gray-900 mb-2">Analytics détaillées</h3>
                            <p class="text-gray-500">Graphiques et métriques avancées à venir</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Application data
        let currentUser = null;
        let posts = [
            { id: 1, title: 'Stratégie Marketing Q3', content: 'Présentation de notre nouvelle stratégie...', platform: 'LinkedIn', date: '2025-07-11', views: 234 },
            { id: 2, title: 'Lancement Produit', content: 'Découvrez notre dernier produit innovant...', platform: 'Instagram', date: '2025-07-10', views: 456 },
            { id: 3, title: 'Événement à venir', content: 'Ne manquez pas notre prochain événement...', platform: 'Facebook', date: '2025-07-09', views: 189 }
        ];

        // Networks status
        let networksStatus = {
            facebook: { connected: false, username: '', error: null },
            instagram: { connected: false, username: '', error: null },
            tiktok: { connected: false, username: '', error: null },
            linkedin: { connected: false, username: '', error: null },
            snapchat: { connected: false, username: '', error: null }
        };

        // Initialize
        document.addEventListener('DOMContentLoaded', function() {
            const savedUser = localStorage.getItem('smg_user');
            if (savedUser) {
                currentUser = JSON.parse(savedUser);
                showDashboard();
            }
            loadRecentPosts();
            loadAllPosts();
            loadSocialNetworksStatus();
        });

        // Authentication
        function login() {
            const email = document.getElementById('email').value;
            const password = document.getElementById('password').value;

            if (email && password) {
                currentUser = { name: 'Utilisateur', email: email };
                localStorage.setItem('smg_user', JSON.stringify(currentUser));
                showDashboard();
            } else {
                alert('Veuillez remplir tous les champs');
            }
        }

        function logout() {
            currentUser = null;
            localStorage.removeItem('smg_user');
            showLogin();
        }

        function showLogin() {
            document.getElementById('loginScreen').classList.remove('hidden');
            document.getElementById('dashboard').classList.add('hidden');
        }

        function showDashboard() {
            document.getElementById('loginScreen').classList.add('hidden');
            document.getElementById('dashboard').classList.remove('hidden');

            if (currentUser) {
                document.getElementById('userName').textContent = currentUser.name;
                document.getElementById('userEmail').textContent = currentUser.email;
            }
            
            // Charger les données du dashboard
            loadDashboardData();
        }

        // Navigation
        function showTab(tabName) {
            // Hide all tabs
            document.querySelectorAll('.tab-content').forEach(tab => {
                tab.classList.add('hidden');
            });

            // Show selected tab
            document.getElementById(tabName + 'Tab').classList.remove('hidden');

            // Update navigation
            document.querySelectorAll('.nav-link').forEach(link => {
                link.classList.remove('text-blue-600', 'bg-blue-50', 'border-r-2', 'border-blue-600');
                link.classList.add('text-gray-700');
            });

            event.target.classList.add('text-blue-600', 'bg-blue-50', 'border-r-2', 'border-blue-600');
            event.target.classList.remove('text-gray-700');
        }

        // Load dashboard data
        async function loadDashboardData() {
            try {
                // Charger le statut des réseaux sociaux
                const response = await fetch('/social-media-generator/api/social-accounts.php?action=list');
                if (response.ok) {
                    const data = await response.json();
                    if (data.success) {
                        updateNetworksStatus(data.data.accounts);
                    }
                }
            } catch (error) {
                console.log('Erreur chargement données:', error);
            }
        }

        // Load social networks status
        async function loadSocialNetworksStatus() {
            try {
                const response = await fetch('/social-media-generator/api/social-accounts.php?action=list');
                if (response.ok) {
                    const data = await response.json();
                    if (data.success) {
                        updateNetworksStatus(data.data.accounts);
                    }
                }
            } catch (error) {
                console.log('Impossible de charger le statut des réseaux');
                displayDefaultNetworksStatus();
            }
        }

        function updateNetworksStatus(accounts) {
            const networks = ['facebook', 'instagram', 'tiktok', 'linkedin', 'snapchat'];
            let connectedCount = 0;
            
            networks.forEach(network => {
                if (accounts && accounts[network] && accounts[network].status === 'connected') {
                    networksStatus[network] = {
                        connected: true,
                        username: accounts[network].username || 'Connecté',
                        error: null
                    };
                    connectedCount++;
                } else {
                    networksStatus[network] = {
                        connected: false,
                        username: '',
                        error: null
                    };
                }
            });
            
            // Mettre à jour le compteur dans le dashboard
            document.getElementById('connectedAccounts').textContent = connectedCount;
            
            // Afficher le statut des réseaux
            displayNetworksStatus();
        }

        function displayNetworksStatus() {
            const container = document.getElementById('socialNetworksStatus');
            if (!container) return;
            
            const networkConfigs = {
                facebook: { name: 'Facebook', icon: '📘', class: 'facebook' },
                instagram: { name: 'Instagram', icon: '📸', class: 'instagram' },
                tiktok: { name: 'TikTok', icon: '🎵', class: 'tiktok' },
                linkedin: { name: 'LinkedIn', icon: '💼', class: 'linkedin' },
                snapchat: { name: 'Snapchat', icon: '👻', class: 'snapchat' }
            };
            
            container.innerHTML = Object.keys(networkConfigs).map(network => {
                const config = networkConfigs[network];
                const status = networksStatus[network];
                const isConnected = status.connected;
                
                return `
                    <div class="flex items-center justify-between p-4 border border-gray-200 rounded-lg hover:shadow-md transition-shadow">
                        <div class="flex items-center">
                            <div class="network-icon ${config.class}">${config.icon}</div>
                            <div>
                                <h4 class="font-medium text-gray-900">${config.name}</h4>
                                <p class="text-sm text-gray-500">
                                    ${isConnected ? status.username : 'Non connecté'}
                                </p>
                            </div>
                        </div>
                        <div class="flex items-center">
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium ${
                                isConnected ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800'
                            }">
                                ${isConnected ? '✅ Connecté' : '❌ Déconnecté'}
                            </span>
                        </div>
                    </div>
                `;
            }).join('');
        }

        function displayDefaultNetworksStatus() {
            // Affichage par défaut si l'API n'est pas accessible
            Object.keys(networksStatus).forEach(network => {
                networksStatus[network] = {
                    connected: false,
                    username: '',
                    error: 'API non accessible'
                };
            });
            displayNetworksStatus();
        }

        // Posts management
        function showCreateForm() {
            document.getElementById('createForm').classList.remove('hidden');
        }

        function hideCreateForm() {
            document.getElementById('createForm').classList.add('hidden');
            document.getElementById('postTitle').value = '';
            document.getElementById('postContent').value = '';
        }

        function savePost() {
            const title = document.getElementById('postTitle').value;
            const content = document.getElementById('postContent').value;
            const platform = document.getElementById('postPlatform').value;

            if (title && content) {
                const newPost = {
                    id: Date.now(),
                    title: title,
                    content: content,
                    platform: platform,
                    date: new Date().toISOString().split('T')[0],
                    views: Math.floor(Math.random() * 200) + 50
                };

                posts.unshift(newPost);
                loadRecentPosts();
                loadAllPosts();
                hideCreateForm();
                
                // Mettre à jour le compteur
                document.getElementById('totalPosts').textContent = posts.length;

                // Show success message
                alert('Post créé avec succès !');
            } else {
                alert('Veuillez remplir tous les champs');
            }
        }

        function deletePost(postId) {
            if (confirm('Êtes-vous sûr de vouloir supprimer ce post ?')) {
                posts = posts.filter(post => post.id !== postId);
                loadRecentPosts();
                loadAllPosts();
                
                // Mettre à jour le compteur
                document.getElementById('totalPosts').textContent = posts.length;
            }
        }

        function loadRecentPosts() {
            const container = document.getElementById('recentPosts');
            const recentPosts = posts.slice(0, 3);

            container.innerHTML = recentPosts.map(post => `
                <div class="flex items-center justify-between p-4 bg-gray-50 rounded-lg hover:bg-gray-100 transition-colors">
                    <div class="flex items-center">
                        <div class="w-10 h-10 bg-blue-100 rounded-lg flex items-center justify-center">
                            <svg class="w-5 h-5 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8.684 13.342C8.886 12.938 9 12.482 9 12c0-.482-.114-.938-.316-1.342m0 2.684a3 3 0 110-2.684m0 2.684l6.632 3.316m-6.632-6l6.632-3.316m0 0a3 3 0 105.367-2.684 3 3 0 00-5.367 2.684zm0 9.316a3 3 0 105.367 2.684 3 3 0 00-5.367-2.684z"></path>
                            </svg>
                        </div>
                        <div class="ml-4">
                            <h3 class="font-medium text-gray-900">${post.title}</h3>
                            <p class="text-sm text-gray-500">${post.platform} • ${post.date}</p>
                        </div>
                    </div>
                    <div class="text-right">
                        <p class="font-medium text-gray-900">${post.views} vues</p>
                        <p class="text-sm text-gray-500">Récent</p>
                    </div>
                </div>
            `).join('');
        }

        function loadAllPosts() {
            const container = document.getElementById('postsList');

            if (posts.length === 0) {
                container.innerHTML = `
                    <div class="text-center py-8 text-gray-500">
                        <svg class="w-12 h-12 mx-auto mb-4 text-gray-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path>
                        </svg>
                        <p>Aucun post pour le moment</p>
                        <button onclick="showCreateForm()" class="mt-4 bg-blue-600 text-white px-4 py-2 rounded-lg">Créer votre premier post</button>
                    </div>
                `;
            } else {
                container.innerHTML = posts.map(post => `
                    <div class="flex items-center justify-between p-4 bg-gray-50 rounded-lg hover:bg-gray-100 transition-colors">
                        <div class="flex-1">
                            <h3 class="font-medium text-gray-900">${post.title}</h3>
                            <p class="text-sm text-gray-500 mb-1">${post.platform} • ${post.date} • ${post.views} vues</p>
                            <p class="text-sm text-gray-600">${post.content.substring(0, 80)}${post.content.length > 80 ? '...' : ''}</p>
                        </div>
                        <div class="flex space-x-2 ml-4">
                            <button class="p-2 text-blue-600 hover:bg-blue-50 rounded transition-colors">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path>
                                </svg>
                            </button>
                            <button onclick="deletePost(${post.id})" class="p-2 text-red-600 hover:bg-red-50 rounded transition-colors">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path>
                                </svg>
                            </button>
                        </div>
                    </div>
                `).join('');
            }
        }

    

	// APRÈS (le nouveau code qui déchire) 🚀
	setInterval(() => {
 	   if (currentUser) {
 	       loadDashboardData();
  	      console.log('🔄 SMG Refresh auto -', new Date().toLocaleTimeString(), '- Comptes connectés mis à jour');
  	  }
	}, 5000); // 5 secondes = quasi temps réel !

	// BONUS : Refresh immédiat quand on change d'onglet
	function showTab(tabName) {
   	 // Hide all tabs
   	 document.querySelectorAll('.tab-content').forEach(tab => {
    	    tab.classList.add('hidden');
  	  });

	   // Show selected tab
  	  document.getElementById(tabName + 'Tab').classList.remove('hidden');

   	 // Update navigation
   	 document.querySelectorAll('.nav-link').forEach(link => {
        link.classList.remove('text-blue-600', 'bg-blue-50', 'border-r-2', 'border-blue-600');
        link.classList.add('text-gray-700');
   	 });

   	 event.target.classList.add('text-blue-600', 'bg-blue-50', 'border-r-2', 'border-blue-600');
   	 event.target.classList.remove('text-gray-700');
    
   	 // 🎯 NOUVEAU : Refresh immédiat des données quand on change d'onglet
   	 if (currentUser && tabName === 'home') {
        loadDashboardData();
        console.log('🏠 Refresh immédiat Dashboard - onglet Home activé');
   	 }
	}

	// SUPER BONUS : Refresh quand on revient sur la page (tab focus)
	document.addEventListener('visibilitychange', function() {
  	  if (!document.hidden && currentUser) {
        loadDashboardData();
        console.log('👁️ Refresh auto - Page redevenue visible');
  	  }
	});



        // API Configuration for future PHP integration
        const API_CONFIG = {
            baseURL: '/social-media-generator/api'
        };

        // Future API integration functions
        async function syncWithAPI() {
            console.log('Ready for API integration with', API_CONFIG.baseURL);
        }

        // Initialize everything
        document.addEventListener('DOMContentLoaded', function() {
            // Set initial posts count
            document.getElementById('totalPosts').textContent = posts.length;
        });
    </script>
</body>
</html>