<?php
$host = 'localhost';
$dbname = 'laloedata';
$username = 'laloedata';
$password = 'PiL256Mx78!';
$charset = 'utf8mb4';

$dsn = "mysql:host=$host;dbname=$dbname;charset=$charset";
$options = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
];

try {
    $pdo = new PDO($dsn, $username, $password, $options);

    // 1️⃣ Profils IA actifs
    $stmt1 = $pdo->query("
        SELECT 
            uap.id,
            uap.user_id,
            uap.ai_provider,
            uap.display_name,
            uap.is_active,
            uap.is_default,
            u.name as user_name,
            u.email
        FROM user_ai_profiles uap
        LEFT JOIN users u ON uap.user_id = u.id
        WHERE uap.is_active = 1
    ");
    $results1 = $stmt1->fetchAll();

    // 2️⃣ Utilisateurs actifs
    $stmt2 = $pdo->query("SELECT id, name, email, status FROM users WHERE status = 'active'");
    $results2 = $stmt2->fetchAll();

    // 3️⃣ Clés API actives
    $stmt3 = $pdo->query("
        SELECT ak.id, ak.user_id, ak.provider, ak.key_name, ak.is_active
        FROM api_keys ak
        WHERE ak.is_active = 1
    ");
    $results3 = $stmt3->fetchAll();

} catch (PDOException $e) {
    echo "❌ Erreur de connexion : " . $e->getMessage();
    exit;
}

// Fonction d'affichage HTML
function displayTable($title, $data) {
    if (empty($data)) {
        echo "<h3>$title</h3><p><em>❌ Aucun résultat.</em></p>";
        return;
    }

    echo "<h3>$title</h3><table border='1' cellpadding='6'><thead><tr>";
    foreach (array_keys($data[0]) as $key) {
        echo "<th>" . htmlspecialchars($key) . "</th>";
    }
    echo "</tr></thead><tbody>";
    foreach ($data as $row) {
        echo "<tr>";
        foreach ($row as $val) {
            echo "<td>" . htmlspecialchars($val) . "</td>";
        }
        echo "</tr>";
    }
    echo "</tbody></table><br>";
}

?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>🔍 Vérification Base LALOEE</title>
</head>
<body>
    <h1>🔍 Vérification des Profils IA, Utilisateurs et Clés API</h1>
    <?php
        displayTable("✅ Profils IA actifs", $results1);
        displayTable("✅ Utilisateurs actifs", $results2);
        displayTable("✅ Clés API actives", $results3);
    ?>
</body>
</html>
