<?php
session_start();
require_once '../../env/.env.php';

// Vérification de l'authentification
if (!isset($_SESSION['user_id'])) {
    header('Location: ../login.php');
    exit;
}

// Traitement de la soumission du formulaire
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $pdo = new PDO(
            "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=" . DB_CHARSET,
            DB_USER,
            DB_PASS,
            [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
        );
        
        $step = $_POST['step'] ?? 1;
        
        if ($step == 1) {
            // Étape 1 : Informations de base
            $project_name = trim($_POST['project_name']);
            $description = trim($_POST['description'] ?? '');
            $author = $_SESSION['user_name'];
            
            if (empty($project_name)) {
                throw new Exception("Le nom du projet est requis");
            }
            
            // Générer un slug unique
            $project_slug = generateUniqueSlug($project_name, $pdo);
            
            // Créer le projet
            $stmt = $pdo->prepare("
                INSERT INTO flying_book_projects 
                (user_id, project_name, project_slug, title, description, created_at) 
                VALUES (?, ?, ?, ?, ?, NOW())
            ");
            $stmt->execute([
                $_SESSION['user_id'],
                $project_name,
                $project_slug,
                $project_name,
                $description
            ]);
            
            $project_id = $pdo->lastInsertId();
            
            // Créer le répertoire du projet
            $project_folder = "project_" . $project_id . "_" . time();
            $project_path = "../../document/projects/" . $project_folder;
            
            if (!file_exists($project_path)) {
                mkdir($project_path, 0755, true);
                mkdir($project_path . "/media", 0755, true);
                mkdir($project_path . "/thumbnails", 0755, true);
            }
            
            // Mettre à jour le projet avec le dossier
            $stmt = $pdo->prepare("UPDATE flying_book_projects SET project_folder = ? WHERE id = ?");
            $stmt->execute([$project_folder, $project_id]);
            
            // Rediriger vers l'étape 2
            header("Location: create.php?step=2&project_id=" . $project_id);
            exit;
            
        } elseif ($step == 2) {
            // Étape 2 : Métadonnées et style
            $project_id = $_POST['project_id'];
            $title = trim($_POST['title']);
            $subtitle = trim($_POST['subtitle'] ?? '');
            $style_theme = $_POST['style_theme'] ?? 'moderne';
            
            if (empty($title)) {
                throw new Exception("Le titre principal est requis");
            }
            
            $stmt = $pdo->prepare("
                UPDATE flying_book_projects 
                SET title = ?, subtitle = ?, style_theme = ?, updated_at = NOW()
                WHERE id = ? AND user_id = ?
            ");
            $stmt->execute([$title, $subtitle, $style_theme, $project_id, $_SESSION['user_id']]);
            
            // Rediriger vers l'étape 3
            header("Location: create.php?step=3&project_id=" . $project_id);
            exit;
            
        } elseif ($step == 3) {
            // Étape 3 : Structure et navigation
            $project_id = $_POST['project_id'];
            $total_slides = intval($_POST['total_slides'] ?? 5);
            $transition_type = $_POST['transition_type'] ?? '3d';
            $navigation_type = $_POST['navigation_type'] ?? 'all';
            
            if ($total_slides < 1 || $total_slides > 100) {
                throw new Exception("Le nombre de slides doit être entre 1 et 100");
            }
            
            $stmt = $pdo->prepare("
                UPDATE flying_book_projects 
                SET total_slides = ?, transition_type = ?, navigation_type = ?, updated_at = NOW()
                WHERE id = ? AND user_id = ?
            ");
            $stmt->execute([$total_slides, $transition_type, $navigation_type, $project_id, $_SESSION['user_id']]);
            
            // Créer les slides de base
            for ($i = 1; $i <= $total_slides; $i++) {
                $stmt = $pdo->prepare("
                    INSERT INTO flying_book_slides 
                    (project_id, slide_number, slide_title, media_type, media_file, display_order, created_at)
                    VALUES (?, ?, ?, 'text_image', 'placeholder.jpg', ?, NOW())
                ");
                $stmt->execute([$project_id, $i, "Slide $i", $i]);
            }
            
            // Rediriger vers l'étape 4 (contenu)
            header("Location: ../slides/edit.php?project_id=" . $project_id);
            exit;
        }
        
    } catch (Exception $e) {
        $error = $e->getMessage();
    }
}

// Récupérer les données du projet si on est dans les étapes 2 ou 3
$project = null;
$step = intval($_GET['step'] ?? 1);
$project_id = intval($_GET['project_id'] ?? 0);

if ($step > 1 && $project_id > 0) {
    try {
        $pdo = new PDO(
            "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=" . DB_CHARSET,
            DB_USER,
            DB_PASS,
            [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
        );
        
        $stmt = $pdo->prepare("
            SELECT * FROM flying_book_projects 
            WHERE id = ? AND user_id = ?
        ");
        $stmt->execute([$project_id, $_SESSION['user_id']]);
        $project = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if (!$project) {
            header("Location: create.php");
            exit;
        }
    } catch (PDOException $e) {
        header("Location: create.php");
        exit;
    }
}

function generateUniqueSlug($name, $pdo) {
    $base_slug = strtolower(trim(preg_replace('/[^A-Za-z0-9-]+/', '-', $name), '-'));
    $slug = $base_slug;
    $counter = 1;
    
    do {
        $stmt = $pdo->prepare("SELECT id FROM flying_book_projects WHERE project_slug = ?");
        $stmt->execute([$slug]);
        
        if (!$stmt->fetch()) {
            return $slug;
        }
        
        $slug = $base_slug . '-' . $counter;
        $counter++;
    } while ($counter < 100);
    
    return $base_slug . '-' . time();
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Flying Book Creator - Nouveau projet</title>
    <link rel="stylesheet" href="../assets/css/wizard.css">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
</head>
<body>
    <!-- Header avec progression -->
    <header class="wizard-header">
        <div class="header-container">
            <div class="logo">
                <a href="../dashboard.php">
                    <i class="fas fa-book-open"></i>
                    <span>Flying Book</span>
                </a>
            </div>
            
            <div class="progress-container">
                <div class="progress-bar">
                    <div class="progress-fill" style="width: <?= ($step / 3) * 100 ?>%"></div>
                </div>
                <div class="progress-steps">
                    <div class="step <?= $step >= 1 ? 'active' : '' ?> <?= $step > 1 ? 'completed' : '' ?>">
                        <div class="step-number">1</div>
                        <div class="step-label">Projet</div>
                    </div>
                    <div class="step <?= $step >= 2 ? 'active' : '' ?> <?= $step > 2 ? 'completed' : '' ?>">
                        <div class="step-number">2</div>
                        <div class="step-label">Style</div>
                    </div>
                    <div class="step <?= $step >= 3 ? 'active' : '' ?>">
                        <div class="step-number">3</div>
                        <div class="step-label">Structure</div>
                    </div>
                </div>
            </div>
            
            <div class="header-actions">
                <a href="../dashboard.php" class="btn btn-ghost">
                    <i class="fas fa-times"></i>
                    Annuler
                </a>
            </div>
        </div>
    </header>

    <main class="wizard-content">
        <div class="container">
            <?php if (isset($error)): ?>
                <div class="alert alert-error">
                    <i class="fas fa-exclamation-circle"></i>
                    <?= htmlspecialchars($error) ?>
                </div>
            <?php endif; ?>

            <!-- ÉTAPE 1 : Informations du projet -->
            <?php if ($step == 1): ?>
            <div class="wizard-step active">
                <div class="step-header">
                    <h1><i class="fas fa-rocket"></i> Créer un nouveau Flying Book</h1>
                    <p>Commençons par les informations de base de votre présentation interactive</p>
                </div>

                <form method="POST" class="wizard-form" id="step1Form">
                    <input type="hidden" name="step" value="1">
                    
                    <div class="form-section">
                        <div class="form-group">
                            <label for="project_name" class="required">
                                <i class="fas fa-bookmark"></i>
                                Nom du Flying Book
                            </label>
                            <input 
                                type="text" 
                                id="project_name" 
                                name="project_name" 
                                required
                                placeholder="Ex: Présentation IA Tokens, Mon Portfolio 2024..."
                                value="<?= htmlspecialchars($_POST['project_name'] ?? '') ?>"
                                maxlength="255"
                            >
                            <small class="form-help">Ce nom sera utilisé pour identifier votre projet dans votre dashboard</small>
                        </div>

                        <div class="form-group">
                            <label for="description">
                                <i class="fas fa-align-left"></i>
                                Description / Thème
                            </label>
                            <textarea 
                                id="description" 
                                name="description" 
                                rows="4"
                                placeholder="Décrivez brièvement le sujet ou l'objectif de votre présentation..."
                                maxlength="500"
                            ><?= htmlspecialchars($_POST['description'] ?? '') ?></textarea>
                            <small class="form-help">Optionnel - Aide à organiser vos projets</small>
                        </div>

                        <div class="form-group">
                            <label>
                                <i class="fas fa-user"></i>
                                Auteur
                            </label>
                            <input type="text" value="<?= htmlspecialchars($_SESSION['user_name']) ?>" readonly class="readonly">
                            <small class="form-help">Rempli automatiquement depuis votre profil</small>
                        </div>
                    </div>

                    <div class="form-actions">
                        <a href="../dashboard.php" class="btn btn-outline">
                            <i class="fas fa-arrow-left"></i>
                            Retour au dashboard
                        </a>
                        
                        <button type="submit" class="btn btn-primary">
                            Continuer
                            <i class="fas fa-arrow-right"></i>
                        </button>
                    </div>
                </form>
            </div>
            <?php endif; ?>

            <!-- ÉTAPE 2 : Métadonnées et style -->
            <?php if ($step == 2): ?>
            <div class="wizard-step active">
                <div class="step-header">
                    <h1><i class="fas fa-palette"></i> Style et métadonnées</h1>
                    <p>Personnalisez l'apparence et les informations de votre Flying Book</p>
                </div>

                <form method="POST" class="wizard-form" id="step2Form">
                    <input type="hidden" name="step" value="2">
                    <input type="hidden" name="project_id" value="<?= $project_id ?>">
                    
                    <div class="form-sections">
                        <div class="form-section">
                            <h3><i class="fas fa-heading"></i> Titres de présentation</h3>
                            
                            <div class="form-group">
                                <label for="title" class="required">Titre principal</label>
                                <input 
                                    type="text" 
                                    id="title" 
                                    name="title" 
                                    required
                                    placeholder="Le titre qui apparaîtra sur votre présentation"
                                    value="<?= htmlspecialchars($project['title'] ?? $project['project_name'] ?? '') ?>"
                                    maxlength="255"
                                >
                            </div>

                            <div class="form-group">
                                <label for="subtitle">Sous-titre</label>
                                <input 
                                    type="text" 
                                    id="subtitle" 
                                    name="subtitle" 
                                    placeholder="Sous-titre optionnel pour plus de contexte"
                                    value="<?= htmlspecialchars($project['subtitle'] ?? '') ?>"
                                    maxlength="255"
                                >
                            </div>
                        </div>

                        <div class="form-section">
                            <h3><i class="fas fa-paint-brush"></i> Style visuel</h3>
                            
                            <div class="form-group">
                                <label>Choisissez un thème</label>
                                <div class="theme-selector">
                                    <div class="theme-option <?= ($project['style_theme'] ?? 'moderne') === 'moderne' ? 'selected' : '' ?>" 
                                         data-theme="moderne">
                                        <input type="radio" name="style_theme" value="moderne" 
                                               <?= ($project['style_theme'] ?? 'moderne') === 'moderne' ? 'checked' : '' ?>>
                                        <div class="theme-preview moderne">
                                            <div class="theme-header"></div>
                                            <div class="theme-content">
                                                <div class="theme-element"></div>
                                                <div class="theme-element small"></div>
                                            </div>
                                        </div>
                                        <div class="theme-info">
                                            <h4>Moderne</h4>
                                            <p>Design épuré avec des dégradés et animations fluides</p>
                                        </div>
                                    </div>

                                    <div class="theme-option <?= ($project['style_theme'] ?? '') === 'classique' ? 'selected' : '' ?>" 
                                         data-theme="classique">
                                        <input type="radio" name="style_theme" value="classique">
                                        <div class="theme-preview classique">
                                            <div class="theme-header"></div>
                                            <div class="theme-content">
                                                <div class="theme-element"></div>
                                                <div class="theme-element small"></div>
                                            </div>
                                        </div>
                                        <div class="theme-info">
                                            <h4>Classique</h4>
                                            <p>Style traditionnel, professionnel et intemporel</p>
                                        </div>
                                    </div>

                                    <div class="theme-option <?= ($project['style_theme'] ?? '') === 'corporate' ? 'selected' : '' ?>" 
                                         data-theme="corporate">
                                        <input type="radio" name="style_theme" value="corporate">
                                        <div class="theme-preview corporate">
                                            <div class="theme-header"></div>
                                            <div class="theme-content">
                                                <div class="theme-element"></div>
                                                <div class="theme-element small"></div>
                                            </div>
                                        </div>
                                        <div class="theme-info">
                                            <h4>Corporate</h4>
                                            <p>Design professionnel pour présentations d'entreprise</p>
                                        </div>
                                    </div>

                                    <div class="theme-option <?= ($project['style_theme'] ?? '') === 'minimal' ? 'selected' : '' ?>" 
                                         data-theme="minimal">
                                        <input type="radio" name="style_theme" value="minimal">
                                        <div class="theme-preview minimal">
                                            <div class="theme-header"></div>
                                            <div class="theme-content">
                                                <div class="theme-element"></div>
                                                <div class="theme-element small"></div>
                                            </div>
                                        </div>
                                        <div class="theme-info">
                                            <h4>Minimal</h4>
                                            <p>Simplicité et élégance, focus sur le contenu</p>
                                        </div>
                                    </div>

                                    <div class="theme-option <?= ($project['style_theme'] ?? '') === 'premium' ? 'selected' : '' ?>" 
                                         data-theme="premium">
                                        <input type="radio" name="style_theme" value="premium">
                                        <div class="theme-preview premium">
                                            <div class="theme-header"></div>
                                            <div class="theme-content">
                                                <div class="theme-element"></div>
                                                <div class="theme-element small"></div>
                                            </div>
                                        </div>
                                        <div class="theme-info">
                                            <h4>Premium <i class="fas fa-crown"></i></h4>
                                            <p>Design haut de gamme avec effets avancés</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="form-actions">
                        <a href="create.php?step=1" class="btn btn-outline">
                            <i class="fas fa-arrow-left"></i>
                            Étape précédente
                        </a>
                        
                        <button type="submit" class="btn btn-primary">
                            Continuer
                            <i class="fas fa-arrow-right"></i>
                        </button>
                    </div>
                </form>
            </div>
            <?php endif; ?>

            <!-- ÉTAPE 3 : Structure et navigation -->
            <?php if ($step == 3): ?>
            <div class="wizard-step active">
                <div class="step-header">
                    <h1><i class="fas fa-cogs"></i> Structure de la présentation</h1>
                    <p>Définissez la structure et les interactions de votre Flying Book</p>
                </div>

                <form method="POST" class="wizard-form" id="step3Form">
                    <input type="hidden" name="step" value="3">
                    <input type="hidden" name="project_id" value="<?= $project_id ?>">
                    
                    <div class="form-sections">
                        <div class="form-section">
                            <h3><i class="fas fa-images"></i> Nombre de slides</h3>
                            
                            <div class="form-group">
                                <label for="total_slides">Combien de slides voulez-vous créer ?</label>
                                <div class="slide-counter">
                                    <button type="button" class="counter-btn" onclick="changeSlideCount(-1)">
                                        <i class="fas fa-minus"></i>
                                    </button>
                                    <input 
                                        type="number" 
                                        id="total_slides" 
                                        name="total_slides" 
                                        value="<?= $project['total_slides'] ?? 5 ?>"
                                        min="1" 
                                        max="100"
                                        readonly
                                    >
                                    <button type="button" class="counter-btn" onclick="changeSlideCount(1)">
                                        <i class="fas fa-plus"></i>
                                    </button>
                                </div>
                                <small class="form-help">Vous pourrez ajouter ou supprimer des slides plus tard</small>
                            </div>
                        </div>

                        <div class="form-section">
                            <h3><i class="fas fa-exchange-alt"></i> Transitions entre slides</h3>
                            
                            <div class="form-group">
                                <label>Type de transition</label>
                                <div class="transition-selector">
                                    <div class="transition-option <?= ($project['transition_type'] ?? '3d') === 'fade' ? 'selected' : '' ?>" 
                                         data-transition="fade">
                                        <input type="radio" name="transition_type" value="fade">
                                        <div class="transition-preview">
                                            <div class="transition-demo fade">
                                                <div class="slide-demo"></div>
                                                <div class="slide-demo"></div>
                                            </div>
                                        </div>
                                        <h4>Fondu</h4>
                                        <p>Transition douce et élégante</p>
                                    </div>

                                    <div class="transition-option <?= ($project['transition_type'] ?? '3d') === 'slide' ? 'selected' : '' ?>" 
                                         data-transition="slide">
                                        <input type="radio" name="transition_type" value="slide">
                                        <div class="transition-preview">
                                            <div class="transition-demo slide">
                                                <div class="slide-demo"></div>
                                                <div class="slide-demo"></div>
                                            </div>
                                        </div>
                                        <h4>Glissement</h4>
                                        <p>Défilement horizontal classique</p>
                                    </div>

                                    <div class="transition-option <?= ($project['transition_type'] ?? '3d') === 'flip' ? 'selected' : '' ?>" 
                                         data-transition="flip">
                                        <input type="radio" name="transition_type" value="flip">
                                        <div class="transition-preview">
                                            <div class="transition-demo flip">
                                                <div class="slide-demo"></div>
                                                <div class="slide-demo"></div>
                                            </div>
                                        </div>
                                        <h4>Retournement</h4>
                                        <p>Effet de carte qui se retourne</p>
                                    </div>

                                    <div class="transition-option <?= ($project['transition_type'] ?? '3d') === '3d' ? 'selected' : '' ?>" 
                                         data-transition="3d">
                                        <input type="radio" name="transition_type" value="3d" checked>
                                        <div class="transition-preview">
                                            <div class="transition-demo threed">
                                                <div class="slide-demo"></div>
                                                <div class="slide-demo"></div>
                                            </div>
                                        </div>
                                        <h4>3D</h4>
                                        <p>Rotation 3D moderne</p>
                                    </div>

                                    <div class="transition-option <?= ($project['transition_type'] ?? '3d') === 'premium_3d' ? 'selected' : '' ?>" 
                                         data-transition="premium_3d">
                                        <input type="radio" name="transition_type" value="premium_3d">
                                        <div class="transition-preview">
                                            <div class="transition-demo premium">
                                                <div class="slide-demo"></div>
                                                <div class="slide-demo"></div>
                                            </div>
                                        </div>
                                        <h4>3D Premium <i class="fas fa-crown"></i></h4>
                                        <p>Effets 3D avancés avec particules</p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="form-section">
                            <h3><i class="fas fa-mouse-pointer"></i> Navigation</h3>
                            
                            <div class="form-group">
                                <label>Méthodes de navigation</label>
                                <div class="navigation-selector">
                                    <div class="nav-option <?= ($project['navigation_type'] ?? 'all') === 'buttons' ? 'selected' : '' ?>" 
                                         data-nav="buttons">
                                        <input type="radio" name="navigation_type" value="buttons">
                                        <div class="nav-preview">
                                            <i class="fas fa-chevron-left"></i>
                                            <div class="nav-content"></div>
                                            <i class="fas fa-chevron-right"></i>
                                        </div>
                                        <h4>Boutons uniquement</h4>
                                        <p>Navigation avec flèches gauche/droite</p>
                                    </div>

                                    <div class="nav-option <?= ($project['navigation_type'] ?? 'all') === 'thumbnails' ? 'selected' : '' ?>" 
                                         data-nav="thumbnails">
                                        <input type="radio" name="navigation_type" value="thumbnails">
                                        <div class="nav-preview">
                                            <div class="nav-content"></div>
                                            <div class="nav-thumbs">
                                                <div class="thumb"></div>
                                                <div class="thumb active"></div>
                                                <div class="thumb"></div>
                                            </div>
                                        </div>
                                        <h4>Miniatures</h4>
                                        <p>Navigation par aperçus des slides</p>
                                    </div>

                                    <div class="nav-option <?= ($project['navigation_type'] ?? 'all') === 'keyboard' ? 'selected' : '' ?>" 
                                         data-nav="keyboard">
                                        <input type="radio" name="navigation_type" value="keyboard">
                                        <div class="nav-preview">
                                            <div class="nav-content"></div>
                                            <div class="keyboard-hint">
                                                <i class="fas fa-keyboard"></i>
                                            </div>
                                        </div>
                                        <h4>Clavier uniquement</h4>
                                        <p>Navigation avec flèches du clavier</p>
                                    </div>

                                    <div class="nav-option <?= ($project['navigation_type'] ?? 'all') === 'all' ? 'selected' : '' ?>" 
                                         data-nav="all">
                                        <input type="radio" name="navigation_type" value="all" checked>
                                        <div class="nav-preview all-nav">
                                            <i class="fas fa-chevron-left"></i>
                                            <div class="nav-content"></div>
                                            <i class="fas fa-chevron-right"></i>
                                            <div class="nav-thumbs">
                                                <div class="thumb"></div>
                                                <div class="thumb active"></div>
                                                <div class="thumb"></div>
                                            </div>
                                        </div>
                                        <h4>Toutes les méthodes</h4>
                                        <p>Boutons + miniatures + clavier</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="form-actions">
                        <a href="create.php?step=2&project_id=<?= $project_id ?>" class="btn btn-outline">
                            <i class="fas fa-arrow-left"></i>
                            Étape précédente
                        </a>
                        
                        <button type="submit" class="btn btn-primary btn-lg">
                            <i class="fas fa-magic"></i>
                            Créer mon Flying Book
                        </button>
                    </div>
                </form>
            </div>
            <?php endif; ?>
        </div>
    </main>

    <script src="../assets/js/wizard.js"></script>
</body>
</html>