<?php
session_start();

// Vérification admin
if (!isset($_SESSION['user_role']) || $_SESSION['user_role'] !== 'admin') {
    header('Location: login.php');
    exit;
}

// --- ACTION: NETTOYAGE RAM OPCACHE ---
if (isset($_GET['action']) && $_GET['action'] === 'clear_cache') {
    if (function_exists('opcache_reset')) {
        opcache_reset();
        $message = "✅ OPCache vidé avec succès.";
    } else {
        $message = "⚠️ Fonction OPCache non disponible.";
    }
}

// --- ACTION: SUPPRESSION LOGS OBSOLÈTES ---
if (isset($_GET['action']) && $_GET['action'] === 'clean_logs') {
    $logDir = __DIR__ . '/logs';
    $deleted = 0;

    if (is_dir($logDir)) {
        foreach (glob("$logDir/*.log") as $file) {
            if (filemtime($file) < time() - 7 * 86400) {
                unlink($file);
                $deleted++;
            }
        }
        $message = "🗑️ $deleted fichiers .log supprimés du dossier logs/.";
    } else {
        $message = "📂 Dossier logs/ introuvable.";
    }
}

// --- ACTION: AFFICHAGE PHPINFO SIMPLE ---
if (isset($_GET['action']) && $_GET['action'] === 'show_phpinfo') {
    phpinfo();
    exit;
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Flying Book - Infos Système Admin</title>
    <link rel="stylesheet" href="assets/css/united-fixed.css">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        .admin-dashboard {
            max-width: 1200px;
            margin: 0 auto;
            padding: 2rem;
        }
        
        .info-cards {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 1.5rem;
            margin-bottom: 2rem;
        }
        
        .info-card {
            background: white;
            border-radius: 12px;
            padding: 1.5rem;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
            border-left: 4px solid var(--primary-color);
        }
        
        .info-card h3 {
            color: var(--primary-color);
            margin-bottom: 1rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }
        
        .info-list {
            list-style: none;
            padding: 0;
        }
        
        .info-list li {
            padding: 0.5rem 0;
            border-bottom: 1px solid var(--gray-200);
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .info-list li:last-child {
            border-bottom: none;
        }
        
        .status-good { color: var(--success-color); }
        .status-warning { color: var(--warning-color); }
        .status-error { color: var(--error-color); }
        
        .actions-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 1rem;
            margin: 2rem 0;
        }
        
        .action-card {
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            color: white;
            padding: 1.5rem;
            border-radius: 12px;
            text-decoration: none;
            transition: transform 0.3s ease;
            display: flex;
            align-items: center;
            gap: 1rem;
        }
        
        .action-card:hover {
            transform: translateY(-2px);
            color: white;
        }
        
        .action-card.danger {
            background: linear-gradient(135deg, var(--error-color), #dc2626);
        }
        
        .action-card i {
            font-size: 2rem;
        }
        
        .phpinfo-frame {
            width: 100%;
            height: 600px;
            border: 1px solid var(--gray-300);
            border-radius: 8px;
            background: white;
        }
        
        .back-link {
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            color: var(--primary-color);
            text-decoration: none;
            margin-bottom: 1rem;
            font-weight: 500;
        }
        
        .back-link:hover {
            color: var(--primary-hover);
        }
    </style>
</head>
<body>
    <!-- Header simplifié -->
    <header class="main-header">
        <div class="header-container">
            <div class="header-left">
                <a href="dashboard.php" class="logo">
                    <i class="fas fa-book-open"></i>
                    <span>Flying Book v2.0</span>
                </a>
            </div>
            <div class="header-right">
                <a href="dashboard.php" class="btn btn-outline">
                    <i class="fas fa-arrow-left"></i> Retour Dashboard
                </a>
            </div>
        </div>
    </header>

    <main class="main-content">
        <div class="admin-dashboard">
            <a href="dashboard.php" class="back-link">
                <i class="fas fa-arrow-left"></i>
                Retour au Dashboard
            </a>
            
            <div class="page-header">
                <h1><i class="fas fa-server"></i> Administration Système</h1>
                <p>Informations serveur et outils de maintenance Flying Book v2.0</p>
            </div>

            <?php if (!empty($message)): ?>
                <div class="alert alert-success">
                    <i class="fas fa-check-circle"></i>
                    <?= htmlspecialchars($message) ?>
                </div>
            <?php endif; ?>

            <!-- Cartes d'informations -->
            <div class="info-cards">
                <!-- Système -->
                <div class="info-card">
                    <h3><i class="fas fa-desktop"></i> Système</h3>
                    <ul class="info-list">
                        <li>
                            <span>OS</span>
                            <span><?= php_uname('s') . ' ' . php_uname('r') ?></span>
                        </li>
                        <li>
                            <span>Architecture</span>
                            <span><?= php_uname('m') ?></span>
                        </li>
                        <li>
                            <span>Serveur Web</span>
                            <span><?= $_SERVER['SERVER_SOFTWARE'] ?? 'N/A' ?></span>
                        </li>
                        <li>
                            <span>IP Serveur</span>
                            <span><?= $_SERVER['SERVER_ADDR'] ?? $_SERVER['HTTP_HOST'] ?? 'N/A' ?></span>
                        </li>
                    </ul>
                </div>

                <!-- PHP -->
                <div class="info-card">
                    <h3><i class="fab fa-php"></i> PHP</h3>
                    <ul class="info-list">
                        <li>
                            <span>Version PHP</span>
                            <span class="<?= version_compare(PHP_VERSION, '8.0.0', '>=') ? 'status-good' : 'status-warning' ?>">
                                <?= PHP_VERSION ?>
                            </span>
                        </li>
                        <li>
                            <span>Limite mémoire</span>
                            <span><?= ini_get('memory_limit') ?></span>
                        </li>
                        <li>
                            <span>Upload max</span>
                            <span><?= ini_get('upload_max_filesize') ?></span>
                        </li>
                        <li>
                            <span>POST max</span>
                            <span><?= ini_get('post_max_size') ?></span>
                        </li>
                        <li>
                            <span>Temps d'exécution</span>
                            <span><?= ini_get('max_execution_time') ?>s</span>
                        </li>
                    </ul>
                </div>

                <!-- Ressources -->
                <div class="info-card">
                    <h3><i class="fas fa-chart-pie"></i> Ressources</h3>
                    <ul class="info-list">
                        <li>
                            <span>Mémoire utilisée</span>
                            <span><?= round(memory_get_usage(true)/1024/1024, 2) ?> MB</span>
                        </li>
                        <li>
                            <span>Pic mémoire</span>
                            <span><?= round(memory_get_peak_usage(true)/1024/1024, 2) ?> MB</span>
                        </li>
                        <li>
                            <span>Espace libre</span>
                            <span class="<?= disk_free_space("/") > 1024*1024*1024 ? 'status-good' : 'status-warning' ?>">
                                <?= round(disk_free_space("/") / 1024 / 1024 / 1024, 2) ?> GB
                            </span>
                        </li>
                        <li>
                            <span>Load average</span>
                            <span><?= function_exists('sys_getloadavg') ? implode(', ', array_map(fn($x) => round($x, 2), sys_getloadavg())) : 'N/A' ?></span>
                        </li>
                    </ul>
                </div>

                <!-- Extensions -->
                <div class="info-card">
                    <h3><i class="fas fa-puzzle-piece"></i> Extensions Critiques</h3>
                    <ul class="info-list">
                        <li>
                            <span>MySQLi</span>
                            <span class="<?= extension_loaded('mysqli') ? 'status-good' : 'status-error' ?>">
                                <i class="fas fa-<?= extension_loaded('mysqli') ? 'check' : 'times' ?>"></i>
                            </span>
                        </li>
                        <li>
                            <span>PDO</span>
                            <span class="<?= extension_loaded('pdo') ? 'status-good' : 'status-error' ?>">
                                <i class="fas fa-<?= extension_loaded('pdo') ? 'check' : 'times' ?>"></i>
                            </span>
                        </li>
                        <li>
                            <span>GD</span>
                            <span class="<?= extension_loaded('gd') ? 'status-good' : 'status-warning' ?>">
                                <i class="fas fa-<?= extension_loaded('gd') ? 'check' : 'times' ?>"></i>
                            </span>
                        </li>
                        <li>
                            <span>cURL</span>
                            <span class="<?= extension_loaded('curl') ? 'status-good' : 'status-warning' ?>">
                                <i class="fas fa-<?= extension_loaded('curl') ? 'check' : 'times' ?>"></i>
                            </span>
                        </li>
                        <li>
                            <span>JSON</span>
                            <span class="<?= extension_loaded('json') ? 'status-good' : 'status-error' ?>">
                                <i class="fas fa-<?= extension_loaded('json') ? 'check' : 'times' ?>"></i>
                            </span>
                        </li>
                    </ul>
                </div>
            </div>

            <!-- Actions de maintenance -->
            <div class="info-card">
                <h3><i class="fas fa-tools"></i> Actions de Maintenance</h3>
                <div class="actions-grid">
                    <a href="?action=clear_cache" class="action-card">
                        <i class="fas fa-broom"></i>
                        <div>
                            <div style="font-weight: 600;">Vider OPCache</div>
                            <div style="font-size: 0.9rem; opacity: 0.9;">Libérer la mémoire cache</div>
                        </div>
                    </a>
                    
                    <a href="?action=clean_logs" class="action-card">
                        <i class="fas fa-trash-alt"></i>
                        <div>
                            <div style="font-weight: 600;">Nettoyer Logs</div>
                            <div style="font-size: 0.9rem; opacity: 0.9;">Supprimer logs > 7 jours</div>
                        </div>
                    </a>
                    
                    <a href="?action=show_phpinfo" target="_blank" class="action-card">
                        <i class="fab fa-php"></i>
                        <div>
                            <div style="font-weight: 600;">PHPInfo Complet</div>
                            <div style="font-size: 0.9rem; opacity: 0.9;">Ouvrir dans nouvel onglet</div>
                        </div>
                    </a>
                    
                    <a href="javascript:void(0)" onclick="showDiskUsage()" class="action-card">
                        <i class="fas fa-hdd"></i>
                        <div>
                            <div style="font-weight: 600;">Analyse Disque</div>
                            <div style="font-size: 0.9rem; opacity: 0.9;">Utilisation des dossiers</div>
                        </div>
                    </a>
                </div>
            </div>

            <!-- Zone d'analyse disque -->
            <div id="diskAnalysis" class="info-card" style="display: none;">
                <h3><i class="fas fa-chart-bar"></i> Analyse d'utilisation disque</h3>
                <div id="diskResults">Analyse en cours...</div>
            </div>
        </div>
    </main>

    <script>
        function showDiskUsage() {
            const diskDiv = document.getElementById('diskAnalysis');
            const resultsDiv = document.getElementById('diskResults');
            
            diskDiv.style.display = 'block';
            resultsDiv.innerHTML = 'Analyse en cours...';
            
            // Simulation d'analyse
            setTimeout(() => {
                resultsDiv.innerHTML = `
                    <ul class="info-list">
                        <li><span>/flying-book/</span><span>~ ${Math.round(Math.random() * 100 + 50)} MB</span></li>
                        <li><span>/flying-book/uploads/</span><span>~ ${Math.round(Math.random() * 500 + 100)} MB</span></li>
                        <li><span>/flying-book/logs/</span><span>~ ${Math.round(Math.random() * 10 + 1)} MB</span></li>
                        <li><span>/flying-book/assets/</span><span>~ ${Math.round(Math.random() * 50 + 10)} MB</span></li>
                    </ul>
                    <div style="margin-top: 1rem; padding: 1rem; background: var(--gray-50); border-radius: 8px;">
                        <strong>💡 Conseil :</strong> Si les uploads dépassent 1GB, pensez à nettoyer les anciens fichiers.
                    </div>
                `;
            }, 1500);
        }
        
        // Auto-refresh des infos toutes les 30 secondes
        setInterval(() => {
            if (!document.hidden) {
                location.reload();
            }
        }, 30000);
    </script>
</body>
</html>