<?php
session_start();

// Supprimer le cookie "Remember Me" s'il existe
if (isset($_COOKIE['flying_book_remember'])) {
    setcookie('flying_book_remember', '', [
        'expires' => time() - 3600,
        'path' => '/',
        'httponly' => true,
        'secure' => isset($_SERVER['HTTPS']),
        'samesite' => 'Strict'
    ]);
    
    // Optionnel: Supprimer le token de la base de données
    try {
        require_once './env/.env.php';
        $pdo = getDatabaseConnection();
        
        $stmt = $pdo->prepare("
            UPDATE users 
            SET remember_token = NULL, remember_expires = NULL 
            WHERE remember_token = ?
        ");
        $stmt->execute([$_COOKIE['flying_book_remember']]);
    } catch (Exception $e) {
        // Erreur silencieuse, pas critique pour la déconnexion
        error_log("Logout error: " . $e->getMessage());
    }
}

// Détruire la session
session_destroy();

// Rediriger vers la page de connexion
header('Location: login.php');
exit;
?>