<?php
/**
 * Flying Book Creator - Configuration Environment
 * Fichier de configuration principal
 */

// Configuration Base de Données
define('DB_HOST', 'localhost');
define('DB_NAME', 'laloedata');
define('DB_USER', 'laloedata');
define('DB_PASS', 'PiL256Mx78!');
define('DB_PORT', 3306);
define('DB_CHARSET', 'utf8mb4');

// Configuration SMTP/Email
define('SMTP_HOST', 'ssl0.ovh.net');
define('SMTP_USERNAME', 'livraison@audiovizu.fr');
define('SMTP_PASSWORD', 'HJiPj487ghg!');
define('SMTP_PORT', 587);
define('SMTP_ENCRYPTION', 'tls');
define('SMTP_USE_TLS', true);

// Configuration expéditeur email
define('MAIL_FROM_ADDRESS', 'livraison@audiovizu.fr');
define('MAIL_FROM_NAME', 'Flying Book Creator');
define('MAIL_DEBUG', false);
define('MAIL_RECIPIENT', 'lefebvre.pierre@audiovizu.fr');

// Clés de sécurité
define('APP_KEY', '2c8a6f1f50f9e3a1f22f5db8f94bf4672866d0be39372a236207a16ce6dc2f01');
define('ENCRYPTION_KEY', 'c5949191935e4102aed41d2f42aec90ece7b7f68557fba9c01e857dcf555f2ff');
define('SECRET_KEY', 'aae78b73cfc6d74644e2b90ebfbee15053b7378da37166063acce76aa333dded');

// URLs
define('APP_URL', 'https://laloee-cours.fr/flying-book');
define('BASE_URL', 'https://laloee-cours.fr/flying-book');

// Développement
define('DEBUG_MODE', false);
define('LOG_LEVEL', 'error');
define('APP_ENV', 'production');

// Sécurité
define('MAX_LOGIN_ATTEMPTS', 5);
define('SESSION_TIMEOUT', 7200);
define('TOKEN_EXPIRY', 3600);
define('RATE_LIMIT_ATTEMPTS', 3);
define('RATE_LIMIT_WINDOW', 900);

// Configuration Flying Book avec chemins corrigés
define('FLYING_BOOK_MAX_FILE_SIZE', 500 * 1024 * 1024); // 500MB
define('FLYING_BOOK_ALLOWED_TYPES', 'jpg,jpeg,png,gif,webp,mp4,webm,mov,mp3,wav,ogg,pdf,ppt,pptx');
define('FLYING_BOOK_PROJECTS_PATH', $_SERVER['DOCUMENT_ROOT'] . '/flying-book/document/projects/');
define('FLYING_BOOK_TEMP_PATH', $_SERVER['DOCUMENT_ROOT'] . '/flying-book/document/temp/');
define('FLYING_BOOK_TEMPLATES_PATH', $_SERVER['DOCUMENT_ROOT'] . '/flying-book/document/templates/');

// Limites par plan
define('FLYING_BOOK_LIMITS', [
    'free' => [
        'max_projects' => 3,
        'max_slides_per_project' => 10,
        'max_storage' => 100 * 1024 * 1024, // 100MB
        'analytics' => false,
        'custom_domain' => false,
        'watermark' => true,
        'export_formats' => ['html']
    ],
    'pro' => [
        'max_projects' => 50,
        'max_slides_per_project' => 100,
        'max_storage' => 5 * 1024 * 1024 * 1024, // 5GB
        'analytics' => true,
        'custom_domain' => true,
        'watermark' => false,
        'export_formats' => ['html', 'pdf', 'zip']
    ],
    'business' => [
        'max_projects' => 200,
        'max_slides_per_project' => 500,
        'max_storage' => 20 * 1024 * 1024 * 1024, // 20GB
        'analytics' => true,
        'custom_domain' => true,
        'watermark' => false,
        'export_formats' => ['html', 'pdf', 'zip', 'ppt']
    ],
    'enterprise' => [
        'max_projects' => -1, // Illimité
        'max_slides_per_project' => -1, // Illimité
        'max_storage' => -1, // Illimité
        'analytics' => true,
        'custom_domain' => true,
        'watermark' => false,
        'export_formats' => ['html', 'pdf', 'zip', 'ppt', 'video']
    ]
]);

// Configuration des thèmes
define('FLYING_BOOK_THEMES', [
    'moderne' => [
        'name' => 'Moderne',
        'description' => 'Design épuré avec des dégradés et animations fluides',
        'primary_color' => '#667eea',
        'secondary_color' => '#764ba2',
        'css_file' => 'moderne.css'
    ],
    'classique' => [
        'name' => 'Classique',
        'description' => 'Style traditionnel, professionnel et intemporel',
        'primary_color' => '#2c3e50',
        'secondary_color' => '#3498db',
        'css_file' => 'classique.css'
    ],
    'corporate' => [
        'name' => 'Corporate',
        'description' => 'Design professionnel pour présentations d\'entreprise',
        'primary_color' => '#34495e',
        'secondary_color' => '#2c3e50',
        'css_file' => 'corporate.css'
    ],
    'minimal' => [
        'name' => 'Minimal',
        'description' => 'Simplicité et élégance, focus sur le contenu',
        'primary_color' => '#95a5a6',
        'secondary_color' => '#bdc3c7',
        'css_file' => 'minimal.css'
    ],
    'premium' => [
        'name' => 'Premium',
        'description' => 'Design haut de gamme avec effets avancés',
        'primary_color' => '#ff6b6b',
        'secondary_color' => '#feca57',
        'css_file' => 'premium.css'
    ]
]);

// Configuration des transitions
define('FLYING_BOOK_TRANSITIONS', [
    'fade' => [
        'name' => 'Fondu',
        'description' => 'Transition douce et élégante',
        'css_class' => 'transition-fade'
    ],
    'slide' => [
        'name' => 'Glissement',
        'description' => 'Défilement horizontal classique',
        'css_class' => 'transition-slide'
    ],
    'flip' => [
        'name' => 'Retournement',
        'description' => 'Effet de carte qui se retourne',
        'css_class' => 'transition-flip'
    ],
    '3d' => [
        'name' => '3D',
        'description' => 'Rotation 3D moderne',
        'css_class' => 'transition-3d'
    ],
    'premium_3d' => [
        'name' => '3D Premium',
        'description' => 'Effets 3D avancés avec particules',
        'css_class' => 'transition-premium-3d'
    ]
]);

// ========== FONCTIONS UTILITAIRES CENTRALISÉES ==========

/**
 * Connexion à la base de données
 */
function getDatabaseConnection() {
    try {
        $pdo = new PDO(
            "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=" . DB_CHARSET,
            DB_USER,
            DB_PASS,
            [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                PDO::ATTR_EMULATE_PREPARES => false
            ]
        );
        return $pdo;
    } catch (PDOException $e) {
        if (DEBUG_MODE) {
            throw new Exception("Database connection failed: " . $e->getMessage());
        } else {
            throw new Exception("Database connection failed");
        }
    }
}

/**
 * Obtenir les limites du plan utilisateur
 */
function getUserPlanLimits($userId) {
    try {
        $pdo = getDatabaseConnection();
        $stmt = $pdo->prepare("
            SELECT s.plan_type 
            FROM flying_book_subscriptions s 
            WHERE s.user_id = ? AND s.status = 'active' 
            ORDER BY s.created_at DESC 
            LIMIT 1
        ");
        $stmt->execute([$userId]);
        $subscription = $stmt->fetch();
        
        $planType = $subscription ? $subscription['plan_type'] : 'free';
        return FLYING_BOOK_LIMITS[$planType] ?? FLYING_BOOK_LIMITS['free'];
    } catch (Exception $e) {
        return FLYING_BOOK_LIMITS['free'];
    }
}

/**
 * Vérifier les limites utilisateur
 */
function checkUserLimits($userId, $limitType, $value = 1) {
    $limits = getUserPlanLimits($userId);
    
    if ($limits[$limitType] === -1) {
        return true; // Illimité
    }
    
    try {
        $pdo = getDatabaseConnection();
        
        switch ($limitType) {
            case 'max_projects':
                $stmt = $pdo->prepare("
                    SELECT COUNT(*) as count 
                    FROM flying_book_projects 
                    WHERE user_id = ? AND status != 'deleted'
                ");
                $stmt->execute([$userId]);
                $current = $stmt->fetch()['count'];
                return ($current + $value) <= $limits[$limitType];
                
            case 'max_storage':
                $stmt = $pdo->prepare("
                    SELECT SUM(file_size_total) as total 
                    FROM flying_book_projects 
                    WHERE user_id = ? AND status != 'deleted'
                ");
                $stmt->execute([$userId]);
                $current = $stmt->fetch()['total'] ?? 0;
                return ($current + $value) <= $limits[$limitType];
                
            default:
                return true;
        }
    } catch (Exception $e) {
        return false;
    }
}

/**
 * Formater la taille de fichier
 */
function formatFileSize($bytes) {
    if ($bytes >= 1073741824) {
        return number_format($bytes / 1073741824, 2) . ' GB';
    } elseif ($bytes >= 1048576) {
        return number_format($bytes / 1048576, 2) . ' MB';
    } elseif ($bytes >= 1024) {
        return number_format($bytes / 1024, 2) . ' KB';
    } else {
        return $bytes . ' B';
    }
}

/**
 * Générer un token sécurisé
 */
function generateSecureToken($length = 32) {
    return bin2hex(random_bytes($length));
}

/**
 * Nettoyer un nom de fichier
 */
function sanitizeFileName($filename) {
    // Supprimer les caractères dangereux
    $filename = preg_replace('/[^a-zA-Z0-9._-]/', '_', $filename);
    
    // Limiter la longueur
    if (strlen($filename) > 200) {
        $extension = pathinfo($filename, PATHINFO_EXTENSION);
        $basename = substr(pathinfo($filename, PATHINFO_FILENAME), 0, 200 - strlen($extension) - 1);
        $filename = $basename . '.' . $extension;
    }
    
    return $filename;
}

/**
 * Logger les erreurs
 */
function logError($message, $context = []) {
    if (LOG_LEVEL === 'error' || DEBUG_MODE) {
        $logEntry = [
            'timestamp' => date('Y-m-d H:i:s'),
            'message' => $message,
            'context' => $context
        ];
        
        $logFile = $_SERVER['DOCUMENT_ROOT'] . '/flying-book/logs/flying_book_' . date('Y-m-d') . '.log';
        $logDir = dirname($logFile);
        
        if (!is_dir($logDir)) {
            @mkdir($logDir, 0755, true);
        }
        
        @file_put_contents($logFile, json_encode($logEntry) . "\n", FILE_APPEND | LOCK_EX);
    }
}

// Créer les répertoires nécessaires s'ils n'existent pas (avec gestion d'erreurs)
function createDirectories() {
    $requiredDirs = [
        FLYING_BOOK_PROJECTS_PATH,
        FLYING_BOOK_TEMP_PATH,
        FLYING_BOOK_TEMPLATES_PATH,
        $_SERVER['DOCUMENT_ROOT'] . '/flying-book/logs/'
    ];

    foreach ($requiredDirs as $dir) {
        if (!is_dir($dir)) {
            if (!@mkdir($dir, 0755, true)) {
                error_log("Impossible de créer le répertoire: " . $dir);
            }
        }
    }
}

// Créer les répertoires seulement si on n'est pas en session
if (session_status() === PHP_SESSION_NONE) {
    createDirectories();
    
    // Configuration de session sécurisée (seulement si aucune session n'est active)
    ini_set('session.cookie_httponly', 1);
    ini_set('session.use_strict_mode', 1);
    
    // Configuration sécurisée conditionnelle
    if (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on') {
        ini_set('session.cookie_secure', 1);
    }
    
    ini_set('session.cookie_samesite', 'Strict');
} else {
    // Si une session est déjà active, on crée quand même les répertoires
    createDirectories();
}

// Configuration des uploads
ini_set('upload_max_filesize', '500M');
ini_set('post_max_size', '500M');
ini_set('max_execution_time', 300);
ini_set('memory_limit', '512M');

?>