<?php
/*
 * SMG Studio v2.0 - Workflow Manager ULTRA-SIMPLE
 * Pas de JSON, pas d'API complexe, juste du PHP direct !
 * Path: /var/www/laloee-cours.fr/social-media-generator/workflow_manager_simple.php
 */

// Configuration simple
$BASE_PATH = __DIR__;
$WORKFLOW_PATH = $BASE_PATH . '/SMG_STUDIO_WORKFLOW';
$CLIPMAKER_URL = 'https://laloee-cours.fr/social-media-generator/modules/clipmaker_workflow_interface.html';

// Récupérer user
$user_id = $_GET['user'] ?? 'user_001';
if (!preg_match('/^user_\d{3}$/', $user_id)) {
    die('User ID invalide');
}

$user_path = $WORKFLOW_PATH . '/' . $user_id;
$active_clip_path = $user_path . '/active_clip';
$archives_path = $user_path . '/archived_clips';

// Actions
$action = $_POST['action'] ?? '';
$message = '';
$error = '';

// Créer structure si nécessaire
if (!is_dir($user_path)) {
    mkdir($user_path, 0755, true);
    mkdir($active_clip_path, 0755, true);
    mkdir($active_clip_path . '/01_clipmaker', 0755, true);
    mkdir($active_clip_path . '/02_audio_postprod', 0755, true);
    mkdir($active_clip_path . '/03_social_ready', 0755, true);
    mkdir($active_clip_path . '/04_archive_ready', 0755, true);
    mkdir($archives_path, 0755, true);
}

// ACTIONS
switch ($action) {
    case 'start_new_clip':
        $clip_name = trim($_POST['clip_name'] ?? '');
        if (empty($clip_name)) {
            $error = 'Nom de clip requis';
            break;
        }
        
        // DESTRUCTIF : Nettoyer clip actuel
        if (hasActiveClip($active_clip_path)) {
            cleanActiveClip($active_clip_path);
        }
        
        // Créer nouveau clip
        file_put_contents($active_clip_path . '/current_project.txt', $clip_name);
        file_put_contents($active_clip_path . '/created_at.txt', date('Y-m-d H:i:s'));
        
        // Redirection vers Clipmaker
        $redirect_url = $CLIPMAKER_URL . '?user=' . urlencode($user_id) . '&project=' . urlencode($clip_name);
        header('Location: ' . $redirect_url);
        exit;
        
    case 'delete_clip':
        if (hasActiveClip($active_clip_path)) {
            $clip_name = getCurrentClipName($active_clip_path);
            cleanActiveClip($active_clip_path);
            $message = "Clip \"$clip_name\" supprimé définitivement !";
        }
        break;
        
    case 'validate_stage':
        $stage = intval($_POST['stage'] ?? 0);
        if ($stage >= 1 && $stage <= 4) {
            // Marquer étape comme validée
            file_put_contents($active_clip_path . '/0' . $stage . '_validated.txt', date('Y-m-d H:i:s'));
            $message = "Étape $stage validée !";
        }
        break;
        
    case 'rollback_stage':
        $to_stage = intval($_POST['to_stage'] ?? 0);
        if ($to_stage >= 1 && $to_stage <= 3) {
            // DESTRUCTIF : Supprimer étapes suivantes
            for ($i = $to_stage + 1; $i <= 4; $i++) {
                $stage_path = $active_clip_path . '/0' . $i . '_*';
                foreach (glob($stage_path) as $file) {
                    if (is_dir($file)) {
                        deleteDirectory($file);
                        mkdir($file, 0755, true);
                    } else {
                        unlink($file);
                    }
                }
            }
            $message = "Retour à l'étape $to_stage - Étapes suivantes détruites !";
        }
        break;
        
    case 'archive_clip':
        if (hasActiveClip($active_clip_path)) {
            $clip_name = getCurrentClipName($active_clip_path);
            $archive_name = date('Y-m-d_H-i-s') . '_' . sanitizeFilename($clip_name);
            $archive_full_path = $archives_path . '/' . $archive_name;
            
            // Copier vers archive
            copyDirectory($active_clip_path, $archive_full_path);
            
            // Nettoyer clip actuel
            cleanActiveClip($active_clip_path);
            
            // Redirection vers Posts Manager
            header('Location: posts.php?user=' . urlencode($user_id) . '&archived=' . urlencode($archive_name));
            exit;
        }
        break;
}

// FONCTIONS UTILITAIRES
function hasActiveClip($path) {
    return file_exists($path . '/current_project.txt');
}

function getCurrentClipName($path) {
    return file_exists($path . '/current_project.txt') ? 
           trim(file_get_contents($path . '/current_project.txt')) : 
           'Clip Sans Nom';
}

function getClipCreatedAt($path) {
    return file_exists($path . '/created_at.txt') ? 
           trim(file_get_contents($path . '/created_at.txt')) : 
           'Inconnu';
}

function getStageInfo($path, $stage) {
    $stage_path = $path . '/0' . $stage . '_*';
    $files = [];
    
    // Scanner fichiers dans le dossier de l'étape
    $dir_path = $path . '/0' . $stage . '_*';
    foreach (glob($dir_path) as $item) {
        if (is_dir($item)) {
            $files = array_merge($files, glob($item . '/*.*'));
        }
    }
    
    // Scanner fichiers directs
    foreach (glob($stage_path) as $file) {
        if (is_file($file)) {
            $files[] = $file;
        }
    }
    
    $total_size = 0;
    foreach ($files as $file) {
        if (is_file($file)) {
            $total_size += filesize($file);
        }
    }
    
    return [
        'has_files' => count($files) > 0,
        'files_count' => count($files),
        'total_size' => $total_size,
        'is_validated' => file_exists($path . '/0' . $stage . '_validated.txt')
    ];
}

function cleanActiveClip($path) {
    if (!is_dir($path)) return;
    
    // Supprimer tous les fichiers
    $files = glob($path . '/*.*');
    foreach ($files as $file) {
        if (is_file($file)) {
            unlink($file);
        }
    }
    
    // Vider les dossiers étapes
    for ($i = 1; $i <= 3; $i++) {
        $stage_dir = $path . '/0' . $i . '_*';
        foreach (glob($stage_dir) as $dir) {
            if (is_dir($dir)) {
                deleteDirectory($dir);
                mkdir($dir, 0755, true);
            }
        }
    }
}

function deleteDirectory($dir) {
    if (!is_dir($dir)) return;
    
    $files = array_diff(scandir($dir), ['.', '..']);
    foreach ($files as $file) {
        $file_path = $dir . '/' . $file;
        if (is_dir($file_path)) {
            deleteDirectory($file_path);
        } else {
            unlink($file_path);
        }
    }
    rmdir($dir);
}

function copyDirectory($src, $dst) {
    if (!is_dir($src)) return;
    if (!is_dir($dst)) mkdir($dst, 0755, true);
    
    $files = array_diff(scandir($src), ['.', '..']);
    foreach ($files as $file) {
        $src_file = $src . '/' . $file;
        $dst_file = $dst . '/' . $file;
        
        if (is_dir($src_file)) {
            copyDirectory($src_file, $dst_file);
        } else {
            copy($src_file, $dst_file);
        }
    }
}

function sanitizeFilename($filename) {
    return preg_replace('/[^a-zA-Z0-9_-]/', '_', $filename);
}

function formatBytes($size) {
    $units = ['B', 'KB', 'MB', 'GB'];
    for ($i = 0; $size > 1024 && $i < 3; $i++) {
        $size /= 1024;
    }
    return round($size, 1) . ' ' . $units[$i];
}

// RÉCUPÉRER ÉTAT ACTUEL
$has_active_clip = hasActiveClip($active_clip_path);
$clip_name = $has_active_clip ? getCurrentClipName($active_clip_path) : '';
$clip_created = $has_active_clip ? getClipCreatedAt($active_clip_path) : '';

$stages = [];
for ($i = 1; $i <= 4; $i++) {
    $stages[$i] = getStageInfo($active_clip_path, $i);
}

// Déterminer étape actuelle
$current_stage = 1;
for ($i = 4; $i >= 1; $i--) {
    if ($stages[$i]['has_files']) {
        $current_stage = $i;
        break;
    }
}

// Archives
$archives = [];
if (is_dir($archives_path)) {
    $archive_dirs = glob($archives_path . '/*', GLOB_ONLYDIR);
    foreach ($archive_dirs as $dir) {
        $archive_name = basename($dir);
        $archives[] = [
            'name' => $archive_name,
            'path' => $dir,
            'size' => getDirSize($dir),
            'created' => date('Y-m-d H:i:s', filemtime($dir))
        ];
    }
    
    // Trier par date (plus récent d'abord)
    usort($archives, function($a, $b) {
        return strcmp($b['created'], $a['created']);
    });
}

function getDirSize($dir) {
    $size = 0;
    $files = new RecursiveIteratorIterator(
        new RecursiveDirectoryIterator($dir, RecursiveDirectoryIterator::SKIP_DOTS)
    );
    
    foreach ($files as $file) {
        if ($file->isFile()) {
            $size += $file->getSize();
        }
    }
    
    return $size;
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>🔥 SMG Studio v2.0 - Workflow SIMPLE</title>
    <link rel="stylesheet" href="css/workflow_destructif.css">
</head>
<body>
    <div class="smg-container">
        <!-- HEADER -->
        <header class="smg-header">
            <div class="smg-header-top">
                <a href="dashboard.php" class="smg-back-btn">← Dashboard</a>
                <div class="smg-user-info">
                    <div class="smg-user-avatar"><?= strtoupper(substr($user_id, -1)) ?></div>
                    <div class="smg-user-details">
                        <div class="smg-user-name"><?= ucfirst(str_replace('_', ' ', $user_id)) ?></div>
                        <div class="smg-user-role">SMG Studio v2.0 SIMPLE</div>
                    </div>
                </div>
            </div>
            <h1 class="smg-header-title">🔥 Workflow Manager SIMPLE</h1>
            <p class="smg-header-subtitle">3 étapes • Workflow destructif • Pas de JSON • Que du concret !</p>
        </header>

        <!-- MESSAGES -->
        <?php if ($message): ?>
            <div class="message message-success">✅ <?= htmlspecialchars($message) ?></div>
        <?php endif; ?>
        
        <?php if ($error): ?>
            <div class="message message-error">❌ <?= htmlspecialchars($error) ?></div>
        <?php endif; ?>

        <!-- NOUVEAU CLIP -->
        <?php if (!$has_active_clip): ?>
            <div class="hero-section">
                <h2 class="hero-title">Prêt à créer votre clip ?</h2>
                <form method="POST" style="display: inline;">
                    <input type="hidden" name="action" value="start_new_clip">
                    <input type="text" name="clip_name" placeholder="Nom du clip" required 
                           style="padding: 15px; font-size: 18px; margin-right: 10px; border: 2px solid #667eea; border-radius: 10px;">
                    <button type="submit" class="hero-cta">
                        <span>🎬</span>
                        <span>COMMENCER</span>
                    </button>
                </form>
                <p class="hero-subtitle">Upload → Montage → Audio → Social → Archive</p>
            </div>
        <?php endif; ?>

        <!-- CLIP ACTUEL -->
        <?php if ($has_active_clip): ?>
            <div class="smg-current-project">
                <div class="smg-project-label">📁 Clip En Cours</div>
                <div class="smg-project-name"><?= htmlspecialchars($clip_name) ?></div>
                <div class="smg-project-meta">
                    <div class="smg-project-meta-item">
                        <span>🎯</span>
                        <span>Étape <?= $current_stage ?>/4</span>
                    </div>
                    <div class="smg-project-meta-item">
                        <span>📅</span>
                        <span><?= $clip_created ?></span>
                    </div>
                    <div class="smg-project-meta-item">
                        <span>💾</span>
                        <span><?= formatBytes(array_sum(array_column($stages, 'total_size'))) ?></span>
                    </div>
                </div>
            </div>

            <!-- AVERTISSEMENT DESTRUCTIF -->
            <div class="destructive-warning">
                ⚠️ <strong>WORKFLOW DESTRUCTIF</strong> : Tout retour en arrière supprime définitivement les étapes suivantes !
            </div>

            <!-- PIPELINE -->
            <div class="smg-panel">
                <h2 class="smg-panel-header">🔥 Pipeline DESTRUCTIF - 4 Étapes</h2>
                
                <div class="pipeline-stages">
                    <!-- ÉTAPE 1 : CLIPMAKER -->
                    <div class="stage-card <?= $stages[1]['has_files'] ? 'completed' : ($current_stage == 1 ? 'active' : '') ?>">
                        <span class="stage-icon">🎬</span>
                        <div class="stage-name">1. Clipmaker</div>
                        <div class="stage-description">Upload rush → Découpe → Export clip</div>
                        
                        <div class="stage-files <?= $stages[1]['has_files'] ? 'has-files' : 'no-files' ?>">
                            <?= $stages[1]['has_files'] ? 
                                "✅ {$stages[1]['files_count']} fichier(s) - " . formatBytes($stages[1]['total_size']) : 
                                "❌ Aucun fichier" ?>
                        </div>
                        
                        <div class="smg-status <?= $stages[1]['has_files'] ? 'smg-status-success' : 'smg-status-info' ?>">
                            <?= $stages[1]['has_files'] ? 'Complète' : 'À faire' ?>
                        </div>
                        
                        <div class="stage-actions">
                            <a href="<?= $CLIPMAKER_URL ?>?user=<?= urlencode($user_id) ?>&project=<?= urlencode($clip_name) ?>" 
                               class="smg-btn smg-btn-primary smg-btn-small">Ouvrir Clipmaker</a>
                        </div>
                    </div>

                    <!-- ÉTAPE 2 : AUDIO -->
                    <div class="stage-card <?= $stages[2]['has_files'] ? 'completed' : (!$stages[1]['has_files'] ? 'blocked' : ($current_stage == 2 ? 'active' : '')) ?>">
                        <span class="stage-icon">🎵</span>
                        <div class="stage-name">2. Audio PostProd</div>
                        <div class="stage-description">Mix → Master → Sync → Export audio</div>
                        
                        <div class="stage-files <?= $stages[2]['has_files'] ? 'has-files' : 'no-files' ?>">
                            <?= $stages[2]['has_files'] ? 
                                "✅ {$stages[2]['files_count']} fichier(s) - " . formatBytes($stages[2]['total_size']) : 
                                (!$stages[1]['has_files'] ? "⏳ Attend le clip" : "❌ Aucun fichier") ?>
                        </div>
                        
                        <div class="smg-status <?= $stages[2]['has_files'] ? 'smg-status-success' : (!$stages[1]['has_files'] ? 'smg-status-warning' : 'smg-status-info') ?>">
                            <?= $stages[2]['has_files'] ? 'Complète' : (!$stages[1]['has_files'] ? 'Bloquée' : 'Disponible') ?>
                        </div>
                        
                        <div class="stage-actions">
                            <?php if ($stages[1]['has_files']): ?>
                                <button class="smg-btn smg-btn-primary smg-btn-small">Ouvrir Audio</button>
                                <?php if ($stages[2]['has_files']): ?>
                                    <form method="POST" style="display: inline;">
                                        <input type="hidden" name="action" value="rollback_stage">
                                        <input type="hidden" name="to_stage" value="1">
                                        <button type="submit" class="smg-btn smg-btn-danger smg-btn-small" 
                                                onclick="return confirm('Supprimer définitivement l\'audio ?')">← Retour</button>
                                    </form>
                                <?php endif; ?>
                            <?php else: ?>
                                <button class="smg-btn smg-btn-ghost smg-btn-small" disabled>Bloquée</button>
                            <?php endif; ?>
                        </div>
                    </div>

                    <!-- ÉTAPE 3 : SOCIAL -->
                    <div class="stage-card <?= $stages[3]['has_files'] ? 'completed' : (!$stages[2]['has_files'] ? 'blocked' : ($current_stage == 3 ? 'active' : '')) ?>">
                        <span class="stage-icon">📱</span>
                        <div class="stage-name">3. Social Ready</div>
                        <div class="stage-description">Formats sociaux → Export multi-plateformes</div>
                        
                        <div class="stage-files <?= $stages[3]['has_files'] ? 'has-files' : 'no-files' ?>">
                            <?= $stages[3]['has_files'] ? 
                                "✅ {$stages[3]['files_count']} fichier(s) - " . formatBytes($stages[3]['total_size']) : 
                                (!$stages[2]['has_files'] ? "⏳ Attend l'audio" : "❌ Aucun fichier") ?>
                        </div>
                        
                        <div class="smg-status <?= $stages[3]['has_files'] ? 'smg-status-success' : (!$stages[2]['has_files'] ? 'smg-status-warning' : 'smg-status-info') ?>">
                            <?= $stages[3]['has_files'] ? 'Complète' : (!$stages[2]['has_files'] ? 'Bloquée' : 'Disponible') ?>
                        </div>
                        
                        <div class="stage-actions">
                            <?php if ($stages[2]['has_files']): ?>
                                <button class="smg-btn smg-btn-primary smg-btn-small">Ouvrir Social</button>
                                <?php if ($stages[3]['has_files']): ?>
                                    <form method="POST" style="display: inline;">
                                        <input type="hidden" name="action" value="rollback_stage">
                                        <input type="hidden" name="to_stage" value="2">
                                        <button type="submit" class="smg-btn smg-btn-danger smg-btn-small" 
                                                onclick="return confirm('Supprimer définitivement les formats sociaux ?')">← Retour</button>
                                    </form>
                                <?php endif; ?>
                            <?php else: ?>
                                <button class="smg-btn smg-btn-ghost smg-btn-small" disabled>Bloquée</button>
                            <?php endif; ?>
                        </div>
                    </div>

                    <!-- ÉTAPE 4 : ARCHIVE -->
                    <div class="stage-card <?= $stages[4]['has_files'] ? 'completed' : (!$stages[3]['has_files'] ? 'blocked' : ($current_stage == 4 ? 'active' : '')) ?>">
                        <span class="stage-icon">📦</span>
                        <div class="stage-name">4. Archive Ready</div>
                        <div class="stage-description">Finalisation → Archive → Posts Manager</div>
                        
                        <div class="stage-files <?= $stages[4]['has_files'] ? 'has-files' : 'no-files' ?>">
                            <?= $stages[4]['has_files'] ? 
                                "✅ Prêt pour archivage" : 
                                (!$stages[3]['has_files'] ? "⏳ Attend le social" : "❌ Finaliser") ?>
                        </div>
                        
                        <div class="smg-status <?= $stages[4]['has_files'] ? 'smg-status-success' : (!$stages[3]['has_files'] ? 'smg-status-warning' : 'smg-status-info') ?>">
                            <?= $stages[4]['has_files'] ? 'Prêt' : (!$stages[3]['has_files'] ? 'Bloquée' : 'Finaliser') ?>
                        </div>
                        
                        <div class="stage-actions">
                            <?php if ($stages[3]['has_files']): ?>
                                <form method="POST" style="display: inline;">
                                    <input type="hidden" name="action" value="archive_clip">
                                    <button type="submit" class="smg-btn smg-btn-success smg-btn-small" 
                                            onclick="return confirm('Archiver et rediriger vers Posts Manager ?')">
                                        📦 Archiver
                                    </button>
                                </form>
                                <?php if ($stages[4]['has_files']): ?>
                                    <form method="POST" style="display: inline;">
                                        <input type="hidden" name="action" value="rollback_stage">
                                        <input type="hidden" name="to_stage" value="3">
                                        <button type="submit" class="smg-btn smg-btn-danger smg-btn-small" 
                                                onclick="return confirm('Annuler finalisation ?')">← Retour</button>
                                    </form>
                                <?php endif; ?>
                            <?php else: ?>
                                <button class="smg-btn smg-btn-ghost smg-btn-small" disabled>Bloquée</button>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                
                <!-- CONTRÔLES WORKFLOW -->
                <div class="pipeline-controls">
                    <!-- BOUTON SUPPRIMER CLIP -->
                    <form method="POST" style="display: inline;">
                        <input type="hidden" name="action" value="delete_clip">
                        <button type="submit" class="smg-btn smg-btn-danger smg-btn-large" 
                                onclick="return confirm('SUPPRIMER DÉFINITIVEMENT le clip actuel ?\n\n⚠️ Cette action est IRRÉVERSIBLE !')">
                            🗑️ Supprimer Clip
                        </button>
                    </form>
                    
                    <!-- NOUVEAU CLIP DESTRUCTIF -->
                    <form method="POST" style="display: inline;">
                        <input type="hidden" name="action" value="start_new_clip">
                        <input type="text" name="clip_name" placeholder="Nouveau clip" required style="margin-right: 10px; padding: 8px; border: 2px solid #667eea; border-radius: 5px;">
                        <button type="submit" class="smg-btn smg-btn-warning smg-btn-large" 
                                onclick="return confirm('Démarrer un nouveau clip ?\n\nLe clip actuel sera DÉTRUIT !')">
                            🔥 Nouveau Clip DESTRUCTIF
                        </button>
                    </form>
                </div>
            </div>
        <?php endif; ?>

        <!-- ARCHIVES -->
        <div class="smg-panel">
            <h3 class="smg-panel-header">
                📦 Clips Archivés
                <button onclick="toggleArchives()" class="smg-btn smg-btn-ghost smg-btn-small" style="margin-left: auto;">
                    🔍 Parcourir Archives
                </button>
            </h3>
            
            <div id="archivesGrid" style="display: <?= !empty($archives) ? 'block' : 'none' ?>;">
                <?php if (!empty($archives)): ?>
                    <div class="actions-grid">
                        <?php foreach (array_slice($archives, 0, 8) as $archive): ?>
                            <div class="action-card">
                                <span class="action-icon">📁</span>
                                <span class="action-title"><?= htmlspecialchars($archive['name']) ?></span>
                                <div style="font-size: 11px; color: #666; margin-top: 5px;">
                                    <?= formatBytes($archive['size']) ?> • <?= $archive['created'] ?>
                                </div>
                                <div style="margin-top: 8px;">
                                    <button onclick="loadFromArchive('<?= htmlspecialchars($archive['name']) ?>')" 
                                            class="smg-btn smg-btn-primary smg-btn-small">
                                        📂 Ouvrir
                                    </button>
                                    <button onclick="deleteArchive('<?= htmlspecialchars($archive['name']) ?>')" 
                                            class="smg-btn smg-btn-danger smg-btn-small">
                                        🗑️
                                    </button>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                    
                    <?php if (count($archives) > 8): ?>
                        <div style="text-align: center; margin-top: 15px;">
                            <button onclick="loadMoreArchives()" class="smg-btn smg-btn-ghost">
                                Voir plus (<?= count($archives) - 8 ?> autres)
                            </button>
                        </div>
                    <?php endif; ?>
                <?php else: ?>
                    <div style="text-align: center; color: #666; padding: 30px;">
                        📁 Aucun clip archivé pour le moment
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- ACTIONS -->
        <div class="smg-panel">
            <h3 class="smg-panel-header">🔧 Outils</h3>
            <div class="actions-grid">
                <a href="posts.php?user=<?= urlencode($user_id) ?>" class="action-card">
                    <span class="action-icon">📝</span>
                    <span class="action-title">Posts Manager</span>
                </a>
                <a href="dashboard.php" class="action-card">
                    <span class="action-icon">🏠</span>
                    <span class="action-title">Dashboard</span>
                </a>
                <a href="?user=<?= urlencode($user_id) ?>" class="action-card">
                    <span class="action-icon">🔄</span>
                    <span class="action-title">Actualiser</span>
                </a>
            </div>
        </div>
    </div>

    <script>
        // Toggle affichage archives
        function toggleArchives() {
            const grid = document.getElementById('archivesGrid');
            if (grid.style.display === 'none') {
                grid.style.display = 'block';
            } else {
                grid.style.display = 'none';
            }
        }

        // Charger depuis archive (simulé)
        function loadFromArchive(archiveName) {
            if (confirm(`Charger le clip depuis l'archive "${archiveName}" ?\n\nCeci remplacera le clip actuel.`)) {
                alert(`Fonctionnalité à développer : Restaurer depuis archive\n\nArchive : ${archiveName}`);
                // TODO: Implémenter la restauration
            }
        }

        // Supprimer archive
        function deleteArchive(archiveName) {
            if (confirm(`Supprimer définitivement l'archive "${archiveName}" ?\n\n⚠️ Cette action est irréversible !`)) {
                // TODO: Implémenter la suppression d'archive
                window.location.href = `?user=<?= urlencode($user_id) ?>&delete_archive=${encodeURIComponent(archiveName)}`;
            }
        }

        // Charger plus d'archives
        function loadMoreArchives() {
            alert('Fonctionnalité à développer : Pagination des archives');
            // TODO: Implémenter pagination
        }

        // Raccourcis clavier
        document.addEventListener('keydown', function(e) {
            // Ctrl+N : Nouveau clip
            if (e.ctrlKey && e.key === 'n') {
                e.preventDefault();
                const clipName = prompt('Nom du nouveau clip:');
                if (clipName) {
                    const form = document.createElement('form');
                    form.method = 'POST';
                    form.innerHTML = `
                        <input type="hidden" name="action" value="start_new_clip">
                        <input type="hidden" name="clip_name" value="${clipName}">
                    `;
                    document.body.appendChild(form);
                    form.submit();
                }
            }
            
            // Ctrl+D : Supprimer clip
            if (e.ctrlKey && e.key === 'd') {
                e.preventDefault();
                if (confirm('Supprimer le clip actuel ?')) {
                    const form = document.createElement('form');
                    form.method = 'POST';
                    form.innerHTML = '<input type="hidden" name="action" value="delete_clip">';
                    document.body.appendChild(form);
                    form.submit();
                }
            }
        });

        console.log('🔥 SMG Workflow Manager SIMPLE Ready!');
    </script>
</body>
</html>