<?php
/**
 * ================================================================
 * 🔍 DEBUG $_SERVER['DOCUMENT_ROOT'] - BY PAPY 77
 * ================================================================
 * Script pour vérifier où pointe DOCUMENT_ROOT sur ton Ubuntu 24
 * ================================================================
 */

echo "<h2>🔍 ANALYSE $_SERVER['DOCUMENT_ROOT'] - Ubuntu 24</h2>\n";

// 1. Valeur actuelle de DOCUMENT_ROOT
echo "<h3>📂 Valeur actuelle:</h3>\n";
echo "<div style='background: #f0f8ff; padding: 15px; border-left: 4px solid #0066cc;'>";
echo "<strong>DOCUMENT_ROOT:</strong> <code>" . $_SERVER['DOCUMENT_ROOT'] . "</code><br>\n";
echo "</div><br>\n";

// 2. Vérification si le dossier existe
$document_root = $_SERVER['DOCUMENT_ROOT'];
echo "<h3>✅ Vérifications:</h3>\n";

if (is_dir($document_root)) {
    echo "✅ Le dossier existe<br>\n";
    
    // Permissions
    $perms = fileperms($document_root);
    echo "🔐 Permissions: " . decoct($perms & 0777) . "<br>\n";
    
    // Contenu du dossier racine
    $files = scandir($document_root);
    $files = array_filter($files, function($file) { return $file !== '.' && $file !== '..'; });
    echo "📊 Contenu dossier racine (" . count($files) . " éléments):<br>\n";
    echo "<ul style='columns: 3;'>";
    foreach (array_slice($files, 0, 20) as $file) {
        $full_path = $document_root . '/' . $file;
        $icon = is_dir($full_path) ? '📁' : '📄';
        echo "<li>$icon $file</li>";
    }
    echo "</ul>";
    
} else {
    echo "❌ Le dossier n'existe pas !<br>\n";
}

// 3. Configuration Apache/Nginx
echo "<h3>⚙️ Configuration Serveur Web:</h3>\n";

// Détection du serveur
$server_software = $_SERVER['SERVER_SOFTWARE'] ?? 'Inconnu';
echo "🖥️ Serveur: <strong>$server_software</strong><br>\n";

// Variables connexes
echo "<h4>📋 Variables $_SERVER liées aux chemins:</h4>\n";
echo "<table border='1' style='border-collapse: collapse; width: 100%;'>";
echo "<tr><th>Variable</th><th>Valeur</th></tr>";

$server_vars = [
    'DOCUMENT_ROOT',
    'SCRIPT_FILENAME',
    'REQUEST_URI',
    'PHP_SELF',
    'SCRIPT_NAME',
    'HTTP_HOST',
    'SERVER_NAME'
];

foreach ($server_vars as $var) {
    $value = $_SERVER[$var] ?? 'Non défini';
    echo "<tr><td><strong>$var</strong></td><td><code>" . htmlspecialchars($value) . "</code></td></tr>";
}
echo "</table><br>";

// 4. Test des chemins possibles
echo "<h3>🧪 Test des chemins possibles:</h3>\n";

$possible_roots = [
    '/var/www/html',
    '/var/www/html/laloee-cours.fr',
    '/var/www/laloee-cours.fr',
    '/home/laloee-cours.fr/public_html',
    '/var/www/html/laloee-cours.fr/public_html'
];

foreach ($possible_roots as $root) {
    $exists = is_dir($root);
    $icon = $exists ? '✅' : '❌';
    echo "$icon <strong>$root</strong>";
    
    if ($exists) {
        $smg_path = $root . '/social-media-generator';
        if (is_dir($smg_path)) {
            echo " → 🎯 <em>social-media-generator trouvé !</em>";
        }
    }
    echo "<br>\n";
}

// 5. Détection automatique du bon chemin
echo "<h3>🎯 Détection automatique:</h3>\n";

// Chercher social-media-generator depuis DOCUMENT_ROOT
function findSMGPath($base_path, $depth = 0) {
    if ($depth > 3) return null; // Limite la profondeur
    
    $smg_path = $base_path . '/social-media-generator';
    if (is_dir($smg_path)) {
        return $base_path;
    }
    
    // Chercher dans les sous-dossiers
    if (is_dir($base_path)) {
        $subdirs = glob($base_path . '/*', GLOB_ONLYDIR);
        foreach ($subdirs as $subdir) {
            $result = findSMGPath($subdir, $depth + 1);
            if ($result) return $result;
        }
    }
    
    return null;
}

$detected_root = findSMGPath($_SERVER['DOCUMENT_ROOT']);

if ($detected_root) {
    echo "🎉 <strong>TROUVÉ !</strong> Racine correcte: <code>$detected_root</code><br>\n";
    echo "📂 Chemin SMG: <code>$detected_root/social-media-generator</code><br>\n";
    
    // Vérifier uploads
    $uploads_path = $detected_root . '/social-media-generator/uploads/clipmaker/media';
    if (is_dir($uploads_path)) {
        echo "✅ Dossier uploads existe: <code>$uploads_path</code><br>\n";
        
        $files = glob($uploads_path . '/*');
        echo "📊 Fichiers médias: " . count($files) . "<br>\n";
    } else {
        echo "❌ Dossier uploads manquant: <code>$uploads_path</code><br>\n";
    }
} else {
    echo "❌ social-media-generator introuvable depuis DOCUMENT_ROOT<br>\n";
}

// 6. Configuration recommandée
echo "<h3>💡 SOLUTION RECOMMANDÉE:</h3>\n";
echo "<div style='background: #f0f8ff; padding: 20px; border-left: 4px solid #0066cc;'>";

if ($detected_root && $detected_root !== $_SERVER['DOCUMENT_ROOT']) {
    echo "<strong>🎯 Problème détecté !</strong><br><br>";
    echo "DOCUMENT_ROOT actuel: <code>" . $_SERVER['DOCUMENT_ROOT'] . "</code><br>";
    echo "Racine correcte détectée: <code>$detected_root</code><br><br>";
    
    echo "<strong>Solution 1 - Modification code:</strong><br>";
    echo "Remplace dans clipmaker-media.php:<br>";
    echo "<code style='background: #ffe6e6;'>// ❌ AVANT<br>";
    echo "\$full_path = \$_SERVER['DOCUMENT_ROOT'] . \$upload_path . \$stored_filename;</code><br><br>";
    
    echo "<code style='background: #e6ffe6;'>// ✅ APRÈS<br>";
    echo "\$full_path = '$detected_root' . \$upload_path . \$stored_filename;</code><br><br>";
    
    echo "<strong>Solution 2 - Configuration Apache:</strong><br>";
    echo "Modifier le VirtualHost pour pointer vers <code>$detected_root</code><br>";
    
} else {
    echo "✅ DOCUMENT_ROOT semble correct !<br><br>";
    echo "Le problème vient probablement des chemins relatifs dans ton code.<br>";
    echo "Utilise les chemins absolus comme dans la correction précédente.";
}

echo "</div>";

// 7. Test création fichier
echo "<h3>🧪 Test création fichier:</h3>\n";

$test_path = $_SERVER['DOCUMENT_ROOT'] . '/test_write_' . time() . '.txt';
if (file_put_contents($test_path, 'Test écriture') !== false) {
    echo "✅ Écriture possible dans DOCUMENT_ROOT<br>\n";
    unlink($test_path); // Supprimer le fichier test
} else {
    echo "❌ Écriture impossible dans DOCUMENT_ROOT<br>\n";
}

// 8. Variables d'environnement système
echo "<h3>🖥️ Variables système Ubuntu:</h3>\n";

if (function_exists('shell_exec')) {
    $apache_root = shell_exec('grep -r "DocumentRoot" /etc/apache2/sites-enabled/ 2>/dev/null | head -5');
    if ($apache_root) {
        echo "<strong>Configuration Apache détectée:</strong><br>";
        echo "<pre style='background: #f5f5f5; padding: 10px;'>" . htmlspecialchars($apache_root) . "</pre>";
    }
    
    $nginx_root = shell_exec('grep -r "root " /etc/nginx/sites-enabled/ 2>/dev/null | head -5');
    if ($nginx_root) {
        echo "<strong>Configuration Nginx détectée:</strong><br>";
        echo "<pre style='background: #f5f5f5; padding: 10px;'>" . htmlspecialchars($nginx_root) . "</pre>";
    }
} else {
    echo "ℹ️ shell_exec() désactivé - impossible de vérifier la config serveur<br>";
}

echo "<hr>";
echo "<p><em>🔍 Diagnostic DOCUMENT_ROOT terminé - Ubuntu 24 Power by Papy 77!</em></p>";
?>