<?php
/**
 * ================================================================
 * 🔧 FIX THUMBNAILS SMG STUDIO - CHEMINS ABSOLUS
 * ================================================================
 * 
 * 🎯 CORRECTIONS THUMBNAILS :
 * ✅ Chemins absolus en dur pour VPS Ubuntu 24
 * ✅ Génération forcée thumbnails
 * ✅ Insertion BDD sécurisée
 * ✅ Gestion erreurs complète
 * 
 * 💡 BY PAPY 77 - FIX DÉFINITIF !
 * ================================================================
 */

// ✅ CHEMINS ABSOLUS EN DUR - PLUS D'ERREURS !
define('UPLOAD_SERVER_PATH', '/var/www/laloee-cours.fr/social-media-generator/uploads/clipmaker/media/');
define('UPLOAD_WEB_PATH', '/social-media-generator/uploads/clipmaker/media/');
define('THUMBNAILS_SERVER_PATH', '/var/www/laloee-cours.fr/social-media-generator/uploads/clipmaker/thumbnails/');
define('THUMBNAILS_WEB_PATH', '/social-media-generator/uploads/clipmaker/thumbnails/');

/**
 * ✅ FONCTION GÉNÉRATION THUMBNAIL FORCÉE
 */
function generateThumbnailForced($source_file_path, $original_filename) {
    $extension = strtolower(pathinfo($original_filename, PATHINFO_EXTENSION));
    $thumb_name = pathinfo($original_filename, PATHINFO_FILENAME) . '_thumb.jpg';
    $thumb_server_path = THUMBNAILS_SERVER_PATH . $thumb_name;
    $thumb_web_path = THUMBNAILS_WEB_PATH . $thumb_name;
    
    // Créer dossier thumbnails si inexistant
    if (!is_dir(THUMBNAILS_SERVER_PATH)) {
        mkdir(THUMBNAILS_SERVER_PATH, 0755, true);
        error_log("✅ Dossier thumbnails créé: " . THUMBNAILS_SERVER_PATH);
    }
    
    try {
        // IMAGES : Redimensionnement forcé
        if (in_array($extension, ['jpg', 'jpeg', 'png', 'webp', 'gif'])) {
            $source_image = null;
            
            switch ($extension) {
                case 'jpg':
                case 'jpeg':
                    $source_image = imagecreatefromjpeg($source_file_path);
                    break;
                case 'png':
                    $source_image = imagecreatefrompng($source_file_path);
                    break;
                case 'webp':
                    $source_image = imagecreatefromwebp($source_file_path);
                    break;
                case 'gif':
                    $source_image = imagecreatefromgif($source_file_path);
                    break;
            }
            
            if ($source_image) {
                $width = imagesx($source_image);
                $height = imagesy($source_image);
                
                // Thumbnail 300x200 forcé
                $thumb_width = 300;
                $thumb_height = 200;
                
                $thumbnail = imagecreatetruecolor($thumb_width, $thumb_height);
                
                // Fond blanc pour transparence
                $white = imagecolorallocate($thumbnail, 255, 255, 255);
                imagefill($thumbnail, 0, 0, $white);
                
                // Redimensionnement avec proportion
                $ratio = min($thumb_width / $width, $thumb_height / $height);
                $new_width = $width * $ratio;
                $new_height = $height * $ratio;
                
                $x = ($thumb_width - $new_width) / 2;
                $y = ($thumb_height - $new_height) / 2;
                
                imagecopyresampled(
                    $thumbnail, $source_image,
                    $x, $y, 0, 0,
                    $new_width, $new_height, $width, $height
                );
                
                // Sauvegarder thumbnail
                $result = imagejpeg($thumbnail, $thumb_server_path, 85);
                
                imagedestroy($source_image);
                imagedestroy($thumbnail);
                
                if ($result) {
                    error_log("✅ Thumbnail image créé: $thumb_name");
                    return $thumb_web_path;
                }
            }
        }
        
        // VIDÉOS : Extraction frame avec FFmpeg
        else if (in_array($extension, ['mp4', 'webm', 'avi', 'mov', 'mkv'])) {
            // Vérifier FFmpeg
            $ffmpeg_path = trim(shell_exec('which ffmpeg'));
            if (empty($ffmpeg_path)) {
                $ffmpeg_path = '/usr/bin/ffmpeg'; // Chemin par défaut Ubuntu
            }
            
            if (file_exists($ffmpeg_path)) {
                $command = sprintf(
                    '%s -i %s -ss 00:00:01 -vframes 1 -f image2 -s 300x200 %s 2>/dev/null',
                    $ffmpeg_path,
                    escapeshellarg($source_file_path),
                    escapeshellarg($thumb_server_path)
                );
                
                exec($command, $output, $return_code);
                
                if ($return_code === 0 && file_exists($thumb_server_path)) {
                    error_log("✅ Thumbnail vidéo créé: $thumb_name");
                    return $thumb_web_path;
                } else {
                    error_log("❌ Erreur FFmpeg: " . implode(' ', $output));
                }
            }
            
            // Fallback : créer thumbnail générique pour vidéo
            return createGenericThumbnail('video', $thumb_name);
        }
        
        // AUDIO : Thumbnail générique
        else if (in_array($extension, ['mp3', 'wav', 'ogg'])) {
            return createGenericThumbnail('audio', $thumb_name);
        }
        
    } catch (Exception $e) {
        error_log("❌ Erreur génération thumbnail: " . $e->getMessage());
    }
    
    return null;
}

/**
 * ✅ THUMBNAIL GÉNÉRIQUE FORCÉ
 */
function createGenericThumbnail($type, $thumb_name) {
    $thumb_server_path = THUMBNAILS_SERVER_PATH . $thumb_name;
    $thumb_web_path = THUMBNAILS_WEB_PATH . $thumb_name;
    
    // Créer image générique 300x200
    $thumbnail = imagecreatetruecolor(300, 200);
    
    // Couleurs selon le type
    switch ($type) {
        case 'video':
            $bg_color = imagecolorallocate($thumbnail, 45, 55, 72); // Bleu foncé
            $text_color = imagecolorallocate($thumbnail, 255, 255, 255);
            $icon = '🎬';
            break;
        case 'audio':
            $bg_color = imagecolorallocate($thumbnail, 139, 69, 19); // Marron
            $text_color = imagecolorallocate($thumbnail, 255, 255, 255);
            $icon = '🎵';
            break;
        default:
            $bg_color = imagecolorallocate($thumbnail, 100, 100, 100); // Gris
            $text_color = imagecolorallocate($thumbnail, 255, 255, 255);
            $icon = '📄';
    }
    
    // Remplir fond
    imagefill($thumbnail, 0, 0, $bg_color);
    
    // Ajouter texte centré
    $text = strtoupper($type);
    $font_size = 5;
    $text_width = imagefontwidth($font_size) * strlen($text);
    $text_height = imagefontheight($font_size);
    $x = (300 - $text_width) / 2;
    $y = (200 - $text_height) / 2;
    
    imagestring($thumbnail, $font_size, $x, $y, $text, $text_color);
    
    // Sauvegarder
    $result = imagejpeg($thumbnail, $thumb_server_path, 85);
    imagedestroy($thumbnail);
    
    if ($result) {
        error_log("✅ Thumbnail générique créé: $thumb_name");
        return $thumb_web_path;
    }
    
    return null;
}

/**
 * ✅ INSERTION MÉDIA AVEC THUMBNAIL FORCÉ
 */
function insertMediaWithThumbnail($pdo, $user_id, $project_id, $original_name, $stored_filename, $file_type, $mime_type, $file_size, $width = null, $height = null, $duration = null) {
    try {
        $pdo->beginTransaction();
        
        // Chemin complet fichier
        $file_path = UPLOAD_WEB_PATH . $stored_filename;
        $server_file_path = UPLOAD_SERVER_PATH . $stored_filename;
        
        // Générer thumbnail FORCÉ
        $thumbnail_path = null;
        if (file_exists($server_file_path)) {
            $thumbnail_path = generateThumbnailForced($server_file_path, $original_name);
        }
        
        // Métadonnées complètes
        $metadata = [
            'file_size' => $file_size,
            'mime_type' => $mime_type,
            'thumbnail_generated' => $thumbnail_path ? true : false,
            'uploaded_at' => date('Y-m-d H:i:s'),
            'server_path' => $server_file_path,
            'web_path' => $file_path
        ];
        
        if ($width && $height) {
            $metadata['dimensions'] = "${width}x${height}";
        }
        
        if ($duration) {
            $metadata['duration_seconds'] = $duration;
        }
        
        // ✅ INSERTION BDD DIRECTE (Plus de vérification tableExists)
        $stmt = $pdo->prepare("
            INSERT INTO clipmaker_media 
            (user_id, project_id, original_filename, stored_filename, file_path, 
             file_type, mime_type, file_size, width, height, duration, 
             thumbnail_path, metadata, conversion_status, created_at, updated_at) 
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 'completed', NOW(), NOW())
        ");
        
        $stmt->execute([
            $user_id,
            $project_id,
            $original_name,
            $stored_filename,
            $file_path,
            $file_type,
            $mime_type,
            $file_size,
            $width,
            $height,
            $duration,
            $thumbnail_path,
            json_encode($metadata)
        ]);
        
        $media_id = $pdo->lastInsertId();
        $pdo->commit();
        
        error_log("✅ Média inséré avec thumbnail - ID: $media_id");
        
        return [
            'success' => true,
            'media_id' => $media_id,
            'thumbnail_path' => $thumbnail_path,
            'file_path' => $file_path
        ];
        
    } catch (PDOException $e) {
        $pdo->rollBack();
        error_log("❌ Erreur insertion média: " . $e->getMessage());
        
        return [
            'success' => false,
            'error' => $e->getMessage()
        ];
    }
}

/**
 * ✅ FONCTION RÉPARATION THUMBNAILS EXISTANTS
 */
function repairMissingThumbnails($pdo, $user_id = null) {
    try {
        $where_clause = $user_id ? "WHERE user_id = ?" : "";
        $params = $user_id ? [$user_id] : [];
        
        $stmt = $pdo->prepare("
            SELECT id, original_filename, stored_filename, file_path, file_type, thumbnail_path
            FROM clipmaker_media 
            $where_clause
            ORDER BY created_at DESC
        ");
        $stmt->execute($params);
        $medias = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        $repaired = 0;
        $errors = 0;
        
        foreach ($medias as $media) {
            // Vérifier si thumbnail manquant ou fichier inexistant
            $needs_repair = false;
            
            if (empty($media['thumbnail_path'])) {
                $needs_repair = true;
            } else {
                $thumb_server_path = str_replace(THUMBNAILS_WEB_PATH, THUMBNAILS_SERVER_PATH, $media['thumbnail_path']);
                if (!file_exists($thumb_server_path)) {
                    $needs_repair = true;
                }
            }
            
            if ($needs_repair) {
                $server_file_path = str_replace(UPLOAD_WEB_PATH, UPLOAD_SERVER_PATH, $media['file_path']);
                
                if (file_exists($server_file_path)) {
                    $new_thumbnail = generateThumbnailForced($server_file_path, $media['original_filename']);
                    
                    if ($new_thumbnail) {
                        // Mettre à jour BDD
                        $update_stmt = $pdo->prepare("
                            UPDATE clipmaker_media 
                            SET thumbnail_path = ?, updated_at = NOW()
                            WHERE id = ?
                        ");
                        $update_stmt->execute([$new_thumbnail, $media['id']]);
                        
                        $repaired++;
                        error_log("✅ Thumbnail réparé pour média ID: {$media['id']}");
                    } else {
                        $errors++;
                        error_log("❌ Échec réparation thumbnail pour média ID: {$media['id']}");
                    }
                } else {
                    $errors++;
                    error_log("❌ Fichier source introuvable pour média ID: {$media['id']}");
                }
            }
        }
        
        return [
            'total_checked' => count($medias),
            'repaired' => $repaired,
            'errors' => $errors
        ];
        
    } catch (Exception $e) {
        error_log("❌ Erreur réparation thumbnails: " . $e->getMessage());
        return ['error' => $e->getMessage()];
    }
}

/**
 * ✅ FONCTION TEST COMPLET THUMBNAILS
 */
function testThumbnailSystem() {
    echo "<h2>🔧 Test Système Thumbnails SMG Studio</h2>\n";
    
    // Test chemins
    echo "<h3>📁 Vérification Chemins</h3>\n";
    echo "Upload Server: " . UPLOAD_SERVER_PATH . (is_dir(UPLOAD_SERVER_PATH) ? " ✅" : " ❌") . "\n";
    echo "Upload Web: " . UPLOAD_WEB_PATH . "\n";
    echo "Thumbnails Server: " . THUMBNAILS_SERVER_PATH . (is_dir(THUMBNAILS_SERVER_PATH) ? " ✅" : " ❌") . "\n";
    echo "Thumbnails Web: " . THUMBNAILS_WEB_PATH . "\n";
    
    // Test GD
    echo "<h3>🎨 Test Extension GD</h3>\n";
    if (extension_loaded('gd')) {
        $gd_info = gd_info();
        echo "GD Version: " . $gd_info['GD Version'] . " ✅\n";
        echo "JPEG Support: " . ($gd_info['JPEG Support'] ? "✅" : "❌") . "\n";
        echo "PNG Support: " . ($gd_info['PNG Support'] ? "✅" : "❌") . "\n";
    } else {
        echo "GD Extension: ❌ NON INSTALLÉE !\n";
    }
    
    // Test FFmpeg
    echo "<h3>🎬 Test FFmpeg</h3>\n";
    $ffmpeg_path = trim(shell_exec('which ffmpeg'));
    if (!empty($ffmpeg_path)) {
        echo "FFmpeg: $ffmpeg_path ✅\n";
        $version = shell_exec('ffmpeg -version 2>&1 | head -n1');
        echo "Version: " . trim($version) . "\n";
    } else {
        echo "FFmpeg: ❌ NON TROUVÉ !\n";
    }
    
    // Test permissions
    echo "<h3>🔐 Test Permissions</h3>\n";
    echo "Upload writable: " . (is_writable(UPLOAD_SERVER_PATH) ? "✅" : "❌") . "\n";
    echo "Thumbnails writable: " . (is_writable(THUMBNAILS_SERVER_PATH) ? "✅" : "❌") . "\n";
    
    echo "<hr>\n";
    echo "<p><strong>✅ Test terminé - Vérifiez les erreurs ci-dessus</strong></p>\n";
}

// ✅ EXEMPLE D'UTILISATION LORS DE L'UPLOAD
/*
// Dans votre script d'upload :
if ($_FILES['media']['error'] === 0) {
    $original_name = $_FILES['media']['name'];
    $stored_filename = 'clipmaker_' . uniqid() . '_' . time() . '.' . pathinfo($original_name, PATHINFO_EXTENSION);
    $upload_path = UPLOAD_SERVER_PATH . $stored_filename;
    
    if (move_uploaded_file($_FILES['media']['tmp_name'], $upload_path)) {
        // Analyser le fichier
        $file_info = analyzeMediaFile($upload_path);
        
        // Insérer avec thumbnail
        $result = insertMediaWithThumbnail(
            $pdo, 
            $user_id, 
            $project_id, 
            $original_name, 
            $stored_filename, 
            $file_info['type'], 
            $_FILES['media']['type'], 
            $_FILES['media']['size'],
            $file_info['width'], 
            $file_info['height'], 
            $file_info['duration']
        );
        
        if ($result['success']) {
            echo json_encode([
                'success' => true,
                'message' => 'Upload terminé avec thumbnail',
                'media_id' => $result['media_id'],
                'thumbnail' => $result['thumbnail_path']
            ]);
        }
    }
}
*/

/**
 * ✅ SCRIPT DE RÉPARATION RAPIDE
 * Ajoutez ceci à la fin de votre fichier pour réparer les thumbnails
 */
if (isset($_GET['repair_thumbnails']) && $_GET['repair_thumbnails'] === 'true') {
    require_once '../auth_functions.php';
    $user = getCurrentUser();
    $pdo = getDbConnection();
    
    echo "<h1>🔧 Réparation Thumbnails SMG Studio</h1>";
    
    $result = repairMissingThumbnails($pdo, $user['id']);
    
    if (isset($result['error'])) {
        echo "<p style='color: red;'>❌ Erreur: " . htmlspecialchars($result['error']) . "</p>";
    } else {
        echo "<p>📊 <strong>Résultats:</strong></p>";
        echo "<ul>";
        echo "<li>Médias vérifiés: " . $result['total_checked'] . "</li>";
        echo "<li>Thumbnails réparés: " . $result['repaired'] . " ✅</li>";
        echo "<li>Erreurs: " . $result['errors'] . " ❌</li>";
        echo "</ul>";
        
        if ($result['repaired'] > 0) {
            echo "<p style='color: green;'>✅ Réparation terminée avec succès !</p>";
        }
    }
    
    echo "<p><a href='?'>← Retour</a></p>";
    exit;
}

// ✅ AFFICHAGE PAGE DE TEST
if (isset($_GET['test_thumbnails']) && $_GET['test_thumbnails'] === 'true') {
    testThumbnailSystem();
    echo "<p><a href='?repair_thumbnails=true'>🔧 Réparer les thumbnails</a></p>";
    echo "<p><a href='?'>← Retour</a></p>";
    exit;
}

echo "🔧 Fix Thumbnails SMG Studio chargé !\n";
echo "📝 Ajoutez ?test_thumbnails=true pour tester\n";
echo "🔧 Ajoutez ?repair_thumbnails=true pour réparer\n";

?>