<?php
/*
 * SMG Studio v2.0 - PHPMailer Configuration CORRIGÉE
 * Path: /var/www/laloee-cours.fr/social-media-generator/includes/phpmailer.php
 */

// Import PHPMailer classes into the global namespace
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

// Load Composer's autoloader (ajuste le chemin selon ton installation)
require_once __DIR__ . '/../vendor/autoload.php';
// OU si tu as installé PHPMailer manuellement :
// require_once __DIR__ . '/PHPMailer/src/Exception.php';
// require_once __DIR__ . '/PHPMailer/src/PHPMailer.php';
// require_once __DIR__ . '/PHPMailer/src/SMTP.php';

/**
 * Fonction d'envoi d'email CORRIGÉE
 * @param string $to Email destinataire
 * @param string $subject Sujet de l'email
 * @param string $body Corps de l'email (HTML)
 * @param string|null $attachmentPath Chemin vers une pièce jointe (optionnel)
 * @return bool|string True si succès, message d'erreur sinon
 */
function sendMail($to, $subject, $body, $attachmentPath = null) {
    global $pdo; // Pour les logs en base
    
    $mail = new PHPMailer(true);
    $status = 'success';
    $error_message = '';

    try {
        // Configuration SMTP
        $mail->isSMTP();
        $mail->Host = 'ssl0.ovh.net';
        $mail->SMTPAuth = true;
        $mail->Username = 'smg@audiovizu.dev';
        $mail->Password = 'HJiPj487ghg!TX';
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
        $mail->Port = 587;
        
        // Configuration de l'expéditeur
        $mail->setFrom('smg@audiovizu.dev', 'SMG Studio - Audiovizu Edition');
        $mail->addReplyTo('smg@audiovizu.dev', 'SMG Studio Support');
        
        // Destinataire
        $mail->addAddress($to);
        
        // Contenu de l'email
        $mail->isHTML(true);
        $mail->CharSet = 'UTF-8';
        $mail->Subject = $subject;
        $mail->Body = $body;
        
        // Version texte alternative (optionnelle mais recommandée)
        $mail->AltBody = strip_tags(str_replace(['<br>', '<br/>', '<br />'], "\n", $body));
        
        // Pièce jointe si fournie
        if ($attachmentPath && file_exists($attachmentPath)) {
            $mail->addAttachment($attachmentPath);
        }
        
        // Options de sécurité et debugging
        $mail->SMTPOptions = array(
            'ssl' => array(
                'verify_peer' => false,
                'verify_peer_name' => false,
                'allow_self_signed' => true
            )
        );
        
        // Debugging (à désactiver en production)
        // $mail->SMTPDebug = SMTP::DEBUG_SERVER;
        
        // Envoi de l'email
        $result = $mail->send();
        
        if ($result) {
            $status = 'success';
            error_log("Email envoyé avec succès à : " . $to);
            return true;
        } else {
            $status = 'error';
            $error_message = "Échec de l'envoi sans exception";
            return $error_message;
        }
        
    } catch (Exception $e) {
        $status = 'error';
        $error_message = $mail->ErrorInfo;
        error_log("Erreur envoi mail à {$to} : " . $error_message);
        return $error_message;
    }
    
    // Log dans la base de données (si la table existe)
    try {
        if (isset($pdo)) {
            $stmt = $pdo->prepare("
                INSERT INTO log_emails (to_email, subject, body, status, error_message, created_at) 
                VALUES (?, ?, ?, ?, ?, NOW())
            ");
            $stmt->execute([$to, $subject, $body, $status, $error_message]);
        }
    } catch (PDOException $e) {
        error_log("Erreur log mail en base : " . $e->getMessage());
        // Ne pas faire échouer l'envoi à cause du log
    }
}

/**
 * Fonction de test de configuration email
 * @return array Résultat du test
 */
function testEmailConfig() {
    $result = [
        'success' => false,
        'message' => '',
        'details' => []
    ];
    
    try {
        $mail = new PHPMailer(true);
        
        // Test de la configuration SMTP
        $mail->isSMTP();
        $mail->Host = 'ssl0.ovh.net';
        $mail->SMTPAuth = true;
        $mail->Username = 'smg@audiovizu.dev';
        $mail->Password = 'HJiPj487ghg!TX';
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
        $mail->Port = 587;
        
        // Test de connexion SMTP
        if ($mail->smtpConnect()) {
            $result['success'] = true;
            $result['message'] = 'Configuration email OK';
            $result['details'][] = 'Connexion SMTP réussie';
            $mail->smtpClose();
        } else {
            $result['message'] = 'Échec de connexion SMTP';
            $result['details'][] = 'Vérifier les paramètres SMTP';
        }
        
    } catch (Exception $e) {
        $result['message'] = 'Erreur de configuration : ' . $e->getMessage();
        $result['details'][] = $e->getMessage();
    }
    
    return $result;
}

/**
 * Fonction d'envoi d'email de test
 * @param string $to Email de test
 * @return bool|string
 */
function sendTestEmail($to) {
    $subject = "🧪 Test Email SMG Studio";
    $body = "
    <html>
    <head><meta charset='UTF-8'></head>
    <body style='font-family: Arial, sans-serif;'>
        <h2>🧪 Email de Test SMG Studio</h2>
        <p>Si vous recevez cet email, la configuration PHPMailer fonctionne correctement !</p>
        <p><strong>Date :</strong> " . date('d/m/Y H:i:s') . "</p>
        <p><strong>Serveur :</strong> " . ($_SERVER['SERVER_NAME'] ?? 'localhost') . "</p>
        <hr>
        <p><small>SMG Studio v2.0 - Audiovizu Edition</small></p>
    </body>
    </html>
    ";
    
    return sendMail($to, $subject, $body);
}

// Auto-test au chargement du fichier (optionnel - à commenter en production)
if (defined('SMG_EMAIL_DEBUG') && SMG_EMAIL_DEBUG === true) {
    $test = testEmailConfig();
    error_log("Test config email : " . json_encode($test));
}
?>