import React, { useState } from 'react';
import { AuthProvider, useAuth } from './context/AuthContext';
import AuthWrapper from './components/Auth/AuthWrapper';
import Dashboard from './components/Dashboard/Dashboard';

const AppContent = () => {
  const { isAuthenticated, loading, user, logout } = useAuth();
  const [currentView, setCurrentView] = useState('dashboard');

  if (loading) {
    return (
      <div style={{
        minHeight: '100vh',
        backgroundColor: '#f9fafb',
        display: 'flex',
        alignItems: 'center',
        justifyContent: 'center'
      }}>
        <div style={{ textAlign: 'center' }}>
          <div style={{ fontSize: '4rem', marginBottom: '1rem' }}>⏳</div>
          <p style={{ fontSize: '1.2rem', color: '#6b7280' }}>Chargement...</p>
        </div>
      </div>
    );
  }

  if (!isAuthenticated) {
    return <AuthWrapper />;
  }

  const menuItems = [
    { id: 'dashboard', label: 'Tableau de bord', icon: '🏠' },
    { id: 'generator', label: 'Générateur', icon: '✨' },
    { id: 'editor', label: 'Éditeur', icon: '✏️' },
    { id: 'analytics', label: 'Analytics', icon: '📊' },
    { id: 'settings', label: 'Paramètres', icon: '⚙️' }
  ];

  const renderCurrentView = () => {
    switch(currentView) {
      case 'dashboard':
        return <Dashboard />;
      case 'generator':
        return <div style={{ padding: '2rem' }}>🚧 Générateur en cours de développement...</div>;
      case 'editor':
        return <div style={{ padding: '2rem' }}>🚧 Éditeur en cours de développement...</div>;
      case 'analytics':
        return <div style={{ padding: '2rem' }}>🚧 Analytics en cours de développement...</div>;
      case 'settings':
        return <div style={{ padding: '2rem' }}>🚧 Paramètres en cours de développement...</div>;
      default:
        return <Dashboard />;
    }
  };

  return (
    <div style={{ minHeight: '100vh', backgroundColor: '#f9fafb', display: 'flex' }}>
      {/* Navigation Sidebar */}
      <nav style={{
        width: '280px',
        backgroundColor: 'white',
        boxShadow: '2px 0 4px rgba(0,0,0,0.1)',
        position: 'fixed',
        height: '100vh',
        left: 0,
        top: 0,
        zIndex: 50
      }}>
        <div style={{ padding: '2rem' }}>
          {/* Logo */}
          <div style={{ display: 'flex', alignItems: 'center', marginBottom: '2rem' }}>
            <div style={{
              width: '40px',
              height: '40px',
              background: 'linear-gradient(135deg, #4f46e5 0%, #7c3aed 100%)',
              borderRadius: '10px',
              display: 'flex',
              alignItems: 'center',
              justifyContent: 'center',
              marginRight: '0.75rem'
            }}>
              <span style={{ color: 'white', fontSize: '1.5rem' }}>🚀</span>
            </div>
            <div>
              <h1 style={{ fontSize: '1.25rem', fontWeight: 'bold', color: '#111827', margin: 0 }}>
                SMG
              </h1>
              <p style={{ fontSize: '0.75rem', color: '#6b7280', margin: 0 }}>
                Social Media Generator
              </p>
            </div>
          </div>

          {/* User Profile */}
          <div style={{
            display: 'flex',
            alignItems: 'center',
            padding: '0.75rem',
            backgroundColor: '#f9fafb',
            borderRadius: '8px',
            marginBottom: '2rem'
          }}>
            <div style={{
              width: '40px',
              height: '40px',
              backgroundColor: '#dbeafe',
              borderRadius: '50%',
              display: 'flex',
              alignItems: 'center',
              justifyContent: 'center',
              marginRight: '0.75rem'
            }}>
              <span style={{ fontSize: '1.2rem' }}>👤</span>
            </div>
            <div style={{ flex: 1, minWidth: 0 }}>
              <p style={{ fontWeight: '500', color: '#111827', margin: 0, fontSize: '0.875rem' }}>
                {user?.first_name || user?.username}
              </p>
              <p style={{ color: '#6b7280', margin: 0, fontSize: '0.75rem', overflow: 'hidden', textOverflow: 'ellipsis' }}>
                {user?.email}
              </p>
            </div>
          </div>

          {/* Menu Items */}
          <ul style={{ listStyle: 'none', padding: 0, margin: 0 }}>
            {menuItems.map((item) => {
              const isActive = currentView === item.id;
              
              return (
                <li key={item.id} style={{ marginBottom: '0.5rem' }}>
                  <button
                    onClick={() => setCurrentView(item.id)}
                    style={{
                      width: '100%',
                      display: 'flex',
                      alignItems: 'center',
                      padding: '0.75rem 1rem',
                      borderRadius: '8px',
                      border: 'none',
                      backgroundColor: isActive ? '#4f46e5' : 'transparent',
                      color: isActive ? 'white' : '#374151',
                      cursor: 'pointer',
                      fontSize: '0.875rem',
                      fontWeight: '500',
                      transition: 'all 0.2s'
                    }}
                    onMouseEnter={(e) => {
                      if (!isActive) {
                        e.target.style.backgroundColor = '#f3f4f6';
                      }
                    }}
                    onMouseLeave={(e) => {
                      if (!isActive) {
                        e.target.style.backgroundColor = 'transparent';
                      }
                    }}
                  >
                    <span style={{ marginRight: '0.75rem', fontSize: '1.2rem' }}>
                      {item.icon}
                    </span>
                    {item.label}
                  </button>
                </li>
              );
            })}
          </ul>
        </div>

        {/* Logout Button */}
        <div style={{ position: 'absolute', bottom: '2rem', left: '2rem', right: '2rem' }}>
          <button
            onClick={logout}
            style={{
              width: '100%',
              display: 'flex',
              alignItems: 'center',
              padding: '0.75rem 1rem',
              backgroundColor: 'transparent',
              color: '#dc2626',
              border: '1px solid #fca5a5',
              borderRadius: '8px',
              cursor: 'pointer',
              fontSize: '0.875rem',
              fontWeight: '500',
              transition: 'all 0.2s'
            }}
            onMouseEnter={(e) => {
              e.target.style.backgroundColor = '#fee2e2';
            }}
            onMouseLeave={(e) => {
              e.target.style.backgroundColor = 'transparent';
            }}
          >
            <span style={{ marginRight: '0.75rem' }}>🚪</span>
            Déconnexion
          </button>
        </div>
      </nav>
      
      {/* Main Content */}
      <main style={{ marginLeft: '280px', flex: 1 }}>
        {renderCurrentView()}
      </main>
    </div>
  );
};

const App = () => {
  return (
    <AuthProvider>
      <AppContent />
    </AuthProvider>
  );
};

export default App;