<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>📤 Mes Exports & Archives - SMG Studio Audiovizu</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            color: #333;
            padding: 20px;
        }

        .container {
            max-width: 1400px;
            margin: 0 auto;
        }

        /* Header */
        .header {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(20px);
            border-radius: 20px;
            padding: 25px 35px;
            margin-bottom: 30px;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            position: relative;
            overflow: hidden;
        }

        .header::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: linear-gradient(45deg, #667eea, #764ba2);
        }

        .back-btn {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            color: #667eea;
            text-decoration: none;
            font-weight: 600;
            padding: 8px 15px;
            border-radius: 8px;
            transition: all 0.3s ease;
            margin-bottom: 15px;
        }

        .back-btn:hover {
            background: rgba(102, 126, 234, 0.1);
            transform: translateX(-5px);
        }

        .header h1 {
            font-size: 28px;
            font-weight: 700;
            background: linear-gradient(45deg, #667eea, #764ba2);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            margin-bottom: 10px;
        }

        .user-info {
            background: linear-gradient(45deg, rgba(102, 126, 234, 0.1), rgba(118, 75, 162, 0.1));
            border: 1px solid rgba(102, 126, 234, 0.2);
            color: #333;
            padding: 15px 20px;
            border-radius: 15px;
            margin-top: 15px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        /* Stats Overview */
        .stats-overview {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }

        .stat-card {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(20px);
            border-radius: 15px;
            padding: 20px;
            text-align: center;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            transition: transform 0.3s ease;
        }

        .stat-card:hover {
            transform: translateY(-5px);
        }

        .stat-icon {
            font-size: 2.5em;
            margin-bottom: 10px;
            display: block;
        }

        .stat-number {
            font-size: 2em;
            font-weight: bold;
            background: linear-gradient(45deg, #667eea, #764ba2);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            margin-bottom: 5px;
        }

        .stat-label {
            color: #666;
            font-weight: 600;
            font-size: 0.9em;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        /* Filters & Search */
        .filters-section {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(20px);
            border-radius: 20px;
            padding: 25px;
            margin-bottom: 30px;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
        }

        .filters-grid {
            display: grid;
            grid-template-columns: 2fr 1fr 1fr 1fr auto;
            gap: 15px;
            align-items: end;
        }

        .filter-group {
            display: flex;
            flex-direction: column;
            gap: 8px;
        }

        .filter-label {
            font-weight: 600;
            color: #333;
            font-size: 0.9em;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .filter-input, .filter-select {
            padding: 12px 15px;
            border: 2px solid rgba(0, 0, 0, 0.1);
            border-radius: 10px;
            font-size: 0.9em;
            transition: all 0.3s ease;
            background: rgba(255, 255, 255, 0.8);
            backdrop-filter: blur(10px);
        }

        .filter-input:focus, .filter-select:focus {
            outline: none;
            border-color: #667eea;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        }

        .search-btn {
            background: linear-gradient(135deg, #667eea, #764ba2);
            color: white;
            border: none;
            border-radius: 10px;
            padding: 12px 20px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            height: fit-content;
        }

        .search-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
        }

        /* Exports Grid */
        .exports-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(350px, 1fr));
            gap: 25px;
            margin-bottom: 30px;
        }

        .export-card {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(20px);
            border-radius: 20px;
            overflow: hidden;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            transition: all 0.3s ease;
            cursor: pointer;
        }

        .export-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 12px 40px rgba(0, 0, 0, 0.15);
        }

        .card-thumbnail {
            width: 100%;
            height: 200px;
            background: linear-gradient(135deg, #f8f9fa, #e9ecef);
            position: relative;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 3em;
            color: #666;
            overflow: hidden;
        }

        .card-thumbnail img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        .card-thumbnail::after {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: linear-gradient(45deg, rgba(102, 126, 234, 0.1), rgba(118, 75, 162, 0.1));
            opacity: 0;
            transition: opacity 0.3s ease;
        }

        .export-card:hover .card-thumbnail::after {
            opacity: 1;
        }

        .card-content {
            padding: 20px;
        }

        .card-title {
            font-size: 1.1em;
            font-weight: 700;
            margin-bottom: 8px;
            color: #333;
        }

        .card-meta {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 10px;
            margin-bottom: 15px;
            font-size: 0.85em;
            color: #666;
        }

        .meta-item {
            display: flex;
            align-items: center;
            gap: 5px;
        }

        .card-tags {
            display: flex;
            flex-wrap: wrap;
            gap: 6px;
            margin-bottom: 15px;
        }

        .tag {
            background: rgba(102, 126, 234, 0.1);
            color: #667eea;
            padding: 4px 8px;
            border-radius: 15px;
            font-size: 0.75em;
            font-weight: 600;
        }

        .card-actions {
            display: flex;
            gap: 8px;
            flex-wrap: wrap;
        }

        .action-btn {
            flex: 1;
            min-width: 100px;
            padding: 8px 12px;
            border: none;
            border-radius: 8px;
            font-size: 0.85em;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            text-align: center;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            gap: 5px;
        }

        .btn-preview {
            background: linear-gradient(135deg, #17a2b8, #138496);
            color: white;
        }

        .btn-reuse {
            background: linear-gradient(135deg, #28a745, #20c997);
            color: white;
        }

        .btn-download {
            background: linear-gradient(135deg, #667eea, #764ba2);
            color: white;
        }

        .btn-delete {
            background: linear-gradient(135deg, #dc3545, #c82333);
            color: white;
        }

        .action-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.2);
        }

        /* Bulk Actions */
        .bulk-actions {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(20px);
            border-radius: 20px;
            padding: 20px 25px;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            display: flex;
            align-items: center;
            justify-content: space-between;
            flex-wrap: wrap;
            gap: 15px;
        }

        .bulk-select {
            display: flex;
            align-items: center;
            gap: 15px;
        }

        .bulk-select input[type="checkbox"] {
            width: 20px;
            height: 20px;
            cursor: pointer;
        }

        .bulk-actions-buttons {
            display: flex;
            gap: 10px;
            flex-wrap: wrap;
        }

        /* Empty State */
        .empty-state {
            text-align: center;
            padding: 60px 20px;
            color: #666;
        }

        .empty-state-icon {
            font-size: 4em;
            margin-bottom: 20px;
            opacity: 0.5;
        }

        .empty-state h3 {
            font-size: 1.5em;
            margin-bottom: 10px;
        }

        .empty-state p {
            font-size: 1.1em;
            margin-bottom: 30px;
        }

        /* Modal Preview */
        .modal {
            display: none;
            position: fixed;
            z-index: 1000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.9);
            backdrop-filter: blur(5px);
        }

        .modal-content {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(20px);
            margin: 2% auto;
            padding: 30px;
            border-radius: 20px;
            width: 90%;
            max-width: 800px;
            max-height: 90vh;
            overflow-y: auto;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
            animation: modalSlideIn 0.3s ease;
        }

        @keyframes modalSlideIn {
            from {
                opacity: 0;
                transform: translateY(-50px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .close {
            color: #999;
            float: right;
            font-size: 28px;
            font-weight: bold;
            cursor: pointer;
            line-height: 1;
        }

        .close:hover {
            color: #333;
        }

        /* Responsive */
        @media (max-width: 768px) {
            .filters-grid {
                grid-template-columns: 1fr;
            }
            
            .exports-grid {
                grid-template-columns: 1fr;
            }
            
            .bulk-actions {
                flex-direction: column;
                align-items: stretch;
            }
            
            .bulk-actions-buttons {
                justify-content: center;
            }
        }

        /* Animations */
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .export-card {
            animation: fadeInUp 0.6s ease forwards;
            opacity: 0;
        }

        .export-card:nth-child(1) { animation-delay: 0.1s; }
        .export-card:nth-child(2) { animation-delay: 0.2s; }
        .export-card:nth-child(3) { animation-delay: 0.3s; }
        .export-card:nth-child(4) { animation-delay: 0.4s; }
        .export-card:nth-child(5) { animation-delay: 0.5s; }
        .export-card:nth-child(6) { animation-delay: 0.6s; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <a href="dashboard.php" class="back-btn">← Dashboard</a>
            <h1>📤 Mes Exports & Archives</h1>
            <p>Bibliothèque personnelle de tous vos contenus finalisés - Prêts pour réutilisation</p>
            
            <div class="user-info">
                <div>
                    <strong>👤 Admin Audiovizu</strong> - Vos archives personnelles
                </div>
                <div style="color: #666; font-size: 0.9em;">
                    Dernière synchronisation: <strong>20/07/2025 15:30</strong>
                </div>
            </div>
        </div>

        <!-- Stats Overview -->
        <div class="stats-overview">
            <div class="stat-card">
                <span class="stat-icon">🎬</span>
                <div class="stat-number" id="totalVideos">24</div>
                <div class="stat-label">Vidéos archivées</div>
            </div>
            <div class="stat-card">
                <span class="stat-icon">💾</span>
                <div class="stat-number" id="totalSize">1.2Go</div>
                <div class="stat-label">Espace utilisé</div>
            </div>
            <div class="stat-card">
                <span class="stat-icon">📅</span>
                <div class="stat-number" id="thisMonth">8</div>
                <div class="stat-label">Ce mois-ci</div>
            </div>
            <div class="stat-card">
                <span class="stat-icon">🔄</span>
                <div class="stat-number" id="reused">12</div>
                <div class="stat-label">Réutilisés</div>
            </div>
        </div>

        <!-- Filters & Search -->
        <div class="filters-section">
            <div class="filters-grid">
                <div class="filter-group">
                    <label class="filter-label">🔍 Rechercher</label>
                    <input type="text" class="filter-input" placeholder="Nom, projet, description..." id="searchInput">
                </div>
                <div class="filter-group">
                    <label class="filter-label">📂 Projet</label>
                    <select class="filter-select" id="projectFilter">
                        <option value="">Tous les projets</option>
                        <option value="interview">Interview Mars</option>
                        <option value="podcast">Podcast Tech</option>
                        <option value="pub">Pub Audiovizu</option>
                        <option value="formation">Formation</option>
                    </select>
                </div>
                <div class="filter-group">
                    <label class="filter-label">📅 Période</label>
                    <select class="filter-select" id="dateFilter">
                        <option value="">Toutes les dates</option>
                        <option value="today">Aujourd'hui</option>
                        <option value="week">Cette semaine</option>
                        <option value="month">Ce mois</option>
                        <option value="year">Cette année</option>
                    </select>
                </div>
                <div class="filter-group">
                    <label class="filter-label">🏷️ Type</label>
                    <select class="filter-select" id="typeFilter">
                        <option value="">Tous les types</option>
                        <option value="video">Vidéo</option>
                        <option value="audio">Audio</option>
                        <option value="image">Image</option>
                        <option value="document">Document</option>
                    </select>
                </div>
                <button class="search-btn" onclick="applyFilters()">
                    🔍 Filtrer
                </button>
            </div>
        </div>

        <!-- Exports Grid -->
        <div class="exports-grid" id="exportsGrid">
            <!-- Exemple d'exports -->
            <div class="export-card" onclick="previewExport('interview-mars-final')">
                <div class="card-thumbnail">
                    🎬
                    <!-- <img src="thumbnail1.jpg" alt="Preview"> -->
                </div>
                <div class="card-content">
                    <h3 class="card-title">Interview Mars 2025 - Final</h3>
                    <div class="card-meta">
                        <div class="meta-item">📅 15/03/2025</div>
                        <div class="meta-item">⏱️ 45:30</div>
                        <div class="meta-item">💾 245MB</div>
                        <div class="meta-item">📐 1920x1080</div>
                    </div>
                    <div class="card-tags">
                        <span class="tag">Interview</span>
                        <span class="tag">IA</span>
                        <span class="tag">Tech</span>
                        <span class="tag">Final</span>
                    </div>
                    <div class="card-actions">
                        <button class="action-btn btn-preview" onclick="event.stopPropagation(); previewExport('interview-mars-final')">
                            👁️ Voir
                        </button>
                        <button class="action-btn btn-reuse" onclick="event.stopPropagation(); reuseInPosts('interview-mars-final')">
                            🔄 Réutiliser
                        </button>
                        <button class="action-btn btn-download" onclick="event.stopPropagation(); downloadExport('interview-mars-final')">
                            ⬇️ Télécharger
                        </button>
                    </div>
                </div>
            </div>

            <div class="export-card" onclick="previewExport('podcast-tech-ep12')">
                <div class="card-thumbnail">
                    🎵
                </div>
                <div class="card-content">
                    <h3 class="card-title">Podcast Tech Weekly #12</h3>
                    <div class="card-meta">
                        <div class="meta-item">📅 12/03/2025</div>
                        <div class="meta-item">⏱️ 32:15</div>
                        <div class="meta-item">💾 89MB</div>
                        <div class="meta-item">🎵 MP3 320k</div>
                    </div>
                    <div class="card-tags">
                        <span class="tag">Podcast</span>
                        <span class="tag">Tech</span>
                        <span class="tag">Audio</span>
                    </div>
                    <div class="card-actions">
                        <button class="action-btn btn-preview" onclick="event.stopPropagation(); previewExport('podcast-tech-ep12')">
                            👁️ Voir
                        </button>
                        <button class="action-btn btn-reuse" onclick="event.stopPropagation(); reuseInPosts('podcast-tech-ep12')">
                            🔄 Réutiliser
                        </button>
                        <button class="action-btn btn-download" onclick="event.stopPropagation(); downloadExport('podcast-tech-ep12')">
                            ⬇️ Télécharger
                        </button>
                    </div>
                </div>
            </div>

            <div class="export-card" onclick="previewExport('pub-audiovizu-30s')">
                <div class="card-thumbnail">
                    📺
                </div>
                <div class="card-content">
                    <h3 class="card-title">Pub Audiovizu - 30 secondes</h3>
                    <div class="card-meta">
                        <div class="meta-item">📅 10/03/2025</div>
                        <div class="meta-item">⏱️ 0:30</div>
                        <div class="meta-item">💾 45MB</div>
                        <div class="meta-item">📐 1920x1080</div>
                    </div>
                    <div class="card-tags">
                        <span class="tag">Publicité</span>
                        <span class="tag">Branding</span>
                        <span class="tag">Court</span>
                        <span class="tag">Social</span>
                    </div>
                    <div class="card-actions">
                        <button class="action-btn btn-preview" onclick="event.stopPropagation(); previewExport('pub-audiovizu-30s')">
                            👁️ Voir
                        </button>
                        <button class="action-btn btn-reuse" onclick="event.stopPropagation(); reuseInPosts('pub-audiovizu-30s')">
                            🔄 Réutiliser
                        </button>
                        <button class="action-btn btn-download" onclick="event.stopPropagation(); downloadExport('pub-audiovizu-30s')">
                            ⬇️ Télécharger
                        </button>
                    </div>
                </div>
            </div>

            <div class="export-card" onclick="previewExport('formation-video-intro')">
                <div class="card-thumbnail">
                    📚
                </div>
                <div class="card-content">
                    <h3 class="card-title">Formation Vidéo - Introduction</h3>
                    <div class="card-meta">
                        <div class="meta-item">📅 08/03/2025</div>
                        <div class="meta-item">⏱️ 12:45</div>
                        <div class="meta-item">💾 156MB</div>
                        <div class="meta-item">📐 1280x720</div>
                    </div>
                    <div class="card-tags">
                        <span class="tag">Formation</span>
                        <span class="tag">Intro</span>
                        <span class="tag">Éducatif</span>
                    </div>
                    <div class="card-actions">
                        <button class="action-btn btn-preview" onclick="event.stopPropagation(); previewExport('formation-video-intro')">
                            👁️ Voir
                        </button>
                        <button class="action-btn btn-reuse" onclick="event.stopPropagation(); reuseInPosts('formation-video-intro')">
                            🔄 Réutiliser
                        </button>
                        <button class="action-btn btn-download" onclick="event.stopPropagation(); downloadExport('formation-video-intro')">
                            ⬇️ Télécharger
                        </button>
                    </div>
                </div>
            </div>

            <div class="export-card" onclick="previewExport('webinaire-avril-teaser')">
                <div class="card-thumbnail">
                    🌟
                </div>
                <div class="card-content">
                    <h3 class="card-title">Webinaire Avril - Teaser</h3>
                    <div class="card-meta">
                        <div class="meta-item">📅 05/03/2025</div>
                        <div class="meta-item">⏱️ 1:30</div>
                        <div class="meta-item">💾 28MB</div>
                        <div class="meta-item">📐 1080x1080</div>
                    </div>
                    <div class="card-tags">
                        <span class="tag">Teaser</span>
                        <span class="tag">Webinaire</span>
                        <span class="tag">Carré</span>
                        <span class="tag">Social</span>
                    </div>
                    <div class="card-actions">
                        <button class="action-btn btn-preview" onclick="event.stopPropagation(); previewExport('webinaire-avril-teaser')">
                            👁️ Voir
                        </button>
                        <button class="action-btn btn-reuse" onclick="event.stopPropagation(); reuseInPosts('webinaire-avril-teaser')">
                            🔄 Réutiliser
                        </button>
                        <button class="action-btn btn-download" onclick="event.stopPropagation(); downloadExport('webinaire-avril-teaser')">
                            ⬇️ Télécharger
                        </button>
                    </div>
                </div>
            </div>

            <div class="export-card" onclick="previewExport('logo-animation')">
                <div class="card-thumbnail">
                    🎨
                </div>
                <div class="card-content">
                    <h3 class="card-title">Logo Audiovizu - Animation</h3>
                    <div class="card-meta">
                        <div class="meta-item">📅 01/03/2025</div>
                        <div class="meta-item">⏱️ 0:05</div>
                        <div class="meta-item">💾 12MB</div>
                        <div class="meta-item">📐 1920x1080</div>
                    </div>
                    <div class="card-tags">
                        <span class="tag">Logo</span>
                        <span class="tag">Animation</span>
                        <span class="tag">Branding</span>
                        <span class="tag">Intro</span>
                    </div>
                    <div class="card-actions">
                        <button class="action-btn btn-preview" onclick="event.stopPropagation(); previewExport('logo-animation')">
                            👁️ Voir
                        </button>
                        <button class="action-btn btn-reuse" onclick="event.stopPropagation(); reuseInPosts('logo-animation')">
                            🔄 Réutiliser
                        </button>
                        <button class="action-btn btn-download" onclick="event.stopPropagation(); downloadExport('logo-animation')">
                            ⬇️ Télécharger
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Bulk Actions -->
        <div class="bulk-actions">
            <div class="bulk-select">
                <input type="checkbox" id="selectAll" onchange="toggleSelectAll()">
                <label for="selectAll" style="font-weight: 600;">Sélectionner tout</label>
                <span id="selectedCount" style="color: #666;">0 élément(s) sélectionné(s)</span>
            </div>
            <div class="bulk-actions-buttons">
                <button class="action-btn btn-reuse" onclick="bulkReuseInPosts()">
                    🔄 Réutiliser sélection
                </button>
                <button class="action-btn btn-download" onclick="bulkDownload()">
                    ⬇️ Télécharger ZIP
                </button>
                <a href="https://laloee-cours.fr/social-media-generator/posts.php" class="action-btn btn-preview">
                    📝 Aller aux Posts
                </a>
                <button class="action-btn btn-delete" onclick="bulkDelete()">
                    🗑️ Supprimer sélection
                </button>
            </div>
        </div>
    </div>

    <!-- Modal Preview -->
    <div id="previewModal" class="modal">
        <div class="modal-content">
            <span class="close" onclick="closeModal()">&times;</span>
            <div id="modalContent">
                <!-- Contenu dynamique -->
            </div>
        </div>
    </div>

    <script>
        // Variables globales
        let selectedItems = new Set();
        
        // Initialisation
        document.addEventListener('DOMContentLoaded', function() {
            console.log('📤 Exports Manager - Audiovizu Edition');
            updateStats();
            setupFilters();
        });

        // Mise à jour des statistiques
        function updateStats() {
            // Simulation de données en temps réel
            const stats = {
                totalVideos: 24,
                totalSize: '1.2Go',
                thisMonth: 8,
                reused: 12
            };
            
            Object.keys(stats).forEach(key => {
                const element = document.getElementById(key);
                if (element) {
                    element.textContent = stats[key];
                }
            });
        }

        // Configuration des filtres
        function setupFilters() {
            const searchInput = document.getElementById('searchInput');
            searchInput.addEventListener('input', debounce(applyFilters, 300));
        }

        // Fonction debounce pour la recherche
        function debounce(func, wait) {
            let timeout;
            return function executedFunction(...args) {
                const later = () => {
                    clearTimeout(timeout);
                    func(...args);
                };
                clearTimeout(timeout);
                timeout = setTimeout(later, wait);
            };
        }

        // Appliquer les filtres
        function applyFilters() {
            const searchTerm = document.getElementById('searchInput').value.toLowerCase();
            const projectFilter = document.getElementById('projectFilter').value;
            const dateFilter = document.getElementById('dateFilter').value;
            const typeFilter = document.getElementById('typeFilter').value;
            
            const cards = document.querySelectorAll('.export-card');
            let visibleCount = 0;
            
            cards.forEach(card => {
                const title = card.querySelector('.card-title').textContent.toLowerCase();
                const tags = Array.from(card.querySelectorAll('.tag')).map(tag => tag.textContent.toLowerCase());
                
                let shouldShow = true;
                
                // Filtre de recherche
                if (searchTerm && !title.includes(searchTerm) && !tags.some(tag => tag.includes(searchTerm))) {
                    shouldShow = false;
                }
                
                // Autres filtres (simulation)
                // En production, vous filtrer selon vos critères réels
                
                if (shouldShow) {
                    card.style.display = 'block';
                    visibleCount++;
                } else {
                    card.style.display = 'none';
                }
            });
            
            console.log(`🔍 Filtres appliqués: ${visibleCount} résultat(s)`);
        }

        // Preview d'un export
        function previewExport(exportId) {
            const exportData = {
                'interview-mars-final': {
                    title: 'Interview Mars 2025 - Final',
                    type: 'Vidéo',
                    duration: '45:30',
                    size: '245MB',
                    resolution: '1920x1080',
                    format: 'MP4',
                    description: 'Interview exclusive avec un expert en IA sur les tendances 2025',
                    tags: ['Interview', 'IA', 'Tech', 'Final'],
                    created: '15/03/2025 14:30',
                    project: 'Interview Mars 2025',
                    reusedCount: 3
                },
                'podcast-tech-ep12': {
                    title: 'Podcast Tech Weekly #12',
                    type: 'Audio',
                    duration: '32:15',
                    size: '89MB',
                    resolution: 'N/A',
                    format: 'MP3 320kbps',
                    description: 'Épisode hebdomadaire sur les nouvelles technologies et startups',
                    tags: ['Podcast', 'Tech', 'Audio'],
                    created: '12/03/2025 16:45',
                    project: 'Podcast Tech Weekly',
                    reusedCount: 1
                }
            };

            const data = exportData[exportId] || exportData['interview-mars-final'];
            
            showModal(`
                <h2>👁️ Aperçu: ${data.title}</h2>
                
                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px; margin: 25px 0; font-size: 0.95em;">
                    <div><strong>Type:</strong> ${data.type}</div>
                    <div><strong>Durée:</strong> ${data.duration}</div>
                    <div><strong>Taille:</strong> ${data.size}</div>
                    <div><strong>Format:</strong> ${data.format}</div>
                    <div><strong>Résolution:</strong> ${data.resolution}</div>
                    <div><strong>Créé le:</strong> ${data.created}</div>
                    <div><strong>Projet:</strong> ${data.project}</div>
                    <div><strong>Réutilisé:</strong> ${data.reusedCount} fois</div>
                </div>
                
                <div style="margin: 20px 0;">
                    <h4>📝 Description:</h4>
                    <p style="padding: 15px; background: #f8f9fa; border-radius: 10px; margin: 10px 0; line-height: 1.5;">
                        ${data.description}
                    </p>
                </div>
                
                <div style="margin: 20px 0;">
                    <h4>🏷️ Tags:</h4>
                    <div style="display: flex; flex-wrap: wrap; gap: 8px; margin: 10px 0;">
                        ${data.tags.map(tag => `<span style="background: rgba(102, 126, 234, 0.1); color: #667eea; padding: 6px 12px; border-radius: 20px; font-size: 0.8em; font-weight: 600;">${tag}</span>`).join('')}
                    </div>
                </div>
                
                <div style="background: #e7f3ff; border: 1px solid #b3d9ff; border-radius: 10px; padding: 15px; margin: 20px 0;">
                    <h4 style="color: #0066cc; margin-bottom: 10px;">💡 Actions suggérées:</h4>
                    <ul style="margin: 0; padding-left: 20px; color: #0066cc;">
                        <li>Réutiliser pour créer des extraits courts</li>
                        <li>Adapter pour les réseaux sociaux</li>
                        <li>Intégrer dans de nouveaux projets</li>
                        <li>Créer des variations de format</li>
                    </ul>
                </div>
                
                <div style="text-align: center; margin-top: 30px; display: flex; gap: 15px; justify-content: center; flex-wrap: wrap;">
                    <button onclick="reuseInPosts('${exportId}')" style="background: linear-gradient(135deg, #28a745, #20c997); color: white; border: none; padding: 12px 25px; border-radius: 10px; font-weight: 600; cursor: pointer; display: flex; align-items: center; gap: 8px;">
                        🔄 Réutiliser dans Posts
                    </button>
                    <button onclick="downloadExport('${exportId}')" style="background: linear-gradient(135deg, #667eea, #764ba2); color: white; border: none; padding: 12px 25px; border-radius: 10px; font-weight: 600; cursor: pointer; display: flex; align-items: center; gap: 8px;">
                        ⬇️ Télécharger
                    </button>
                    <button onclick="shareExport('${exportId}')" style="background: linear-gradient(135deg, #17a2b8, #138496); color: white; border: none; padding: 12px 25px; border-radius: 10px; font-weight: 600; cursor: pointer; display: flex; align-items: center; gap: 8px;">
                        📤 Partager
                    </button>
                </div>
            `);
        }

        // Réutiliser dans Posts
        function reuseInPosts(exportId) {
            if (confirm('🔄 Réutiliser ce contenu dans Posts Manager?\n\nCela va ouvrir Posts Manager avec ce contenu pré-sélectionné.')) {
                // En production, vous passeriez l'ID en paramètre
                window.open('https://laloee-cours.fr/social-media-generator/posts.php?reuse=' + exportId, '_blank');
                closeModal();
            }
        }

        // Télécharger un export
        function downloadExport(exportId) {
            alert(`⬇️ Téléchargement de: ${exportId}\n\nLe téléchargement va commencer...\n(En production, cela lancerait le téléchargement réel)`);
            // En production: window.location.href = 'download.php?id=' + exportId;
        }

        // Partager un export
        function shareExport(exportId) {
            alert(`📤 Partage de: ${exportId}\n\nOptions de partage:\n- Lien de téléchargement temporaire\n- Envoi par email\n- Partage sur réseaux\n\n(Interface de partage en développement)`);
        }

        // Sélection multiple
        function toggleSelectAll() {
            const selectAll = document.getElementById('selectAll');
            const cards = document.querySelectorAll('.export-card');
            
            if (selectAll.checked) {
                cards.forEach((card, index) => {
                    selectedItems.add(index);
                    card.style.border = '2px solid #667eea';
                });
            } else {
                selectedItems.clear();
                cards.forEach(card => {
                    card.style.border = '1px solid rgba(255, 255, 255, 0.2)';
                });
            }
            
            updateSelectedCount();
        }

        // Mettre à jour le compteur de sélection
        function updateSelectedCount() {
            document.getElementById('selectedCount').textContent = `${selectedItems.size} élément(s) sélectionné(s)`;
        }

        // Actions en masse
        function bulkReuseInPosts() {
            if (selectedItems.size === 0) {
                alert('❌ Aucun élément sélectionné');
                return;
            }
            
            if (confirm(`🔄 Réutiliser ${selectedItems.size} éléments dans Posts Manager?`)) {
                window.open('https://laloee-cours.fr/social-media-generator/posts.php?bulk_reuse=true', '_blank');
            }
        }

        function bulkDownload() {
            if (selectedItems.size === 0) {
                alert('❌ Aucun élément sélectionné');
                return;
            }
            
            alert(`⬇️ Téléchargement ZIP de ${selectedItems.size} éléments\n\nPréparation de l'archive...\n(En production, cela créerait un ZIP)`);
        }

        function bulkDelete() {
            if (selectedItems.size === 0) {
                alert('❌ Aucun élément sélectionné');
                return;
            }
            
            if (confirm(`🗑️ Supprimer définitivement ${selectedItems.size} éléments?\n\nCette action est irréversible!`)) {
                alert('🗑️ Suppression en cours...\n\n(En production, cela supprimerait les éléments)');
                selectedItems.clear();
                updateSelectedCount();
            }
        }

        // Fonctions modal
        function showModal(content) {
            document.getElementById('modalContent').innerHTML = content;
            document.getElementById('previewModal').style.display = 'block';
        }

        function closeModal() {
            document.getElementById('previewModal').style.display = 'none';
        }

        // Fermer modal en cliquant à l'extérieur
        window.onclick = function(event) {
            const modal = document.getElementById('previewModal');
            if (event.target === modal) {
                closeModal();
            }
        }

        // Actualisation périodique
        setInterval(() => {
            updateStats();
            console.log('🔄 Stats exports actualisées');
        }, 60000);

        console.log('📤 Exports Manager Audiovizu - Prêt pour la réutilisation !');
    </script>
</body>
</html>