<?php
/**
 * ================================================================
 * 🔍 DEBUG SESSION SMG - DIAGNOSTIC CONNEXION
 * ================================================================
 * 
 * 🎯 OBJECTIF :
 * - Diagnostiquer problème session
 * - Vérifier état authentification
 * - Corriger accès posts.php
 * 
 * 💡 BY PAPY 77 - DEBUG MODE ACTIVÉ !
 * ================================================================
 */

session_start();
require_once 'config/db.php';

echo "🚀 SMG Studio v2.0 - Diagnostic Session\n";
echo "=====================================\n\n";

// ================================================================
// 🔍 DIAGNOSTIC COMPLET SESSION
// ================================================================

echo "📋 Étape 1 : État de la session...\n";

// Info session
echo "Session ID: " . session_id() . "\n";
echo "Session Status: " . session_status() . " (1=disabled, 2=active)\n";
echo "Session Name: " . session_name() . "\n";
echo "Session Path: " . session_save_path() . "\n";

// Contenu session
echo "\n📊 Contenu de \$_SESSION :\n";
if (empty($_SESSION)) {
    echo "❌ Session VIDE - Aucune donnée\n";
} else {
    foreach ($_SESSION as $key => $value) {
        echo "✅ {$key} = " . (is_array($value) ? json_encode($value) : $value) . "\n";
    }
}

// Variables GET/POST
echo "\n📥 Variables reçues :\n";
echo "GET: " . (!empty($_GET) ? json_encode($_GET) : "Aucune") . "\n";
echo "POST: " . (!empty($_POST) ? json_encode($_POST) : "Aucune") . "\n";

// ================================================================
// 🗄️ VÉRIFICATION BASE DE DONNÉES
// ================================================================

echo "\n📋 Étape 2 : Vérification base de données...\n";

try {
    // Test connexion BDD
    $stmt = $pdo->query("SELECT COUNT(*) as count FROM users WHERE status = 'active'");
    $user_count = $stmt->fetch()['count'];
    echo "✅ Connexion BDD OK - {$user_count} utilisateurs actifs\n";
    
    // Lister utilisateurs actifs
    $stmt = $pdo->query("SELECT id, name, email, role FROM users WHERE status = 'active' ORDER BY id");
    $users = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "\n👥 Utilisateurs disponibles :\n";
    foreach ($users as $user) {
        echo "   🧑 ID: {$user['id']} | {$user['name']} ({$user['email']}) | Role: {$user['role']}\n";
    }
    
} catch (Exception $e) {
    echo "❌ Erreur BDD : " . $e->getMessage() . "\n";
}

// ================================================================
// 🔧 TENTATIVE DE CONNEXION AUTO (DÉVELOPPEMENT)
// ================================================================

echo "\n📋 Étape 3 : Solutions de récupération...\n";

if (!isset($_SESSION['user_id'])) {
    echo "⚠️  Pas d'utilisateur connecté\n";
    
    // Option 1: Auto-login développement
    if (isset($_GET['auto_login'])) {
        try {
            $stmt = $pdo->query("SELECT id, name, email, role FROM users WHERE status = 'active' ORDER BY id LIMIT 1");
            $user = $stmt->fetch(PDO::FETCH_ASSOC);
            
            if ($user) {
                $_SESSION['user_id'] = $user['id'];
                $_SESSION['user_name'] = $user['name'];
                $_SESSION['user_role'] = $user['role'];
                $_SESSION['login_time'] = time();
                
                echo "✅ AUTO-LOGIN réussi pour : {$user['name']} (ID: {$user['id']})\n";
                echo "🔄 Redirection vers posts.php...\n";
                
                // Redirection après 2 secondes
                echo '<meta http-equiv="refresh" content="2;url=posts.php">';
            } else {
                echo "❌ Aucun utilisateur actif trouvé\n";
            }
        } catch (Exception $e) {
            echo "❌ Erreur auto-login : " . $e->getMessage() . "\n";
        }
    } else {
        echo "💡 Solutions disponibles :\n";
        echo "   1. Connexion manuelle → <a href='login.php'>login.php</a>\n";
        echo "   2. Auto-login développement → <a href='?auto_login=1'>Cliquez ici</a>\n";
        echo "   3. Vérifier session_start() dans posts.php\n";
    }
} else {
    echo "✅ Utilisateur connecté : ID {$_SESSION['user_id']}\n";
    echo "🚀 Accès posts.php autorisé\n";
}

// ================================================================
// 🔍 DIAGNOSTIC AVANCÉ SYSTÈME
// ================================================================

echo "\n📋 Étape 4 : Diagnostic système...\n";

// Permissions fichiers
$session_path = session_save_path();
if (!empty($session_path)) {
    $writable = is_writable($session_path);
    echo "📁 Dossier sessions : {$session_path} - " . ($writable ? "✅ Écritable" : "❌ Non écritable") . "\n";
}

// Configuration session
echo "⚙️  Configuration session :\n";
echo "   - session.use_cookies: " . ini_get('session.use_cookies') . "\n";
echo "   - session.use_strict_mode: " . ini_get('session.use_strict_mode') . "\n";
echo "   - session.cookie_lifetime: " . ini_get('session.cookie_lifetime') . "\n";
echo "   - session.gc_maxlifetime: " . ini_get('session.gc_maxlifetime') . "\n";

// Cookies
echo "\n🍪 Cookies reçus :\n";
if (!empty($_COOKIE)) {
    foreach ($_COOKIE as $name => $value) {
        echo "   {$name} = " . substr($value, 0, 50) . (strlen($value) > 50 ? '...' : '') . "\n";
    }
} else {
    echo "   Aucun cookie\n";
}

// ================================================================
// 🎯 RECOMMANDATIONS
// ================================================================

echo "\n📋 Étape 5 : Recommandations...\n";

if (!isset($_SESSION['user_id'])) {
    echo "🔧 Actions recommandées :\n";
    echo "   1. ✅ Utiliser auto-login développement\n";
    echo "   2. 🔍 Vérifier login.php fonctionne\n";
    echo "   3. 🗄️  Créer utilisateur test si BDD vide\n";
    echo "   4. ⚙️  Vérifier config session PHP\n";
} else {
    echo "🎉 Tout est OK ! Redirection possible vers posts.php\n";
}

// ================================================================
// 🚀 SCRIPT AUTO-CRÉATION USER (si besoin)
// ================================================================

if (isset($_GET['create_test_user'])) {
    echo "\n📋 Création utilisateur test...\n";
    
    try {
        $pdo->beginTransaction();
        
        // Vérifier si utilisateur test existe
        $stmt = $pdo->prepare("SELECT id FROM users WHERE email = 'test@smg.local'");
        $stmt->execute();
        
        if (!$stmt->fetch()) {
            // Créer utilisateur test
            $stmt = $pdo->prepare("
                INSERT INTO users (name, email, password, role, status, created_at) 
                VALUES ('Utilisateur Test', 'test@smg.local', ?, 'admin', 'active', NOW())
            ");
            $password_hash = password_hash('test123', PASSWORD_DEFAULT);
            $stmt->execute([$password_hash]);
            
            $user_id = $pdo->lastInsertId();
            echo "✅ Utilisateur test créé (ID: {$user_id})\n";
            echo "   📧 Email: test@smg.local\n";
            echo "   🔑 Mot de passe: test123\n";
        } else {
            echo "ℹ️  Utilisateur test existe déjà\n";
        }
        
        $pdo->commit();
        echo "🔄 Vous pouvez maintenant vous connecter\n";
        
    } catch (Exception $e) {
        $pdo->rollBack();
        echo "❌ Erreur création utilisateur : " . $e->getMessage() . "\n";
    }
}

echo "\n🔥 DIAGNOSTIC TERMINÉ !\n";
echo "========================\n";

?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>🔍 Debug Session SMG</title>
    <style>
        body {
            font-family: 'Consolas', 'Monaco', monospace;
            background: #1a1a1a;
            color: #00ff00;
            padding: 20px;
            line-height: 1.4;
        }
        
        pre {
            background: #000;
            padding: 15px;
            border-radius: 8px;
            border-left: 4px solid #00ff00;
            margin: 10px 0;
            white-space: pre-wrap;
        }
        
        .success { color: #00ff00; }
        .warning { color: #ffaa00; }
        .error { color: #ff4444; }
        .info { color: #4488ff; }
        
        .actions {
            background: #2a2a2a;
            padding: 20px;
            border-radius: 8px;
            margin: 20px 0;
        }
        
        .btn {
            display: inline-block;
            padding: 10px 20px;
            margin: 5px;
            background: #667eea;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            border: none;
            cursor: pointer;
        }
        
        .btn:hover {
            background: #5a6fd8;
        }
        
        .btn-success { background: #4ecdc4; }
        .btn-warning { background: #f093fb; }
        .btn-danger { background: #ff6b6b; }
    </style>
</head>
<body>
    <h1>🔍 SMG Studio v2.0 - Diagnostic Session</h1>
    
    <div class="actions">
        <h3>🚀 Actions rapides :</h3>
        
        <?php if (!isset($_SESSION['user_id'])): ?>
            <a href="?auto_login=1" class="btn btn-success">🔐 Auto-Login Développement</a>
            <a href="?create_test_user=1" class="btn btn-warning">👤 Créer Utilisateur Test</a>
            <a href="login.php" class="btn">📝 Page de Connexion</a>
        <?php else: ?>
            <a href="posts.php" class="btn btn-success">📝 Accéder aux Posts</a>
            <a href="dashboard.php" class="btn">🏠 Dashboard</a>
        <?php endif; ?>
        
        <a href="<?= $_SERVER['PHP_SELF'] ?>" class="btn">🔄 Actualiser Diagnostic</a>
    </div>
    
    <div class="actions">
        <h3>🔧 Informations utiles :</h3>
        <p><strong>Email test :</strong> test@smg.local</p>
        <p><strong>Mot de passe :</strong> test123</p>
        <p><strong>Accès posts :</strong> Une fois connecté, accès direct à posts.php</p>
    </div>
    
    <script>
        console.log('🔍 SMG Diagnostic Active');
        
        // Auto-refresh si auto-login en cours
        <?php if (isset($_GET['auto_login']) && isset($_SESSION['user_id'])): ?>
            setTimeout(() => {
                window.location.href = 'posts.php';
            }, 2000);
        <?php endif; ?>
    </script>
</body>
</html>