<?php
/**
 * ================================================================
 * 🔧 CONFIG DATABASE SMG STUDIO v2.0 - VRAIES CREDENTIALS
 * ================================================================
 * 
 * 🎯 ENFIN LES BONNES INFOS DE PAPY 77 !
 * 💪 mysql_native_password révisé = ça marche !
 * 🚀 Plus de galère d'auth MySQL
 * 
 * 💡 BY PAPY 77 - AUDIOVIZU EDITION
 * ================================================================
 */

// ================================================================
// 🔧 VRAIES CREDENTIALS - LOCALHOST POWER !
// ================================================================

$host = 'localhost';
$dbname = 'laloedata';
$username = 'laloedata';
$password = 'PiL256Mx78!';
$charset = 'utf8mb4';

// Options PDO optimisées pour localhost
$options = [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    PDO::ATTR_EMULATE_PREPARES => false,
    PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES {$charset} COLLATE {$charset}_unicode_ci",
    PDO::ATTR_TIMEOUT => 10
];

// ================================================================
// 🚀 CONNEXION LOCALHOST - SIMPLE ET EFFICACE
// ================================================================

try {
    // DSN localhost simple
    $dsn = "mysql:host={$host};dbname={$dbname};charset={$charset}";
    $pdo = new PDO($dsn, $username, $password, $options);
    
    // Test ULTRA SIMPLE de la connexion
    $test_stmt = $pdo->query("SELECT 1 as test");
    $test_result = $test_stmt->fetch();
    
    if ($test_result && $test_result['test'] == 1) {
        // Connexion réussie !
        if (isset($_GET['debug'])) {
            echo "<div style='background: #d4edda; padding: 20px; margin: 10px; border-radius: 10px; color: #155724; border: 2px solid #c3e6cb;'>";
            echo "<h3>✅ Connexion MySQL Réussie - Localhost Power !</h3>";
            echo "<p><strong>🏠 Host :</strong> {$host}</p>";
            echo "<p><strong>🗄️ Database :</strong> {$dbname}</p>";
            echo "<p><strong>👤 User :</strong> {$username}</p>";
            echo "<p><strong>🔐 Password :</strong> " . str_repeat('*', strlen($password)) . " (✅ OK)</p>";
            
            // Infos serveur (séparées pour éviter erreurs)
            try {
                $user_stmt = $pdo->query("SELECT USER()");
                $current_user = $user_stmt->fetchColumn();
                echo "<p><strong>📊 User MySQL :</strong> {$current_user}</p>";
            } catch (Exception $e) {}
            
            try {
                $db_stmt = $pdo->query("SELECT DATABASE()");
                $current_db = $db_stmt->fetchColumn();
                echo "<p><strong>🎯 Base active :</strong> {$current_db}</p>";
            } catch (Exception $e) {}
            
            try {
                $version_stmt = $pdo->query("SELECT VERSION()");
                $mysql_version = $version_stmt->fetchColumn();
                echo "<p><strong>🚀 Version MySQL :</strong> {$mysql_version}</p>";
            } catch (Exception $e) {}
            
            echo "<p style='font-size: 12px; margin-top: 15px; color: #666;'>⏰ " . date('d/m/Y H:i:s') . " - Connexion validée !</p>";
            echo "</div>";
        }
    }
    
} catch (PDOException $e) {
    // Si ça plante encore, afficher l'erreur précise
    $error_code = $e->getCode();
    $error_message = $e->getMessage();
    
    die("
    <div style='
        font-family: -apple-system, BlinkMacSystemFont, sans-serif;
        max-width: 800px;
        margin: 50px auto;
        padding: 30px;
        background: #f8d7da;
        border: 2px solid #f5c6cb;
        border-radius: 15px;
        color: #721c24;
    '>
        <h2 style='margin-bottom: 20px; text-align: center;'>❌ Erreur Connexion MySQL</h2>
        
        <div style='background: #fff; padding: 20px; border-radius: 10px; margin: 20px 0;'>
            <h3>📋 Détails de l'erreur :</h3>
            <p><strong>Code :</strong> {$error_code}</p>
            <p><strong>Message :</strong> {$error_message}</p>
            <p><strong>Host :</strong> {$host}</p>
            <p><strong>Database :</strong> {$dbname}</p>
            <p><strong>User :</strong> {$username}</p>
            <p><strong>DSN :</strong> {$dsn}</p>
        </div>
        
        <div style='background: #fff3cd; padding: 20px; border-radius: 10px; margin: 20px 0;'>
            <h3>🤔 Mais Papy 77 a dit que ça marchait...</h3>
            <p>Si tu vois cette erreur alors que tu as révisé ton mysql_native_password, 
               c'est peut-être que :</p>
            <ul style='margin: 10px 0; padding-left: 20px;'>
                <li>Le service MySQL n'est pas démarré</li>
                <li>La base 'laloedata' n'existe pas</li>
                <li>L'user 'laloedata' n'a pas les droits</li>
                <li>Le password a changé</li>
            </ul>
        </div>
        
        <div style='text-align: center; margin-top: 30px;'>
            <p style='font-size: 12px; color: #666;'>
                SMG Studio v2.0 - Config by Papy 77<br>
                Erreur capturée le " . date('d/m/Y à H:i:s') . "
            </p>
        </div>
    </div>
    ");
}

// ================================================================
// 🎯 FONCTIONS UTILITAIRES SIMPLES
// ================================================================

function table_exists($pdo, $table_name) {
    try {
        $stmt = $pdo->prepare("SHOW TABLES LIKE ?");
        $stmt->execute([$table_name]);
        return $stmt->rowCount() > 0;
    } catch (Exception $e) {
        return false;
    }
}

function count_records($pdo, $table_name) {
    try {
        if (!table_exists($pdo, $table_name)) return 0;
        $stmt = $pdo->query("SELECT COUNT(*) FROM `{$table_name}`");
        return $stmt->fetchColumn();
    } catch (Exception $e) {
        return 0;
    }
}

// ================================================================
// 🚀 CONFIGURATION GLOBALE
// ================================================================

date_default_timezone_set('Europe/Paris');

define('DEBUG_MODE', isset($_GET['debug']));
define('DB_HOST', $host);
define('DB_NAME', $dbname);
define('DB_USER', $username);
define('DB_CHARSET', $charset);

// ================================================================
// 🔍 VÉRIFICATION RAPIDE DES TABLES SMG
// ================================================================

if (DEBUG_MODE) {
    echo "<div style='background: #e7f3ff; padding: 15px; margin: 10px; border-radius: 10px; border: 1px solid #b8daff;'>";
    echo "<h3>🔍 État Tables SMG Studio v2.0</h3>";
    
    $critical_tables = [
        'users' => 'Utilisateurs système',
        'posts' => 'Posts pour réseaux sociaux', 
        'social_platforms' => 'Plateformes configurées',
        'post_networks' => 'Association posts-réseaux',
        'scheduled_posts' => 'Programmations diffusion',
        'transmission_logs' => 'Logs transmission',
        'user_downloads' => 'Downloads utilisateur',
        'user_medias' => 'Médias utilisateur (images.php)'
    ];
    
    $missing_tables = [];
    $total_records = 0;
    
    foreach ($critical_tables as $table => $description) {
        if (table_exists($pdo, $table)) {
            $count = count_records($pdo, $table);
            $total_records += $count;
            echo "✅ <strong>{$table}</strong> : {$count} enregistrements <small>({$description})</small><br>";
        } else {
            $missing_tables[] = $table;
            echo "❌ <strong>{$table}</strong> : MANQUANTE <small>({$description})</small><br>";
        }
    }
    
    echo "<div style='background: rgba(78, 205, 196, 0.1); padding: 10px; margin: 15px 0; border-radius: 8px;'>";
    echo "📊 <strong>Total :</strong> {$total_records} enregistrements dans " . (count($critical_tables) - count($missing_tables)) . "/" . count($critical_tables) . " tables";
    echo "</div>";
    
    if (!empty($missing_tables)) {
        echo "<div style='background: #fff3cd; padding: 10px; margin: 10px 0; border-radius: 8px;'>";
        echo "⚠️ <strong>Tables manquantes :</strong> " . implode(', ', $missing_tables);
        echo "<br><small>Exécutez le script SQL simple pour les créer.</small>";
        echo "</div>";
    } else {
        echo "<div style='background: #d4edda; padding: 10px; margin: 10px 0; border-radius: 8px;'>";
        echo "🎉 <strong>Toutes les tables SMG Studio sont présentes !</strong>";
        echo "</div>";
    }
    
    echo "</div>";
}

// ================================================================
// 🎯 EXPORT GLOBAL
// ================================================================

$GLOBALS['pdo'] = $pdo;

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// ================================================================
// ✅ SMG STUDIO v2.0 READY - LOCALHOST POWER !
// ================================================================

?>