<?php
/*
 * SMG Studio v2.0 - Gestionnaire d'Authentification DASHBOARD FIRST
 * Path: /var/www/laloee-cours.fr/social-media-generator/auth.php
 */

session_start();
header('Content-Type: application/json');
require_once 'config/db.php';

$response = ['success' => false, 'message' => ''];

try {
    // Récupérer les données POST
    $email = trim($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';
    
    // Validation des données
    if (empty($email) || empty($password)) {
        throw new Exception('Email et mot de passe requis');
    }
    
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        throw new Exception('Format d\'email invalide');
    }
    
    // Log de la tentative
    $ip_address = $_SERVER['REMOTE_ADDR'] ?? 'unknown';
    $user_agent = $_SERVER['HTTP_USER_AGENT'] ?? 'unknown';
    
    // Rechercher l'utilisateur
    $stmt = $pdo->prepare("
        SELECT id, name, email, password, role, status 
        FROM users 
        WHERE email = ?
    ");
    $stmt->execute([$email]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$user) {
        // Utilisateur inexistant
        logLoginAttempt($email, $ip_address, $user_agent, false, 'user_not_found');
        throw new Exception('Email ou mot de passe incorrect');
    }
    
    // Vérifier le statut du compte
    if ($user['status'] !== 'active') {
        logLoginAttempt($email, $ip_address, $user_agent, false, 'account_disabled');
        throw new Exception('Compte désactivé. Contactez l\'administrateur');
    }
    
    // Vérifier le mot de passe
    if (!password_verify($password, $user['password'])) {
        logLoginAttempt($email, $ip_address, $user_agent, false, 'wrong_password');
        throw new Exception('Email ou mot de passe incorrect');
    }
    
    // Connexion réussie
    $_SESSION['user_id'] = $user['id'];
    $_SESSION['user_name'] = $user['name'];
    $_SESSION['user_email'] = $user['email'];
    $_SESSION['user_role'] = $user['role'];
    $_SESSION['login_time'] = time();
    
    // Régénérer l'ID de session pour sécurité
    session_regenerate_id(true);
    
    // Log de succès
    logLoginAttempt($email, $ip_address, $user_agent, true, 'success');
    
    $response['success'] = true;
    $response['message'] = 'Connexion réussie';
    $response['redirect'] = 'dashboard.php'; // 🎯 DASHBOARD EN PREMIER !
    
    // Déterminer la redirection selon le rôle (optionnel)
    switch($user['role']) {
        case 'admin':
            $response['user_type'] = 'admin';
            $response['welcome_message'] = 'Bienvenue Administrateur !';
            break;
        case 'manager':
            $response['user_type'] = 'manager';
            $response['welcome_message'] = 'Bienvenue Manager !';
            break;
        default:
            $response['user_type'] = 'user';
            $response['welcome_message'] = 'Bienvenue !';
    }
    
} catch (Exception $e) {
    $response['message'] = $e->getMessage();
    error_log("Erreur auth: " . $e->getMessage());
}

// Fonction pour logger les tentatives de connexion
function logLoginAttempt($email, $ip, $user_agent, $success, $reason) {
    global $pdo;
    
    try {
        // Créer la table si elle n'existe pas
        $pdo->exec("
            CREATE TABLE IF NOT EXISTS login_attempts (
                id INT PRIMARY KEY AUTO_INCREMENT,
                email VARCHAR(255) NOT NULL,
                ip_address VARCHAR(45),
                user_agent TEXT,
                success BOOLEAN DEFAULT FALSE,
                failure_reason VARCHAR(100),
                attempted_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                INDEX idx_email (email),
                INDEX idx_attempted_at (attempted_at)
            )
        ");
        
        $stmt = $pdo->prepare("
            INSERT INTO login_attempts 
            (email, ip_address, user_agent, success, failure_reason, attempted_at) 
            VALUES (?, ?, ?, ?, ?, NOW())
        ");
        $stmt->execute([
            $email, 
            $ip, 
            $user_agent, 
            $success ? 1 : 0, 
            $reason
        ]);
    } catch (Exception $e) {
        error_log("Erreur log login: " . $e->getMessage());
    }
}

echo json_encode($response);
?>