<?php
/**
 * ================================================================
 * 🔌 CLIPMAKER TIMELINE API
 * ================================================================
 */

require_once '../../../auth_functions.php';
requireLogin();

header('Content-Type: application/json');

$user = getCurrentUser();
$pdo = getDbConnection();
$action = $_POST['action'] ?? $_GET['action'] ?? '';

try {
    switch ($action) {
        case 'save-project':
            echo json_encode(saveTimelineProject($user, $_POST, $pdo));
            break;
            
        case 'load-project':
            echo json_encode(loadTimelineProject($user, $_POST, $pdo));
            break;
            
        case 'export-project':
            echo json_encode(exportTimelineProject($user, $_POST, $pdo));
            break;
            
        default:
            throw new Exception('Action non supportée');
    }
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}

function saveTimelineProject($user, $data, $pdo) {
    $projectId = $data['project_id'] ?? null;
    $timelineData = $data['timeline_data'] ?? [];
    
    if ($projectId) {
        $stmt = $pdo->prepare("
            UPDATE clipmaker_projects 
            SET timeline_data = ?, updated_at = NOW()
            WHERE id = ? AND user_id = ?
        ");
        $stmt->execute([
            json_encode($timelineData),
            $projectId,
            $user['id']
        ]);
    }
    
    return [
        'success' => true,
        'message' => 'Projet sauvegardé',
        'project_id' => $projectId
    ];
}

function loadTimelineProject($user, $data, $pdo) {
    $projectId = $data['project_id'] ?? null;
    
    $stmt = $pdo->prepare("
        SELECT * FROM clipmaker_projects 
        WHERE id = ? AND user_id = ?
    ");
    $stmt->execute([$projectId, $user['id']]);
    $project = $stmt->fetch(PDO::FETCH_ASSOC);
    
    return [
        'success' => true,
        'project' => $project,
        'timeline_data' => json_decode($project['timeline_data'] ?? '{}', true)
    ];
}

function exportTimelineProject($user, $data, $pdo) {
    return [
        'success' => true,
        'message' => 'Export en cours',
        'export_id' => time()
    ];
}
?>
